/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iottwinmaker.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.iottwinmaker.model.ExtendsFromCopier;
import software.amazon.awssdk.services.iottwinmaker.model.FunctionRequest;
import software.amazon.awssdk.services.iottwinmaker.model.FunctionsRequestCopier;
import software.amazon.awssdk.services.iottwinmaker.model.IoTTwinMakerRequest;
import software.amazon.awssdk.services.iottwinmaker.model.PropertyDefinitionRequest;
import software.amazon.awssdk.services.iottwinmaker.model.PropertyDefinitionsRequestCopier;
import software.amazon.awssdk.services.iottwinmaker.model.TagMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateComponentTypeRequest
extends IoTTwinMakerRequest
implements ToCopyableBuilder<Builder, CreateComponentTypeRequest> {
    private static final SdkField<String> COMPONENT_TYPE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("componentTypeId").getter(CreateComponentTypeRequest.getter(CreateComponentTypeRequest::componentTypeId)).setter(CreateComponentTypeRequest.setter(Builder::componentTypeId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("componentTypeId").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(CreateComponentTypeRequest.getter(CreateComponentTypeRequest::description)).setter(CreateComponentTypeRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<List<String>> EXTENDS_FROM_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("extendsFrom").getter(CreateComponentTypeRequest.getter(CreateComponentTypeRequest::extendsFrom)).setter(CreateComponentTypeRequest.setter(Builder::extendsFrom)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("extendsFrom").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Map<String, FunctionRequest>> FUNCTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("functions").getter(CreateComponentTypeRequest.getter(CreateComponentTypeRequest::functions)).setter(CreateComponentTypeRequest.setter(Builder::functions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("functions").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(FunctionRequest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Boolean> IS_SINGLETON_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("isSingleton").getter(CreateComponentTypeRequest.getter(CreateComponentTypeRequest::isSingleton)).setter(CreateComponentTypeRequest.setter(Builder::isSingleton)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("isSingleton").build()}).build();
    private static final SdkField<Map<String, PropertyDefinitionRequest>> PROPERTY_DEFINITIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("propertyDefinitions").getter(CreateComponentTypeRequest.getter(CreateComponentTypeRequest::propertyDefinitions)).setter(CreateComponentTypeRequest.setter(Builder::propertyDefinitions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("propertyDefinitions").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(PropertyDefinitionRequest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(CreateComponentTypeRequest.getter(CreateComponentTypeRequest::tags)).setter(CreateComponentTypeRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> WORKSPACE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("workspaceId").getter(CreateComponentTypeRequest.getter(CreateComponentTypeRequest::workspaceId)).setter(CreateComponentTypeRequest.setter(Builder::workspaceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("workspaceId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMPONENT_TYPE_ID_FIELD, DESCRIPTION_FIELD, EXTENDS_FROM_FIELD, FUNCTIONS_FIELD, IS_SINGLETON_FIELD, PROPERTY_DEFINITIONS_FIELD, TAGS_FIELD, WORKSPACE_ID_FIELD));
    private final String componentTypeId;
    private final String description;
    private final List<String> extendsFrom;
    private final Map<String, FunctionRequest> functions;
    private final Boolean isSingleton;
    private final Map<String, PropertyDefinitionRequest> propertyDefinitions;
    private final Map<String, String> tags;
    private final String workspaceId;

    private CreateComponentTypeRequest(BuilderImpl builder) {
        super(builder);
        this.componentTypeId = builder.componentTypeId;
        this.description = builder.description;
        this.extendsFrom = builder.extendsFrom;
        this.functions = builder.functions;
        this.isSingleton = builder.isSingleton;
        this.propertyDefinitions = builder.propertyDefinitions;
        this.tags = builder.tags;
        this.workspaceId = builder.workspaceId;
    }

    public final String componentTypeId() {
        return this.componentTypeId;
    }

    public final String description() {
        return this.description;
    }

    public final boolean hasExtendsFrom() {
        return this.extendsFrom != null && !(this.extendsFrom instanceof SdkAutoConstructList);
    }

    public final List<String> extendsFrom() {
        return this.extendsFrom;
    }

    public final boolean hasFunctions() {
        return this.functions != null && !(this.functions instanceof SdkAutoConstructMap);
    }

    public final Map<String, FunctionRequest> functions() {
        return this.functions;
    }

    public final Boolean isSingleton() {
        return this.isSingleton;
    }

    public final boolean hasPropertyDefinitions() {
        return this.propertyDefinitions != null && !(this.propertyDefinitions instanceof SdkAutoConstructMap);
    }

    public final Map<String, PropertyDefinitionRequest> propertyDefinitions() {
        return this.propertyDefinitions;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public final String workspaceId() {
        return this.workspaceId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.componentTypeId());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasExtendsFrom() ? this.extendsFrom() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFunctions() ? this.functions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.isSingleton());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPropertyDefinitions() ? this.propertyDefinitions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.workspaceId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateComponentTypeRequest)) {
            return false;
        }
        CreateComponentTypeRequest other = (CreateComponentTypeRequest)((Object)obj);
        return Objects.equals(this.componentTypeId(), other.componentTypeId()) && Objects.equals(this.description(), other.description()) && this.hasExtendsFrom() == other.hasExtendsFrom() && Objects.equals(this.extendsFrom(), other.extendsFrom()) && this.hasFunctions() == other.hasFunctions() && Objects.equals(this.functions(), other.functions()) && Objects.equals(this.isSingleton(), other.isSingleton()) && this.hasPropertyDefinitions() == other.hasPropertyDefinitions() && Objects.equals(this.propertyDefinitions(), other.propertyDefinitions()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.workspaceId(), other.workspaceId());
    }

    public final String toString() {
        return ToString.builder((String)"CreateComponentTypeRequest").add("ComponentTypeId", (Object)this.componentTypeId()).add("Description", (Object)this.description()).add("ExtendsFrom", this.hasExtendsFrom() ? this.extendsFrom() : null).add("Functions", this.hasFunctions() ? this.functions() : null).add("IsSingleton", (Object)this.isSingleton()).add("PropertyDefinitions", this.hasPropertyDefinitions() ? this.propertyDefinitions() : null).add("Tags", this.hasTags() ? this.tags() : null).add("WorkspaceId", (Object)this.workspaceId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "componentTypeId": {
                return Optional.ofNullable(clazz.cast(this.componentTypeId()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "extendsFrom": {
                return Optional.ofNullable(clazz.cast(this.extendsFrom()));
            }
            case "functions": {
                return Optional.ofNullable(clazz.cast(this.functions()));
            }
            case "isSingleton": {
                return Optional.ofNullable(clazz.cast(this.isSingleton()));
            }
            case "propertyDefinitions": {
                return Optional.ofNullable(clazz.cast(this.propertyDefinitions()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "workspaceId": {
                return Optional.ofNullable(clazz.cast(this.workspaceId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateComponentTypeRequest, T> g) {
        return obj -> g.apply((CreateComponentTypeRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IoTTwinMakerRequest.BuilderImpl
    implements Builder {
        private String componentTypeId;
        private String description;
        private List<String> extendsFrom = DefaultSdkAutoConstructList.getInstance();
        private Map<String, FunctionRequest> functions = DefaultSdkAutoConstructMap.getInstance();
        private Boolean isSingleton;
        private Map<String, PropertyDefinitionRequest> propertyDefinitions = DefaultSdkAutoConstructMap.getInstance();
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();
        private String workspaceId;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateComponentTypeRequest model) {
            super(model);
            this.componentTypeId(model.componentTypeId);
            this.description(model.description);
            this.extendsFrom(model.extendsFrom);
            this.functions(model.functions);
            this.isSingleton(model.isSingleton);
            this.propertyDefinitions(model.propertyDefinitions);
            this.tags(model.tags);
            this.workspaceId(model.workspaceId);
        }

        public final String getComponentTypeId() {
            return this.componentTypeId;
        }

        public final void setComponentTypeId(String componentTypeId) {
            this.componentTypeId = componentTypeId;
        }

        @Override
        @Transient
        public final Builder componentTypeId(String componentTypeId) {
            this.componentTypeId = componentTypeId;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        @Transient
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Collection<String> getExtendsFrom() {
            if (this.extendsFrom instanceof SdkAutoConstructList) {
                return null;
            }
            return this.extendsFrom;
        }

        public final void setExtendsFrom(Collection<String> extendsFrom) {
            this.extendsFrom = ExtendsFromCopier.copy(extendsFrom);
        }

        @Override
        @Transient
        public final Builder extendsFrom(Collection<String> extendsFrom) {
            this.extendsFrom = ExtendsFromCopier.copy(extendsFrom);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder extendsFrom(String ... extendsFrom) {
            this.extendsFrom(Arrays.asList(extendsFrom));
            return this;
        }

        public final Map<String, FunctionRequest.Builder> getFunctions() {
            Map<String, FunctionRequest.Builder> result = FunctionsRequestCopier.copyToBuilder(this.functions);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setFunctions(Map<String, FunctionRequest.BuilderImpl> functions) {
            this.functions = FunctionsRequestCopier.copyFromBuilder(functions);
        }

        @Override
        @Transient
        public final Builder functions(Map<String, FunctionRequest> functions) {
            this.functions = FunctionsRequestCopier.copy(functions);
            return this;
        }

        public final Boolean getIsSingleton() {
            return this.isSingleton;
        }

        public final void setIsSingleton(Boolean isSingleton) {
            this.isSingleton = isSingleton;
        }

        @Override
        @Transient
        public final Builder isSingleton(Boolean isSingleton) {
            this.isSingleton = isSingleton;
            return this;
        }

        public final Map<String, PropertyDefinitionRequest.Builder> getPropertyDefinitions() {
            Map<String, PropertyDefinitionRequest.Builder> result = PropertyDefinitionsRequestCopier.copyToBuilder(this.propertyDefinitions);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setPropertyDefinitions(Map<String, PropertyDefinitionRequest.BuilderImpl> propertyDefinitions) {
            this.propertyDefinitions = PropertyDefinitionsRequestCopier.copyFromBuilder(propertyDefinitions);
        }

        @Override
        @Transient
        public final Builder propertyDefinitions(Map<String, PropertyDefinitionRequest> propertyDefinitions) {
            this.propertyDefinitions = PropertyDefinitionsRequestCopier.copy(propertyDefinitions);
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        @Transient
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final String getWorkspaceId() {
            return this.workspaceId;
        }

        public final void setWorkspaceId(String workspaceId) {
            this.workspaceId = workspaceId;
        }

        @Override
        @Transient
        public final Builder workspaceId(String workspaceId) {
            this.workspaceId = workspaceId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateComponentTypeRequest build() {
            return new CreateComponentTypeRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends IoTTwinMakerRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateComponentTypeRequest> {
        public Builder componentTypeId(String var1);

        public Builder description(String var1);

        public Builder extendsFrom(Collection<String> var1);

        public Builder extendsFrom(String ... var1);

        public Builder functions(Map<String, FunctionRequest> var1);

        public Builder isSingleton(Boolean var1);

        public Builder propertyDefinitions(Map<String, PropertyDefinitionRequest> var1);

        public Builder tags(Map<String, String> var1);

        public Builder workspaceId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

