/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iottwinmaker.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iottwinmaker.model.InterpolationType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class InterpolationParameters
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, InterpolationParameters> {
    private static final SdkField<String> INTERPOLATION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("interpolationType").getter(InterpolationParameters.getter(InterpolationParameters::interpolationTypeAsString)).setter(InterpolationParameters.setter(Builder::interpolationType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("interpolationType").build()}).build();
    private static final SdkField<Long> INTERVAL_IN_SECONDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("intervalInSeconds").getter(InterpolationParameters.getter(InterpolationParameters::intervalInSeconds)).setter(InterpolationParameters.setter(Builder::intervalInSeconds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("intervalInSeconds").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INTERPOLATION_TYPE_FIELD, INTERVAL_IN_SECONDS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String interpolationType;
    private final Long intervalInSeconds;

    private InterpolationParameters(BuilderImpl builder) {
        this.interpolationType = builder.interpolationType;
        this.intervalInSeconds = builder.intervalInSeconds;
    }

    public final InterpolationType interpolationType() {
        return InterpolationType.fromValue(this.interpolationType);
    }

    public final String interpolationTypeAsString() {
        return this.interpolationType;
    }

    public final Long intervalInSeconds() {
        return this.intervalInSeconds;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.interpolationTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.intervalInSeconds());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InterpolationParameters)) {
            return false;
        }
        InterpolationParameters other = (InterpolationParameters)obj;
        return Objects.equals(this.interpolationTypeAsString(), other.interpolationTypeAsString()) && Objects.equals(this.intervalInSeconds(), other.intervalInSeconds());
    }

    public final String toString() {
        return ToString.builder((String)"InterpolationParameters").add("InterpolationType", (Object)this.interpolationTypeAsString()).add("IntervalInSeconds", (Object)this.intervalInSeconds()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "interpolationType": {
                return Optional.ofNullable(clazz.cast(this.interpolationTypeAsString()));
            }
            case "intervalInSeconds": {
                return Optional.ofNullable(clazz.cast(this.intervalInSeconds()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<InterpolationParameters, T> g) {
        return obj -> g.apply((InterpolationParameters)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String interpolationType;
        private Long intervalInSeconds;

        private BuilderImpl() {
        }

        private BuilderImpl(InterpolationParameters model) {
            this.interpolationType(model.interpolationType);
            this.intervalInSeconds(model.intervalInSeconds);
        }

        public final String getInterpolationType() {
            return this.interpolationType;
        }

        public final void setInterpolationType(String interpolationType) {
            this.interpolationType = interpolationType;
        }

        @Override
        @Transient
        public final Builder interpolationType(String interpolationType) {
            this.interpolationType = interpolationType;
            return this;
        }

        @Override
        @Transient
        public final Builder interpolationType(InterpolationType interpolationType) {
            this.interpolationType(interpolationType == null ? null : interpolationType.toString());
            return this;
        }

        public final Long getIntervalInSeconds() {
            return this.intervalInSeconds;
        }

        public final void setIntervalInSeconds(Long intervalInSeconds) {
            this.intervalInSeconds = intervalInSeconds;
        }

        @Override
        @Transient
        public final Builder intervalInSeconds(Long intervalInSeconds) {
            this.intervalInSeconds = intervalInSeconds;
            return this;
        }

        public InterpolationParameters build() {
            return new InterpolationParameters(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, InterpolationParameters> {
        public Builder interpolationType(String var1);

        public Builder interpolationType(InterpolationType var1);

        public Builder intervalInSeconds(Long var1);
    }
}

