/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotthingsgraph.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MetricsConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, MetricsConfiguration> {
    private static final SdkField<Boolean> CLOUD_METRIC_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(MetricsConfiguration.getter(MetricsConfiguration::cloudMetricEnabled)).setter(MetricsConfiguration.setter(Builder::cloudMetricEnabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cloudMetricEnabled").build()}).build();
    private static final SdkField<String> METRIC_RULE_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(MetricsConfiguration.getter(MetricsConfiguration::metricRuleRoleArn)).setter(MetricsConfiguration.setter(Builder::metricRuleRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metricRuleRoleArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLOUD_METRIC_ENABLED_FIELD, METRIC_RULE_ROLE_ARN_FIELD));
    private static final long serialVersionUID = 1L;
    private final Boolean cloudMetricEnabled;
    private final String metricRuleRoleArn;

    private MetricsConfiguration(BuilderImpl builder) {
        this.cloudMetricEnabled = builder.cloudMetricEnabled;
        this.metricRuleRoleArn = builder.metricRuleRoleArn;
    }

    public Boolean cloudMetricEnabled() {
        return this.cloudMetricEnabled;
    }

    public String metricRuleRoleArn() {
        return this.metricRuleRoleArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.cloudMetricEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.metricRuleRoleArn());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MetricsConfiguration)) {
            return false;
        }
        MetricsConfiguration other = (MetricsConfiguration)obj;
        return Objects.equals(this.cloudMetricEnabled(), other.cloudMetricEnabled()) && Objects.equals(this.metricRuleRoleArn(), other.metricRuleRoleArn());
    }

    public String toString() {
        return ToString.builder((String)"MetricsConfiguration").add("CloudMetricEnabled", (Object)this.cloudMetricEnabled()).add("MetricRuleRoleArn", (Object)this.metricRuleRoleArn()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "cloudMetricEnabled": {
                return Optional.ofNullable(clazz.cast(this.cloudMetricEnabled()));
            }
            case "metricRuleRoleArn": {
                return Optional.ofNullable(clazz.cast(this.metricRuleRoleArn()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<MetricsConfiguration, T> g) {
        return obj -> g.apply((MetricsConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Boolean cloudMetricEnabled;
        private String metricRuleRoleArn;

        private BuilderImpl() {
        }

        private BuilderImpl(MetricsConfiguration model) {
            this.cloudMetricEnabled(model.cloudMetricEnabled);
            this.metricRuleRoleArn(model.metricRuleRoleArn);
        }

        public final Boolean getCloudMetricEnabled() {
            return this.cloudMetricEnabled;
        }

        @Override
        public final Builder cloudMetricEnabled(Boolean cloudMetricEnabled) {
            this.cloudMetricEnabled = cloudMetricEnabled;
            return this;
        }

        public final void setCloudMetricEnabled(Boolean cloudMetricEnabled) {
            this.cloudMetricEnabled = cloudMetricEnabled;
        }

        public final String getMetricRuleRoleArn() {
            return this.metricRuleRoleArn;
        }

        @Override
        public final Builder metricRuleRoleArn(String metricRuleRoleArn) {
            this.metricRuleRoleArn = metricRuleRoleArn;
            return this;
        }

        public final void setMetricRuleRoleArn(String metricRuleRoleArn) {
            this.metricRuleRoleArn = metricRuleRoleArn;
        }

        public MetricsConfiguration build() {
            return new MetricsConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, MetricsConfiguration> {
        public Builder cloudMetricEnabled(Boolean var1);

        public Builder metricRuleRoleArn(String var1);
    }
}

