/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotthingsgraph.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.iotthingsgraph.IoTThingsGraphAsyncClient;
import software.amazon.awssdk.services.iotthingsgraph.model.SearchThingsRequest;
import software.amazon.awssdk.services.iotthingsgraph.model.SearchThingsResponse;
import software.amazon.awssdk.services.iotthingsgraph.model.Thing;

public class SearchThingsPublisher
implements SdkPublisher<SearchThingsResponse> {
    private final IoTThingsGraphAsyncClient client;
    private final SearchThingsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public SearchThingsPublisher(IoTThingsGraphAsyncClient client, SearchThingsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private SearchThingsPublisher(IoTThingsGraphAsyncClient client, SearchThingsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new SearchThingsResponseFetcher();
    }

    public void subscribe(Subscriber<? super SearchThingsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<Thing> things() {
        Function<SearchThingsResponse, Iterator> getIterator = response -> {
            if (response != null && response.things() != null) {
                return response.things().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new SearchThingsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class SearchThingsResponseFetcher
    implements AsyncPageFetcher<SearchThingsResponse> {
        private SearchThingsResponseFetcher() {
        }

        public boolean hasNextPage(SearchThingsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<SearchThingsResponse> nextPage(SearchThingsResponse previousPage) {
            if (previousPage == null) {
                return SearchThingsPublisher.this.client.searchThings(SearchThingsPublisher.this.firstRequest);
            }
            return SearchThingsPublisher.this.client.searchThings((SearchThingsRequest)((Object)SearchThingsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

