/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotthingsgraph.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iotthingsgraph.model.IoTThingsGraphResponse;
import software.amazon.awssdk.services.iotthingsgraph.model.SystemInstanceSummary;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeploySystemInstanceResponse
extends IoTThingsGraphResponse
implements ToCopyableBuilder<Builder, DeploySystemInstanceResponse> {
    private static final SdkField<SystemInstanceSummary> SUMMARY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("summary").getter(DeploySystemInstanceResponse.getter(DeploySystemInstanceResponse::summary)).setter(DeploySystemInstanceResponse.setter(Builder::summary)).constructor(SystemInstanceSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("summary").build()}).build();
    private static final SdkField<String> GREENGRASS_DEPLOYMENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("greengrassDeploymentId").getter(DeploySystemInstanceResponse.getter(DeploySystemInstanceResponse::greengrassDeploymentId)).setter(DeploySystemInstanceResponse.setter(Builder::greengrassDeploymentId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("greengrassDeploymentId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SUMMARY_FIELD, GREENGRASS_DEPLOYMENT_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("summary", SUMMARY_FIELD);
            this.put("greengrassDeploymentId", GREENGRASS_DEPLOYMENT_ID_FIELD);
        }
    });
    private final SystemInstanceSummary summary;
    private final String greengrassDeploymentId;

    private DeploySystemInstanceResponse(BuilderImpl builder) {
        super(builder);
        this.summary = builder.summary;
        this.greengrassDeploymentId = builder.greengrassDeploymentId;
    }

    public final SystemInstanceSummary summary() {
        return this.summary;
    }

    public final String greengrassDeploymentId() {
        return this.greengrassDeploymentId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.summary());
        hashCode = 31 * hashCode + Objects.hashCode(this.greengrassDeploymentId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeploySystemInstanceResponse)) {
            return false;
        }
        DeploySystemInstanceResponse other = (DeploySystemInstanceResponse)((Object)obj);
        return Objects.equals(this.summary(), other.summary()) && Objects.equals(this.greengrassDeploymentId(), other.greengrassDeploymentId());
    }

    public final String toString() {
        return ToString.builder((String)"DeploySystemInstanceResponse").add("Summary", (Object)this.summary()).add("GreengrassDeploymentId", (Object)this.greengrassDeploymentId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "summary": {
                return Optional.ofNullable(clazz.cast(this.summary()));
            }
            case "greengrassDeploymentId": {
                return Optional.ofNullable(clazz.cast(this.greengrassDeploymentId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DeploySystemInstanceResponse, T> g) {
        return obj -> g.apply((DeploySystemInstanceResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IoTThingsGraphResponse.BuilderImpl
    implements Builder {
        private SystemInstanceSummary summary;
        private String greengrassDeploymentId;

        private BuilderImpl() {
        }

        private BuilderImpl(DeploySystemInstanceResponse model) {
            super(model);
            this.summary(model.summary);
            this.greengrassDeploymentId(model.greengrassDeploymentId);
        }

        public final SystemInstanceSummary.Builder getSummary() {
            return this.summary != null ? this.summary.toBuilder() : null;
        }

        public final void setSummary(SystemInstanceSummary.BuilderImpl summary) {
            this.summary = summary != null ? summary.build() : null;
        }

        @Override
        public final Builder summary(SystemInstanceSummary summary) {
            this.summary = summary;
            return this;
        }

        public final String getGreengrassDeploymentId() {
            return this.greengrassDeploymentId;
        }

        public final void setGreengrassDeploymentId(String greengrassDeploymentId) {
            this.greengrassDeploymentId = greengrassDeploymentId;
        }

        @Override
        public final Builder greengrassDeploymentId(String greengrassDeploymentId) {
            this.greengrassDeploymentId = greengrassDeploymentId;
            return this;
        }

        @Override
        public DeploySystemInstanceResponse build() {
            return new DeploySystemInstanceResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends IoTThingsGraphResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DeploySystemInstanceResponse> {
        public Builder summary(SystemInstanceSummary var1);

        default public Builder summary(Consumer<SystemInstanceSummary.Builder> summary) {
            return this.summary((SystemInstanceSummary)((SystemInstanceSummary.Builder)SystemInstanceSummary.builder().applyMutation(summary)).build());
        }

        public Builder greengrassDeploymentId(String var1);
    }
}

