/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotsitewise.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iotsitewise.model.IoTSiteWiseRequest;
import software.amazon.awssdk.services.iotsitewise.model.PropertyMappingConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PutAssetModelInterfaceRelationshipRequest
extends IoTSiteWiseRequest
implements ToCopyableBuilder<Builder, PutAssetModelInterfaceRelationshipRequest> {
    private static final SdkField<String> ASSET_MODEL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("assetModelId").getter(PutAssetModelInterfaceRelationshipRequest.getter(PutAssetModelInterfaceRelationshipRequest::assetModelId)).setter(PutAssetModelInterfaceRelationshipRequest.setter(Builder::assetModelId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("assetModelId").build()}).build();
    private static final SdkField<String> INTERFACE_ASSET_MODEL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("interfaceAssetModelId").getter(PutAssetModelInterfaceRelationshipRequest.getter(PutAssetModelInterfaceRelationshipRequest::interfaceAssetModelId)).setter(PutAssetModelInterfaceRelationshipRequest.setter(Builder::interfaceAssetModelId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("interfaceAssetModelId").build()}).build();
    private static final SdkField<PropertyMappingConfiguration> PROPERTY_MAPPING_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("propertyMappingConfiguration").getter(PutAssetModelInterfaceRelationshipRequest.getter(PutAssetModelInterfaceRelationshipRequest::propertyMappingConfiguration)).setter(PutAssetModelInterfaceRelationshipRequest.setter(Builder::propertyMappingConfiguration)).constructor(PropertyMappingConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("propertyMappingConfiguration").build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientToken").getter(PutAssetModelInterfaceRelationshipRequest.getter(PutAssetModelInterfaceRelationshipRequest::clientToken)).setter(PutAssetModelInterfaceRelationshipRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSET_MODEL_ID_FIELD, INTERFACE_ASSET_MODEL_ID_FIELD, PROPERTY_MAPPING_CONFIGURATION_FIELD, CLIENT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = PutAssetModelInterfaceRelationshipRequest.memberNameToFieldInitializer();
    private final String assetModelId;
    private final String interfaceAssetModelId;
    private final PropertyMappingConfiguration propertyMappingConfiguration;
    private final String clientToken;

    private PutAssetModelInterfaceRelationshipRequest(BuilderImpl builder) {
        super(builder);
        this.assetModelId = builder.assetModelId;
        this.interfaceAssetModelId = builder.interfaceAssetModelId;
        this.propertyMappingConfiguration = builder.propertyMappingConfiguration;
        this.clientToken = builder.clientToken;
    }

    public final String assetModelId() {
        return this.assetModelId;
    }

    public final String interfaceAssetModelId() {
        return this.interfaceAssetModelId;
    }

    public final PropertyMappingConfiguration propertyMappingConfiguration() {
        return this.propertyMappingConfiguration;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.assetModelId());
        hashCode = 31 * hashCode + Objects.hashCode(this.interfaceAssetModelId());
        hashCode = 31 * hashCode + Objects.hashCode(this.propertyMappingConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutAssetModelInterfaceRelationshipRequest)) {
            return false;
        }
        PutAssetModelInterfaceRelationshipRequest other = (PutAssetModelInterfaceRelationshipRequest)((Object)obj);
        return Objects.equals(this.assetModelId(), other.assetModelId()) && Objects.equals(this.interfaceAssetModelId(), other.interfaceAssetModelId()) && Objects.equals(this.propertyMappingConfiguration(), other.propertyMappingConfiguration()) && Objects.equals(this.clientToken(), other.clientToken());
    }

    public final String toString() {
        return ToString.builder((String)"PutAssetModelInterfaceRelationshipRequest").add("AssetModelId", (Object)this.assetModelId()).add("InterfaceAssetModelId", (Object)this.interfaceAssetModelId()).add("PropertyMappingConfiguration", (Object)this.propertyMappingConfiguration()).add("ClientToken", (Object)this.clientToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "assetModelId": {
                return Optional.ofNullable(clazz.cast(this.assetModelId()));
            }
            case "interfaceAssetModelId": {
                return Optional.ofNullable(clazz.cast(this.interfaceAssetModelId()));
            }
            case "propertyMappingConfiguration": {
                return Optional.ofNullable(clazz.cast(this.propertyMappingConfiguration()));
            }
            case "clientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("assetModelId", ASSET_MODEL_ID_FIELD);
        map.put("interfaceAssetModelId", INTERFACE_ASSET_MODEL_ID_FIELD);
        map.put("propertyMappingConfiguration", PROPERTY_MAPPING_CONFIGURATION_FIELD);
        map.put("clientToken", CLIENT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PutAssetModelInterfaceRelationshipRequest, T> g) {
        return obj -> g.apply((PutAssetModelInterfaceRelationshipRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IoTSiteWiseRequest.BuilderImpl
    implements Builder {
        private String assetModelId;
        private String interfaceAssetModelId;
        private PropertyMappingConfiguration propertyMappingConfiguration;
        private String clientToken;

        private BuilderImpl() {
        }

        private BuilderImpl(PutAssetModelInterfaceRelationshipRequest model) {
            super(model);
            this.assetModelId(model.assetModelId);
            this.interfaceAssetModelId(model.interfaceAssetModelId);
            this.propertyMappingConfiguration(model.propertyMappingConfiguration);
            this.clientToken(model.clientToken);
        }

        public final String getAssetModelId() {
            return this.assetModelId;
        }

        public final void setAssetModelId(String assetModelId) {
            this.assetModelId = assetModelId;
        }

        @Override
        public final Builder assetModelId(String assetModelId) {
            this.assetModelId = assetModelId;
            return this;
        }

        public final String getInterfaceAssetModelId() {
            return this.interfaceAssetModelId;
        }

        public final void setInterfaceAssetModelId(String interfaceAssetModelId) {
            this.interfaceAssetModelId = interfaceAssetModelId;
        }

        @Override
        public final Builder interfaceAssetModelId(String interfaceAssetModelId) {
            this.interfaceAssetModelId = interfaceAssetModelId;
            return this;
        }

        public final PropertyMappingConfiguration.Builder getPropertyMappingConfiguration() {
            return this.propertyMappingConfiguration != null ? this.propertyMappingConfiguration.toBuilder() : null;
        }

        public final void setPropertyMappingConfiguration(PropertyMappingConfiguration.BuilderImpl propertyMappingConfiguration) {
            this.propertyMappingConfiguration = propertyMappingConfiguration != null ? propertyMappingConfiguration.build() : null;
        }

        @Override
        public final Builder propertyMappingConfiguration(PropertyMappingConfiguration propertyMappingConfiguration) {
            this.propertyMappingConfiguration = propertyMappingConfiguration;
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutAssetModelInterfaceRelationshipRequest build() {
            return new PutAssetModelInterfaceRelationshipRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends IoTSiteWiseRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, PutAssetModelInterfaceRelationshipRequest> {
        public Builder assetModelId(String var1);

        public Builder interfaceAssetModelId(String var1);

        public Builder propertyMappingConfiguration(PropertyMappingConfiguration var1);

        default public Builder propertyMappingConfiguration(Consumer<PropertyMappingConfiguration.Builder> propertyMappingConfiguration) {
            return this.propertyMappingConfiguration((PropertyMappingConfiguration)((PropertyMappingConfiguration.Builder)PropertyMappingConfiguration.builder().applyMutation(propertyMappingConfiguration)).build());
        }

        public Builder clientToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

