/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotsitewise.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.iotsitewise.model.PropertyMapping;
import software.amazon.awssdk.services.iotsitewise.model.PropertyMappingsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PropertyMappingConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PropertyMappingConfiguration> {
    private static final SdkField<Boolean> MATCH_BY_PROPERTY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("matchByPropertyName").getter(PropertyMappingConfiguration.getter(PropertyMappingConfiguration::matchByPropertyName)).setter(PropertyMappingConfiguration.setter(Builder::matchByPropertyName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("matchByPropertyName").build()}).build();
    private static final SdkField<Boolean> CREATE_MISSING_PROPERTY_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("createMissingProperty").getter(PropertyMappingConfiguration.getter(PropertyMappingConfiguration::createMissingProperty)).setter(PropertyMappingConfiguration.setter(Builder::createMissingProperty)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createMissingProperty").build()}).build();
    private static final SdkField<List<PropertyMapping>> OVERRIDES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("overrides").getter(PropertyMappingConfiguration.getter(PropertyMappingConfiguration::overrides)).setter(PropertyMappingConfiguration.setter(Builder::overrides)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("overrides").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(PropertyMapping::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MATCH_BY_PROPERTY_NAME_FIELD, CREATE_MISSING_PROPERTY_FIELD, OVERRIDES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = PropertyMappingConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Boolean matchByPropertyName;
    private final Boolean createMissingProperty;
    private final List<PropertyMapping> overrides;

    private PropertyMappingConfiguration(BuilderImpl builder) {
        this.matchByPropertyName = builder.matchByPropertyName;
        this.createMissingProperty = builder.createMissingProperty;
        this.overrides = builder.overrides;
    }

    public final Boolean matchByPropertyName() {
        return this.matchByPropertyName;
    }

    public final Boolean createMissingProperty() {
        return this.createMissingProperty;
    }

    public final boolean hasOverrides() {
        return this.overrides != null && !(this.overrides instanceof SdkAutoConstructList);
    }

    public final List<PropertyMapping> overrides() {
        return this.overrides;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.matchByPropertyName());
        hashCode = 31 * hashCode + Objects.hashCode(this.createMissingProperty());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasOverrides() ? this.overrides() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PropertyMappingConfiguration)) {
            return false;
        }
        PropertyMappingConfiguration other = (PropertyMappingConfiguration)obj;
        return Objects.equals(this.matchByPropertyName(), other.matchByPropertyName()) && Objects.equals(this.createMissingProperty(), other.createMissingProperty()) && this.hasOverrides() == other.hasOverrides() && Objects.equals(this.overrides(), other.overrides());
    }

    public final String toString() {
        return ToString.builder((String)"PropertyMappingConfiguration").add("MatchByPropertyName", (Object)this.matchByPropertyName()).add("CreateMissingProperty", (Object)this.createMissingProperty()).add("Overrides", this.hasOverrides() ? this.overrides() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "matchByPropertyName": {
                return Optional.ofNullable(clazz.cast(this.matchByPropertyName()));
            }
            case "createMissingProperty": {
                return Optional.ofNullable(clazz.cast(this.createMissingProperty()));
            }
            case "overrides": {
                return Optional.ofNullable(clazz.cast(this.overrides()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("matchByPropertyName", MATCH_BY_PROPERTY_NAME_FIELD);
        map.put("createMissingProperty", CREATE_MISSING_PROPERTY_FIELD);
        map.put("overrides", OVERRIDES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PropertyMappingConfiguration, T> g) {
        return obj -> g.apply((PropertyMappingConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Boolean matchByPropertyName;
        private Boolean createMissingProperty;
        private List<PropertyMapping> overrides = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PropertyMappingConfiguration model) {
            this.matchByPropertyName(model.matchByPropertyName);
            this.createMissingProperty(model.createMissingProperty);
            this.overrides(model.overrides);
        }

        public final Boolean getMatchByPropertyName() {
            return this.matchByPropertyName;
        }

        public final void setMatchByPropertyName(Boolean matchByPropertyName) {
            this.matchByPropertyName = matchByPropertyName;
        }

        @Override
        public final Builder matchByPropertyName(Boolean matchByPropertyName) {
            this.matchByPropertyName = matchByPropertyName;
            return this;
        }

        public final Boolean getCreateMissingProperty() {
            return this.createMissingProperty;
        }

        public final void setCreateMissingProperty(Boolean createMissingProperty) {
            this.createMissingProperty = createMissingProperty;
        }

        @Override
        public final Builder createMissingProperty(Boolean createMissingProperty) {
            this.createMissingProperty = createMissingProperty;
            return this;
        }

        public final List<PropertyMapping.Builder> getOverrides() {
            List<PropertyMapping.Builder> result = PropertyMappingsCopier.copyToBuilder(this.overrides);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setOverrides(Collection<PropertyMapping.BuilderImpl> overrides) {
            this.overrides = PropertyMappingsCopier.copyFromBuilder(overrides);
        }

        @Override
        public final Builder overrides(Collection<PropertyMapping> overrides) {
            this.overrides = PropertyMappingsCopier.copy(overrides);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder overrides(PropertyMapping ... overrides) {
            this.overrides(Arrays.asList(overrides));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder overrides(Consumer<PropertyMapping.Builder> ... overrides) {
            this.overrides(Stream.of(overrides).map(c -> (PropertyMapping)((PropertyMapping.Builder)PropertyMapping.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public PropertyMappingConfiguration build() {
            return new PropertyMappingConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PropertyMappingConfiguration> {
        public Builder matchByPropertyName(Boolean var1);

        public Builder createMissingProperty(Boolean var1);

        public Builder overrides(Collection<PropertyMapping> var1);

        public Builder overrides(PropertyMapping ... var1);

        public Builder overrides(Consumer<PropertyMapping.Builder> ... var1);
    }
}

