/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotsitewise.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iotsitewise.model.IoTSiteWiseRequest;
import software.amazon.awssdk.services.iotsitewise.model.ResolveToResourceType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeComputationModelExecutionSummaryRequest
extends IoTSiteWiseRequest
implements ToCopyableBuilder<Builder, DescribeComputationModelExecutionSummaryRequest> {
    private static final SdkField<String> COMPUTATION_MODEL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("computationModelId").getter(DescribeComputationModelExecutionSummaryRequest.getter(DescribeComputationModelExecutionSummaryRequest::computationModelId)).setter(DescribeComputationModelExecutionSummaryRequest.setter(Builder::computationModelId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("computationModelId").build()}).build();
    private static final SdkField<String> RESOLVE_TO_RESOURCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("resolveToResourceType").getter(DescribeComputationModelExecutionSummaryRequest.getter(DescribeComputationModelExecutionSummaryRequest::resolveToResourceTypeAsString)).setter(DescribeComputationModelExecutionSummaryRequest.setter(Builder::resolveToResourceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("resolveToResourceType").build()}).build();
    private static final SdkField<String> RESOLVE_TO_RESOURCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("resolveToResourceId").getter(DescribeComputationModelExecutionSummaryRequest.getter(DescribeComputationModelExecutionSummaryRequest::resolveToResourceId)).setter(DescribeComputationModelExecutionSummaryRequest.setter(Builder::resolveToResourceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("resolveToResourceId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMPUTATION_MODEL_ID_FIELD, RESOLVE_TO_RESOURCE_TYPE_FIELD, RESOLVE_TO_RESOURCE_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeComputationModelExecutionSummaryRequest.memberNameToFieldInitializer();
    private final String computationModelId;
    private final String resolveToResourceType;
    private final String resolveToResourceId;

    private DescribeComputationModelExecutionSummaryRequest(BuilderImpl builder) {
        super(builder);
        this.computationModelId = builder.computationModelId;
        this.resolveToResourceType = builder.resolveToResourceType;
        this.resolveToResourceId = builder.resolveToResourceId;
    }

    public final String computationModelId() {
        return this.computationModelId;
    }

    public final ResolveToResourceType resolveToResourceType() {
        return ResolveToResourceType.fromValue(this.resolveToResourceType);
    }

    public final String resolveToResourceTypeAsString() {
        return this.resolveToResourceType;
    }

    public final String resolveToResourceId() {
        return this.resolveToResourceId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.computationModelId());
        hashCode = 31 * hashCode + Objects.hashCode(this.resolveToResourceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.resolveToResourceId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeComputationModelExecutionSummaryRequest)) {
            return false;
        }
        DescribeComputationModelExecutionSummaryRequest other = (DescribeComputationModelExecutionSummaryRequest)((Object)obj);
        return Objects.equals(this.computationModelId(), other.computationModelId()) && Objects.equals(this.resolveToResourceTypeAsString(), other.resolveToResourceTypeAsString()) && Objects.equals(this.resolveToResourceId(), other.resolveToResourceId());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeComputationModelExecutionSummaryRequest").add("ComputationModelId", (Object)this.computationModelId()).add("ResolveToResourceType", (Object)this.resolveToResourceTypeAsString()).add("ResolveToResourceId", (Object)this.resolveToResourceId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "computationModelId": {
                return Optional.ofNullable(clazz.cast(this.computationModelId()));
            }
            case "resolveToResourceType": {
                return Optional.ofNullable(clazz.cast(this.resolveToResourceTypeAsString()));
            }
            case "resolveToResourceId": {
                return Optional.ofNullable(clazz.cast(this.resolveToResourceId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("computationModelId", COMPUTATION_MODEL_ID_FIELD);
        map.put("resolveToResourceType", RESOLVE_TO_RESOURCE_TYPE_FIELD);
        map.put("resolveToResourceId", RESOLVE_TO_RESOURCE_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeComputationModelExecutionSummaryRequest, T> g) {
        return obj -> g.apply((DescribeComputationModelExecutionSummaryRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IoTSiteWiseRequest.BuilderImpl
    implements Builder {
        private String computationModelId;
        private String resolveToResourceType;
        private String resolveToResourceId;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeComputationModelExecutionSummaryRequest model) {
            super(model);
            this.computationModelId(model.computationModelId);
            this.resolveToResourceType(model.resolveToResourceType);
            this.resolveToResourceId(model.resolveToResourceId);
        }

        public final String getComputationModelId() {
            return this.computationModelId;
        }

        public final void setComputationModelId(String computationModelId) {
            this.computationModelId = computationModelId;
        }

        @Override
        public final Builder computationModelId(String computationModelId) {
            this.computationModelId = computationModelId;
            return this;
        }

        public final String getResolveToResourceType() {
            return this.resolveToResourceType;
        }

        public final void setResolveToResourceType(String resolveToResourceType) {
            this.resolveToResourceType = resolveToResourceType;
        }

        @Override
        public final Builder resolveToResourceType(String resolveToResourceType) {
            this.resolveToResourceType = resolveToResourceType;
            return this;
        }

        @Override
        public final Builder resolveToResourceType(ResolveToResourceType resolveToResourceType) {
            this.resolveToResourceType(resolveToResourceType == null ? null : resolveToResourceType.toString());
            return this;
        }

        public final String getResolveToResourceId() {
            return this.resolveToResourceId;
        }

        public final void setResolveToResourceId(String resolveToResourceId) {
            this.resolveToResourceId = resolveToResourceId;
        }

        @Override
        public final Builder resolveToResourceId(String resolveToResourceId) {
            this.resolveToResourceId = resolveToResourceId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeComputationModelExecutionSummaryRequest build() {
            return new DescribeComputationModelExecutionSummaryRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends IoTSiteWiseRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeComputationModelExecutionSummaryRequest> {
        public Builder computationModelId(String var1);

        public Builder resolveToResourceType(String var1);

        public Builder resolveToResourceType(ResolveToResourceType var1);

        public Builder resolveToResourceId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

