/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotsitewise.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateAssetRequest extends IoTSiteWiseRequest implements
        ToCopyableBuilder<UpdateAssetRequest.Builder, UpdateAssetRequest> {
    private static final SdkField<String> ASSET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("assetId").getter(getter(UpdateAssetRequest::assetId)).setter(setter(Builder::assetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("assetId").build()).build();

    private static final SdkField<String> ASSET_EXTERNAL_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("assetExternalId").getter(getter(UpdateAssetRequest::assetExternalId))
            .setter(setter(Builder::assetExternalId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assetExternalId").build()).build();

    private static final SdkField<String> ASSET_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("assetName").getter(getter(UpdateAssetRequest::assetName)).setter(setter(Builder::assetName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assetName").build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("clientToken")
            .getter(getter(UpdateAssetRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<String> ASSET_DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("assetDescription").getter(getter(UpdateAssetRequest::assetDescription))
            .setter(setter(Builder::assetDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assetDescription").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSET_ID_FIELD,
            ASSET_EXTERNAL_ID_FIELD, ASSET_NAME_FIELD, CLIENT_TOKEN_FIELD, ASSET_DESCRIPTION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String assetId;

    private final String assetExternalId;

    private final String assetName;

    private final String clientToken;

    private final String assetDescription;

    private UpdateAssetRequest(BuilderImpl builder) {
        super(builder);
        this.assetId = builder.assetId;
        this.assetExternalId = builder.assetExternalId;
        this.assetName = builder.assetName;
        this.clientToken = builder.clientToken;
        this.assetDescription = builder.assetDescription;
    }

    /**
     * <p>
     * The ID of the asset to update. This can be either the actual ID in UUID format, or else <code>externalId:</code>
     * followed by the external ID, if it has one. For more information, see <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/object-ids.html#external-id-references"
     * >Referencing objects with external IDs</a> in the <i>IoT SiteWise User Guide</i>.
     * </p>
     * 
     * @return The ID of the asset to update. This can be either the actual ID in UUID format, or else
     *         <code>externalId:</code> followed by the external ID, if it has one. For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/object-ids.html#external-id-references"
     *         >Referencing objects with external IDs</a> in the <i>IoT SiteWise User Guide</i>.
     */
    public final String assetId() {
        return assetId;
    }

    /**
     * <p>
     * An external ID to assign to the asset. The asset must not already have an external ID. The external ID must be
     * unique within your Amazon Web Services account. For more information, see <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/object-ids.html#external-ids">Using external
     * IDs</a> in the <i>IoT SiteWise User Guide</i>.
     * </p>
     * 
     * @return An external ID to assign to the asset. The asset must not already have an external ID. The external ID
     *         must be unique within your Amazon Web Services account. For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/object-ids.html#external-ids">Using
     *         external IDs</a> in the <i>IoT SiteWise User Guide</i>.
     */
    public final String assetExternalId() {
        return assetExternalId;
    }

    /**
     * <p>
     * A friendly name for the asset.
     * </p>
     * 
     * @return A friendly name for the asset.
     */
    public final String assetName() {
        return assetName;
    }

    /**
     * <p>
     * A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don't reuse
     * this client token if a new idempotent request is required.
     * </p>
     * 
     * @return A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don't
     *         reuse this client token if a new idempotent request is required.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * A description for the asset.
     * </p>
     * 
     * @return A description for the asset.
     */
    public final String assetDescription() {
        return assetDescription;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(assetId());
        hashCode = 31 * hashCode + Objects.hashCode(assetExternalId());
        hashCode = 31 * hashCode + Objects.hashCode(assetName());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(assetDescription());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateAssetRequest)) {
            return false;
        }
        UpdateAssetRequest other = (UpdateAssetRequest) obj;
        return Objects.equals(assetId(), other.assetId()) && Objects.equals(assetExternalId(), other.assetExternalId())
                && Objects.equals(assetName(), other.assetName()) && Objects.equals(clientToken(), other.clientToken())
                && Objects.equals(assetDescription(), other.assetDescription());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateAssetRequest").add("AssetId", assetId()).add("AssetExternalId", assetExternalId())
                .add("AssetName", assetName()).add("ClientToken", clientToken()).add("AssetDescription", assetDescription())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "assetId":
            return Optional.ofNullable(clazz.cast(assetId()));
        case "assetExternalId":
            return Optional.ofNullable(clazz.cast(assetExternalId()));
        case "assetName":
            return Optional.ofNullable(clazz.cast(assetName()));
        case "clientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "assetDescription":
            return Optional.ofNullable(clazz.cast(assetDescription()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("assetId", ASSET_ID_FIELD);
        map.put("assetExternalId", ASSET_EXTERNAL_ID_FIELD);
        map.put("assetName", ASSET_NAME_FIELD);
        map.put("clientToken", CLIENT_TOKEN_FIELD);
        map.put("assetDescription", ASSET_DESCRIPTION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateAssetRequest, T> g) {
        return obj -> g.apply((UpdateAssetRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends IoTSiteWiseRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateAssetRequest> {
        /**
         * <p>
         * The ID of the asset to update. This can be either the actual ID in UUID format, or else
         * <code>externalId:</code> followed by the external ID, if it has one. For more information, see <a
         * href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/object-ids.html#external-id-references"
         * >Referencing objects with external IDs</a> in the <i>IoT SiteWise User Guide</i>.
         * </p>
         * 
         * @param assetId
         *        The ID of the asset to update. This can be either the actual ID in UUID format, or else
         *        <code>externalId:</code> followed by the external ID, if it has one. For more information, see <a
         *        href=
         *        "https://docs.aws.amazon.com/iot-sitewise/latest/userguide/object-ids.html#external-id-references"
         *        >Referencing objects with external IDs</a> in the <i>IoT SiteWise User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assetId(String assetId);

        /**
         * <p>
         * An external ID to assign to the asset. The asset must not already have an external ID. The external ID must
         * be unique within your Amazon Web Services account. For more information, see <a
         * href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/object-ids.html#external-ids">Using external
         * IDs</a> in the <i>IoT SiteWise User Guide</i>.
         * </p>
         * 
         * @param assetExternalId
         *        An external ID to assign to the asset. The asset must not already have an external ID. The external ID
         *        must be unique within your Amazon Web Services account. For more information, see <a
         *        href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/object-ids.html#external-ids">Using
         *        external IDs</a> in the <i>IoT SiteWise User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assetExternalId(String assetExternalId);

        /**
         * <p>
         * A friendly name for the asset.
         * </p>
         * 
         * @param assetName
         *        A friendly name for the asset.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assetName(String assetName);

        /**
         * <p>
         * A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don't reuse
         * this client token if a new idempotent request is required.
         * </p>
         * 
         * @param clientToken
         *        A unique case-sensitive identifier that you can provide to ensure the idempotency of the request.
         *        Don't reuse this client token if a new idempotent request is required.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * A description for the asset.
         * </p>
         * 
         * @param assetDescription
         *        A description for the asset.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assetDescription(String assetDescription);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends IoTSiteWiseRequest.BuilderImpl implements Builder {
        private String assetId;

        private String assetExternalId;

        private String assetName;

        private String clientToken;

        private String assetDescription;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateAssetRequest model) {
            super(model);
            assetId(model.assetId);
            assetExternalId(model.assetExternalId);
            assetName(model.assetName);
            clientToken(model.clientToken);
            assetDescription(model.assetDescription);
        }

        public final String getAssetId() {
            return assetId;
        }

        public final void setAssetId(String assetId) {
            this.assetId = assetId;
        }

        @Override
        public final Builder assetId(String assetId) {
            this.assetId = assetId;
            return this;
        }

        public final String getAssetExternalId() {
            return assetExternalId;
        }

        public final void setAssetExternalId(String assetExternalId) {
            this.assetExternalId = assetExternalId;
        }

        @Override
        public final Builder assetExternalId(String assetExternalId) {
            this.assetExternalId = assetExternalId;
            return this;
        }

        public final String getAssetName() {
            return assetName;
        }

        public final void setAssetName(String assetName) {
            this.assetName = assetName;
        }

        @Override
        public final Builder assetName(String assetName) {
            this.assetName = assetName;
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getAssetDescription() {
            return assetDescription;
        }

        public final void setAssetDescription(String assetDescription) {
            this.assetDescription = assetDescription;
        }

        @Override
        public final Builder assetDescription(String assetDescription) {
            this.assetDescription = assetDescription;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateAssetRequest build() {
            return new UpdateAssetRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
