/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotsitewise.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The details of the dataset source associated with the dataset.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SourceDetail implements SdkPojo, Serializable, ToCopyableBuilder<SourceDetail.Builder, SourceDetail> {
    private static final SdkField<KendraSourceDetail> KENDRA_FIELD = SdkField
            .<KendraSourceDetail> builder(MarshallingType.SDK_POJO).memberName("kendra").getter(getter(SourceDetail::kendra))
            .setter(setter(Builder::kendra)).constructor(KendraSourceDetail::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kendra").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KENDRA_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final KendraSourceDetail kendra;

    private SourceDetail(BuilderImpl builder) {
        this.kendra = builder.kendra;
    }

    /**
     * <p>
     * Contains details about the Kendra dataset source.
     * </p>
     * 
     * @return Contains details about the Kendra dataset source.
     */
    public final KendraSourceDetail kendra() {
        return kendra;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(kendra());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SourceDetail)) {
            return false;
        }
        SourceDetail other = (SourceDetail) obj;
        return Objects.equals(kendra(), other.kendra());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SourceDetail").add("Kendra", kendra()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "kendra":
            return Optional.ofNullable(clazz.cast(kendra()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("kendra", KENDRA_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SourceDetail, T> g) {
        return obj -> g.apply((SourceDetail) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SourceDetail> {
        /**
         * <p>
         * Contains details about the Kendra dataset source.
         * </p>
         * 
         * @param kendra
         *        Contains details about the Kendra dataset source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kendra(KendraSourceDetail kendra);

        /**
         * <p>
         * Contains details about the Kendra dataset source.
         * </p>
         * This is a convenience method that creates an instance of the {@link KendraSourceDetail.Builder} avoiding the
         * need to create one manually via {@link KendraSourceDetail#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link KendraSourceDetail.Builder#build()} is called immediately and its
         * result is passed to {@link #kendra(KendraSourceDetail)}.
         * 
         * @param kendra
         *        a consumer that will call methods on {@link KendraSourceDetail.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #kendra(KendraSourceDetail)
         */
        default Builder kendra(Consumer<KendraSourceDetail.Builder> kendra) {
            return kendra(KendraSourceDetail.builder().applyMutation(kendra).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private KendraSourceDetail kendra;

        private BuilderImpl() {
        }

        private BuilderImpl(SourceDetail model) {
            kendra(model.kendra);
        }

        public final KendraSourceDetail.Builder getKendra() {
            return kendra != null ? kendra.toBuilder() : null;
        }

        public final void setKendra(KendraSourceDetail.BuilderImpl kendra) {
            this.kendra = kendra != null ? kendra.build() : null;
        }

        @Override
        public final Builder kendra(KendraSourceDetail kendra) {
            this.kendra = kendra;
            return this;
        }

        @Override
        public SourceDetail build() {
            return new SourceDetail(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
