/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotsitewise.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains a list of value updates for an asset property in the list of asset entries consumed by the <a
 * href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_BatchPutAssetPropertyValue.html"
 * >BatchPutAssetPropertyValue</a> API operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutAssetPropertyValueEntry implements SdkPojo, Serializable,
        ToCopyableBuilder<PutAssetPropertyValueEntry.Builder, PutAssetPropertyValueEntry> {
    private static final SdkField<String> ENTRY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("entryId").getter(getter(PutAssetPropertyValueEntry::entryId)).setter(setter(Builder::entryId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("entryId").build()).build();

    private static final SdkField<String> ASSET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("assetId").getter(getter(PutAssetPropertyValueEntry::assetId)).setter(setter(Builder::assetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assetId").build()).build();

    private static final SdkField<String> PROPERTY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("propertyId").getter(getter(PutAssetPropertyValueEntry::propertyId)).setter(setter(Builder::propertyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("propertyId").build()).build();

    private static final SdkField<String> PROPERTY_ALIAS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("propertyAlias").getter(getter(PutAssetPropertyValueEntry::propertyAlias))
            .setter(setter(Builder::propertyAlias))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("propertyAlias").build()).build();

    private static final SdkField<List<AssetPropertyValue>> PROPERTY_VALUES_FIELD = SdkField
            .<List<AssetPropertyValue>> builder(MarshallingType.LIST)
            .memberName("propertyValues")
            .getter(getter(PutAssetPropertyValueEntry::propertyValues))
            .setter(setter(Builder::propertyValues))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("propertyValues").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AssetPropertyValue> builder(MarshallingType.SDK_POJO)
                                            .constructor(AssetPropertyValue::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENTRY_ID_FIELD,
            ASSET_ID_FIELD, PROPERTY_ID_FIELD, PROPERTY_ALIAS_FIELD, PROPERTY_VALUES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String entryId;

    private final String assetId;

    private final String propertyId;

    private final String propertyAlias;

    private final List<AssetPropertyValue> propertyValues;

    private PutAssetPropertyValueEntry(BuilderImpl builder) {
        this.entryId = builder.entryId;
        this.assetId = builder.assetId;
        this.propertyId = builder.propertyId;
        this.propertyAlias = builder.propertyAlias;
        this.propertyValues = builder.propertyValues;
    }

    /**
     * <p>
     * The user specified ID for the entry. You can use this ID to identify which entries failed.
     * </p>
     * 
     * @return The user specified ID for the entry. You can use this ID to identify which entries failed.
     */
    public final String entryId() {
        return entryId;
    }

    /**
     * <p>
     * The ID of the asset to update.
     * </p>
     * 
     * @return The ID of the asset to update.
     */
    public final String assetId() {
        return assetId;
    }

    /**
     * <p>
     * The ID of the asset property for this entry.
     * </p>
     * 
     * @return The ID of the asset property for this entry.
     */
    public final String propertyId() {
        return propertyId;
    }

    /**
     * <p>
     * The alias that identifies the property, such as an OPC-UA server data stream path (for example,
     * <code>/company/windfarm/3/turbine/7/temperature</code>). For more information, see <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/connect-data-streams.html">Mapping industrial
     * data streams to asset properties</a> in the <i>IoT SiteWise User Guide</i>.
     * </p>
     * 
     * @return The alias that identifies the property, such as an OPC-UA server data stream path (for example,
     *         <code>/company/windfarm/3/turbine/7/temperature</code>). For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/connect-data-streams.html">Mapping
     *         industrial data streams to asset properties</a> in the <i>IoT SiteWise User Guide</i>.
     */
    public final String propertyAlias() {
        return propertyAlias;
    }

    /**
     * For responses, this returns true if the service returned a value for the PropertyValues property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasPropertyValues() {
        return propertyValues != null && !(propertyValues instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of property values to upload. You can specify up to 10 <code>propertyValues</code> array elements.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPropertyValues} method.
     * </p>
     * 
     * @return The list of property values to upload. You can specify up to 10 <code>propertyValues</code> array
     *         elements.
     */
    public final List<AssetPropertyValue> propertyValues() {
        return propertyValues;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(entryId());
        hashCode = 31 * hashCode + Objects.hashCode(assetId());
        hashCode = 31 * hashCode + Objects.hashCode(propertyId());
        hashCode = 31 * hashCode + Objects.hashCode(propertyAlias());
        hashCode = 31 * hashCode + Objects.hashCode(hasPropertyValues() ? propertyValues() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutAssetPropertyValueEntry)) {
            return false;
        }
        PutAssetPropertyValueEntry other = (PutAssetPropertyValueEntry) obj;
        return Objects.equals(entryId(), other.entryId()) && Objects.equals(assetId(), other.assetId())
                && Objects.equals(propertyId(), other.propertyId()) && Objects.equals(propertyAlias(), other.propertyAlias())
                && hasPropertyValues() == other.hasPropertyValues() && Objects.equals(propertyValues(), other.propertyValues());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PutAssetPropertyValueEntry").add("EntryId", entryId()).add("AssetId", assetId())
                .add("PropertyId", propertyId()).add("PropertyAlias", propertyAlias())
                .add("PropertyValues", hasPropertyValues() ? propertyValues() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "entryId":
            return Optional.ofNullable(clazz.cast(entryId()));
        case "assetId":
            return Optional.ofNullable(clazz.cast(assetId()));
        case "propertyId":
            return Optional.ofNullable(clazz.cast(propertyId()));
        case "propertyAlias":
            return Optional.ofNullable(clazz.cast(propertyAlias()));
        case "propertyValues":
            return Optional.ofNullable(clazz.cast(propertyValues()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("entryId", ENTRY_ID_FIELD);
        map.put("assetId", ASSET_ID_FIELD);
        map.put("propertyId", PROPERTY_ID_FIELD);
        map.put("propertyAlias", PROPERTY_ALIAS_FIELD);
        map.put("propertyValues", PROPERTY_VALUES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PutAssetPropertyValueEntry, T> g) {
        return obj -> g.apply((PutAssetPropertyValueEntry) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PutAssetPropertyValueEntry> {
        /**
         * <p>
         * The user specified ID for the entry. You can use this ID to identify which entries failed.
         * </p>
         * 
         * @param entryId
         *        The user specified ID for the entry. You can use this ID to identify which entries failed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder entryId(String entryId);

        /**
         * <p>
         * The ID of the asset to update.
         * </p>
         * 
         * @param assetId
         *        The ID of the asset to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assetId(String assetId);

        /**
         * <p>
         * The ID of the asset property for this entry.
         * </p>
         * 
         * @param propertyId
         *        The ID of the asset property for this entry.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder propertyId(String propertyId);

        /**
         * <p>
         * The alias that identifies the property, such as an OPC-UA server data stream path (for example,
         * <code>/company/windfarm/3/turbine/7/temperature</code>). For more information, see <a
         * href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/connect-data-streams.html">Mapping industrial
         * data streams to asset properties</a> in the <i>IoT SiteWise User Guide</i>.
         * </p>
         * 
         * @param propertyAlias
         *        The alias that identifies the property, such as an OPC-UA server data stream path (for example,
         *        <code>/company/windfarm/3/turbine/7/temperature</code>). For more information, see <a
         *        href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/connect-data-streams.html">Mapping
         *        industrial data streams to asset properties</a> in the <i>IoT SiteWise User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder propertyAlias(String propertyAlias);

        /**
         * <p>
         * The list of property values to upload. You can specify up to 10 <code>propertyValues</code> array elements.
         * </p>
         * 
         * @param propertyValues
         *        The list of property values to upload. You can specify up to 10 <code>propertyValues</code> array
         *        elements.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder propertyValues(Collection<AssetPropertyValue> propertyValues);

        /**
         * <p>
         * The list of property values to upload. You can specify up to 10 <code>propertyValues</code> array elements.
         * </p>
         * 
         * @param propertyValues
         *        The list of property values to upload. You can specify up to 10 <code>propertyValues</code> array
         *        elements.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder propertyValues(AssetPropertyValue... propertyValues);

        /**
         * <p>
         * The list of property values to upload. You can specify up to 10 <code>propertyValues</code> array elements.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.iotsitewise.model.AssetPropertyValue.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.iotsitewise.model.AssetPropertyValue#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.iotsitewise.model.AssetPropertyValue.Builder#build()} is called
         * immediately and its result is passed to {@link #propertyValues(List<AssetPropertyValue>)}.
         * 
         * @param propertyValues
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.iotsitewise.model.AssetPropertyValue.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #propertyValues(java.util.Collection<AssetPropertyValue>)
         */
        Builder propertyValues(Consumer<AssetPropertyValue.Builder>... propertyValues);
    }

    static final class BuilderImpl implements Builder {
        private String entryId;

        private String assetId;

        private String propertyId;

        private String propertyAlias;

        private List<AssetPropertyValue> propertyValues = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PutAssetPropertyValueEntry model) {
            entryId(model.entryId);
            assetId(model.assetId);
            propertyId(model.propertyId);
            propertyAlias(model.propertyAlias);
            propertyValues(model.propertyValues);
        }

        public final String getEntryId() {
            return entryId;
        }

        public final void setEntryId(String entryId) {
            this.entryId = entryId;
        }

        @Override
        public final Builder entryId(String entryId) {
            this.entryId = entryId;
            return this;
        }

        public final String getAssetId() {
            return assetId;
        }

        public final void setAssetId(String assetId) {
            this.assetId = assetId;
        }

        @Override
        public final Builder assetId(String assetId) {
            this.assetId = assetId;
            return this;
        }

        public final String getPropertyId() {
            return propertyId;
        }

        public final void setPropertyId(String propertyId) {
            this.propertyId = propertyId;
        }

        @Override
        public final Builder propertyId(String propertyId) {
            this.propertyId = propertyId;
            return this;
        }

        public final String getPropertyAlias() {
            return propertyAlias;
        }

        public final void setPropertyAlias(String propertyAlias) {
            this.propertyAlias = propertyAlias;
        }

        @Override
        public final Builder propertyAlias(String propertyAlias) {
            this.propertyAlias = propertyAlias;
            return this;
        }

        public final List<AssetPropertyValue.Builder> getPropertyValues() {
            List<AssetPropertyValue.Builder> result = AssetPropertyValuesCopier.copyToBuilder(this.propertyValues);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPropertyValues(Collection<AssetPropertyValue.BuilderImpl> propertyValues) {
            this.propertyValues = AssetPropertyValuesCopier.copyFromBuilder(propertyValues);
        }

        @Override
        public final Builder propertyValues(Collection<AssetPropertyValue> propertyValues) {
            this.propertyValues = AssetPropertyValuesCopier.copy(propertyValues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder propertyValues(AssetPropertyValue... propertyValues) {
            propertyValues(Arrays.asList(propertyValues));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder propertyValues(Consumer<AssetPropertyValue.Builder>... propertyValues) {
            propertyValues(Stream.of(propertyValues).map(c -> AssetPropertyValue.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public PutAssetPropertyValueEntry build() {
            return new PutAssetPropertyValueEntry(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
