/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotsitewise.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Maps a property from an interface asset model to a property in the asset model where the interface is applied.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PropertyMapping implements SdkPojo, Serializable, ToCopyableBuilder<PropertyMapping.Builder, PropertyMapping> {
    private static final SdkField<String> ASSET_MODEL_PROPERTY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("assetModelPropertyId").getter(getter(PropertyMapping::assetModelPropertyId))
            .setter(setter(Builder::assetModelPropertyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assetModelPropertyId").build())
            .build();

    private static final SdkField<String> INTERFACE_ASSET_MODEL_PROPERTY_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("interfaceAssetModelPropertyId")
            .getter(getter(PropertyMapping::interfaceAssetModelPropertyId))
            .setter(setter(Builder::interfaceAssetModelPropertyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("interfaceAssetModelPropertyId")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSET_MODEL_PROPERTY_ID_FIELD,
            INTERFACE_ASSET_MODEL_PROPERTY_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String assetModelPropertyId;

    private final String interfaceAssetModelPropertyId;

    private PropertyMapping(BuilderImpl builder) {
        this.assetModelPropertyId = builder.assetModelPropertyId;
        this.interfaceAssetModelPropertyId = builder.interfaceAssetModelPropertyId;
    }

    /**
     * <p>
     * The ID of the property in the asset model where the interface is applied.
     * </p>
     * 
     * @return The ID of the property in the asset model where the interface is applied.
     */
    public final String assetModelPropertyId() {
        return assetModelPropertyId;
    }

    /**
     * <p>
     * The ID of the property in the interface asset model.
     * </p>
     * 
     * @return The ID of the property in the interface asset model.
     */
    public final String interfaceAssetModelPropertyId() {
        return interfaceAssetModelPropertyId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(assetModelPropertyId());
        hashCode = 31 * hashCode + Objects.hashCode(interfaceAssetModelPropertyId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PropertyMapping)) {
            return false;
        }
        PropertyMapping other = (PropertyMapping) obj;
        return Objects.equals(assetModelPropertyId(), other.assetModelPropertyId())
                && Objects.equals(interfaceAssetModelPropertyId(), other.interfaceAssetModelPropertyId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PropertyMapping").add("AssetModelPropertyId", assetModelPropertyId())
                .add("InterfaceAssetModelPropertyId", interfaceAssetModelPropertyId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "assetModelPropertyId":
            return Optional.ofNullable(clazz.cast(assetModelPropertyId()));
        case "interfaceAssetModelPropertyId":
            return Optional.ofNullable(clazz.cast(interfaceAssetModelPropertyId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("assetModelPropertyId", ASSET_MODEL_PROPERTY_ID_FIELD);
        map.put("interfaceAssetModelPropertyId", INTERFACE_ASSET_MODEL_PROPERTY_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PropertyMapping, T> g) {
        return obj -> g.apply((PropertyMapping) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PropertyMapping> {
        /**
         * <p>
         * The ID of the property in the asset model where the interface is applied.
         * </p>
         * 
         * @param assetModelPropertyId
         *        The ID of the property in the asset model where the interface is applied.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assetModelPropertyId(String assetModelPropertyId);

        /**
         * <p>
         * The ID of the property in the interface asset model.
         * </p>
         * 
         * @param interfaceAssetModelPropertyId
         *        The ID of the property in the interface asset model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder interfaceAssetModelPropertyId(String interfaceAssetModelPropertyId);
    }

    static final class BuilderImpl implements Builder {
        private String assetModelPropertyId;

        private String interfaceAssetModelPropertyId;

        private BuilderImpl() {
        }

        private BuilderImpl(PropertyMapping model) {
            assetModelPropertyId(model.assetModelPropertyId);
            interfaceAssetModelPropertyId(model.interfaceAssetModelPropertyId);
        }

        public final String getAssetModelPropertyId() {
            return assetModelPropertyId;
        }

        public final void setAssetModelPropertyId(String assetModelPropertyId) {
            this.assetModelPropertyId = assetModelPropertyId;
        }

        @Override
        public final Builder assetModelPropertyId(String assetModelPropertyId) {
            this.assetModelPropertyId = assetModelPropertyId;
            return this;
        }

        public final String getInterfaceAssetModelPropertyId() {
            return interfaceAssetModelPropertyId;
        }

        public final void setInterfaceAssetModelPropertyId(String interfaceAssetModelPropertyId) {
            this.interfaceAssetModelPropertyId = interfaceAssetModelPropertyId;
        }

        @Override
        public final Builder interfaceAssetModelPropertyId(String interfaceAssetModelPropertyId) {
            this.interfaceAssetModelPropertyId = interfaceAssetModelPropertyId;
            return this;
        }

        @Override
        public PropertyMapping build() {
            return new PropertyMapping(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
