/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotsitewise.model;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;

@Generated("software.amazon.awssdk:codegen")
final class PortalTypeConfigurationCopier {
    static Map<String, PortalTypeEntry> copy(Map<String, ? extends PortalTypeEntry> portalTypeConfigurationParam) {
        Map<String, PortalTypeEntry> map;
        if (portalTypeConfigurationParam == null || portalTypeConfigurationParam instanceof SdkAutoConstructMap) {
            map = DefaultSdkAutoConstructMap.getInstance();
        } else {
            Map<String, PortalTypeEntry> modifiableMap = new LinkedHashMap<>(portalTypeConfigurationParam.size());
            portalTypeConfigurationParam.forEach((key, value) -> {
                modifiableMap.put(key, value);
            });
            map = Collections.unmodifiableMap(modifiableMap);
        }
        return map;
    }

    static Map<String, PortalTypeEntry> copyFromBuilder(
            Map<String, ? extends PortalTypeEntry.Builder> portalTypeConfigurationParam) {
        Map<String, PortalTypeEntry> map;
        if (portalTypeConfigurationParam == null || portalTypeConfigurationParam instanceof SdkAutoConstructMap) {
            map = DefaultSdkAutoConstructMap.getInstance();
        } else {
            Map<String, PortalTypeEntry> modifiableMap = new LinkedHashMap<>(portalTypeConfigurationParam.size());
            portalTypeConfigurationParam.forEach((key, value) -> {
                PortalTypeEntry member = value == null ? null : value.build();
                modifiableMap.put(key, member);
            });
            map = Collections.unmodifiableMap(modifiableMap);
        }
        return map;
    }

    static Map<String, PortalTypeEntry.Builder> copyToBuilder(Map<String, ? extends PortalTypeEntry> portalTypeConfigurationParam) {
        Map<String, PortalTypeEntry.Builder> map;
        if (portalTypeConfigurationParam == null || portalTypeConfigurationParam instanceof SdkAutoConstructMap) {
            map = DefaultSdkAutoConstructMap.getInstance();
        } else {
            Map<String, PortalTypeEntry.Builder> modifiableMap = new LinkedHashMap<>(portalTypeConfigurationParam.size());
            portalTypeConfigurationParam.forEach((key, value) -> {
                PortalTypeEntry.Builder member = value == null ? null : value.toBuilder();
                modifiableMap.put(key, member);
            });
            map = Collections.unmodifiableMap(modifiableMap);
        }
        return map;
    }
}
