/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotsitewise.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListComputationModelDataBindingUsagesRequest extends IoTSiteWiseRequest implements
        ToCopyableBuilder<ListComputationModelDataBindingUsagesRequest.Builder, ListComputationModelDataBindingUsagesRequest> {
    private static final SdkField<DataBindingValueFilter> DATA_BINDING_VALUE_FILTER_FIELD = SdkField
            .<DataBindingValueFilter> builder(MarshallingType.SDK_POJO).memberName("dataBindingValueFilter")
            .getter(getter(ListComputationModelDataBindingUsagesRequest::dataBindingValueFilter))
            .setter(setter(Builder::dataBindingValueFilter)).constructor(DataBindingValueFilter::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataBindingValueFilter").build())
            .build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListComputationModelDataBindingUsagesRequest::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxResults").getter(getter(ListComputationModelDataBindingUsagesRequest::maxResults))
            .setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxResults").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            DATA_BINDING_VALUE_FILTER_FIELD, NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final DataBindingValueFilter dataBindingValueFilter;

    private final String nextToken;

    private final Integer maxResults;

    private ListComputationModelDataBindingUsagesRequest(BuilderImpl builder) {
        super(builder);
        this.dataBindingValueFilter = builder.dataBindingValueFilter;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
    }

    /**
     * <p>
     * A filter used to limit the returned data binding usages based on specific data binding values. You can filter by
     * asset, asset model, asset property, or asset model property to find all computation models using these specific
     * data sources.
     * </p>
     * 
     * @return A filter used to limit the returned data binding usages based on specific data binding values. You can
     *         filter by asset, asset model, asset property, or asset model property to find all computation models
     *         using these specific data sources.
     */
    public final DataBindingValueFilter dataBindingValueFilter() {
        return dataBindingValueFilter;
    }

    /**
     * <p>
     * The token used for the next set of paginated results.
     * </p>
     * 
     * @return The token used for the next set of paginated results.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The maximum number of results returned for each paginated request.
     * </p>
     * 
     * @return The maximum number of results returned for each paginated request.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(dataBindingValueFilter());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListComputationModelDataBindingUsagesRequest)) {
            return false;
        }
        ListComputationModelDataBindingUsagesRequest other = (ListComputationModelDataBindingUsagesRequest) obj;
        return Objects.equals(dataBindingValueFilter(), other.dataBindingValueFilter())
                && Objects.equals(nextToken(), other.nextToken()) && Objects.equals(maxResults(), other.maxResults());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListComputationModelDataBindingUsagesRequest")
                .add("DataBindingValueFilter", dataBindingValueFilter()).add("NextToken", nextToken())
                .add("MaxResults", maxResults()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "dataBindingValueFilter":
            return Optional.ofNullable(clazz.cast(dataBindingValueFilter()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "maxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("dataBindingValueFilter", DATA_BINDING_VALUE_FILTER_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("maxResults", MAX_RESULTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListComputationModelDataBindingUsagesRequest, T> g) {
        return obj -> g.apply((ListComputationModelDataBindingUsagesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends IoTSiteWiseRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, ListComputationModelDataBindingUsagesRequest> {
        /**
         * <p>
         * A filter used to limit the returned data binding usages based on specific data binding values. You can filter
         * by asset, asset model, asset property, or asset model property to find all computation models using these
         * specific data sources.
         * </p>
         * 
         * @param dataBindingValueFilter
         *        A filter used to limit the returned data binding usages based on specific data binding values. You can
         *        filter by asset, asset model, asset property, or asset model property to find all computation models
         *        using these specific data sources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataBindingValueFilter(DataBindingValueFilter dataBindingValueFilter);

        /**
         * <p>
         * A filter used to limit the returned data binding usages based on specific data binding values. You can filter
         * by asset, asset model, asset property, or asset model property to find all computation models using these
         * specific data sources.
         * </p>
         * This is a convenience method that creates an instance of the {@link DataBindingValueFilter.Builder} avoiding
         * the need to create one manually via {@link DataBindingValueFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DataBindingValueFilter.Builder#build()} is called immediately and
         * its result is passed to {@link #dataBindingValueFilter(DataBindingValueFilter)}.
         * 
         * @param dataBindingValueFilter
         *        a consumer that will call methods on {@link DataBindingValueFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dataBindingValueFilter(DataBindingValueFilter)
         */
        default Builder dataBindingValueFilter(Consumer<DataBindingValueFilter.Builder> dataBindingValueFilter) {
            return dataBindingValueFilter(DataBindingValueFilter.builder().applyMutation(dataBindingValueFilter).build());
        }

        /**
         * <p>
         * The token used for the next set of paginated results.
         * </p>
         * 
         * @param nextToken
         *        The token used for the next set of paginated results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The maximum number of results returned for each paginated request.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of results returned for each paginated request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends IoTSiteWiseRequest.BuilderImpl implements Builder {
        private DataBindingValueFilter dataBindingValueFilter;

        private String nextToken;

        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(ListComputationModelDataBindingUsagesRequest model) {
            super(model);
            dataBindingValueFilter(model.dataBindingValueFilter);
            nextToken(model.nextToken);
            maxResults(model.maxResults);
        }

        public final DataBindingValueFilter.Builder getDataBindingValueFilter() {
            return dataBindingValueFilter != null ? dataBindingValueFilter.toBuilder() : null;
        }

        public final void setDataBindingValueFilter(DataBindingValueFilter.BuilderImpl dataBindingValueFilter) {
            this.dataBindingValueFilter = dataBindingValueFilter != null ? dataBindingValueFilter.build() : null;
        }

        @Override
        public final Builder dataBindingValueFilter(DataBindingValueFilter dataBindingValueFilter) {
            this.dataBindingValueFilter = dataBindingValueFilter;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListComputationModelDataBindingUsagesRequest build() {
            return new ListComputationModelDataBindingUsagesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
