/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotsitewise.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListActionsRequest extends IoTSiteWiseRequest implements
        ToCopyableBuilder<ListActionsRequest.Builder, ListActionsRequest> {
    private static final SdkField<String> TARGET_RESOURCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("targetResourceType").getter(getter(ListActionsRequest::targetResourceTypeAsString))
            .setter(setter(Builder::targetResourceType))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("targetResourceType").build())
            .build();

    private static final SdkField<String> TARGET_RESOURCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("targetResourceId").getter(getter(ListActionsRequest::targetResourceId))
            .setter(setter(Builder::targetResourceId))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("targetResourceId").build())
            .build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListActionsRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("nextToken").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxResults").getter(getter(ListActionsRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("maxResults").build()).build();

    private static final SdkField<String> RESOLVE_TO_RESOURCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("resolveToResourceType").getter(getter(ListActionsRequest::resolveToResourceTypeAsString))
            .setter(setter(Builder::resolveToResourceType))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("resolveToResourceType").build())
            .build();

    private static final SdkField<String> RESOLVE_TO_RESOURCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("resolveToResourceId").getter(getter(ListActionsRequest::resolveToResourceId))
            .setter(setter(Builder::resolveToResourceId))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("resolveToResourceId").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TARGET_RESOURCE_TYPE_FIELD,
            TARGET_RESOURCE_ID_FIELD, NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD, RESOLVE_TO_RESOURCE_TYPE_FIELD,
            RESOLVE_TO_RESOURCE_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String targetResourceType;

    private final String targetResourceId;

    private final String nextToken;

    private final Integer maxResults;

    private final String resolveToResourceType;

    private final String resolveToResourceId;

    private ListActionsRequest(BuilderImpl builder) {
        super(builder);
        this.targetResourceType = builder.targetResourceType;
        this.targetResourceId = builder.targetResourceId;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
        this.resolveToResourceType = builder.resolveToResourceType;
        this.resolveToResourceId = builder.resolveToResourceId;
    }

    /**
     * <p>
     * The type of resource.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #targetResourceType} will return {@link TargetResourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #targetResourceTypeAsString}.
     * </p>
     * 
     * @return The type of resource.
     * @see TargetResourceType
     */
    public final TargetResourceType targetResourceType() {
        return TargetResourceType.fromValue(targetResourceType);
    }

    /**
     * <p>
     * The type of resource.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #targetResourceType} will return {@link TargetResourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #targetResourceTypeAsString}.
     * </p>
     * 
     * @return The type of resource.
     * @see TargetResourceType
     */
    public final String targetResourceTypeAsString() {
        return targetResourceType;
    }

    /**
     * <p>
     * The ID of the target resource.
     * </p>
     * 
     * @return The ID of the target resource.
     */
    public final String targetResourceId() {
        return targetResourceId;
    }

    /**
     * <p>
     * The token to be used for the next set of paginated results.
     * </p>
     * 
     * @return The token to be used for the next set of paginated results.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The maximum number of results to return for each paginated request.
     * </p>
     * 
     * @return The maximum number of results to return for each paginated request.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * The type of the resolved resource.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #resolveToResourceType} will return {@link ResolveToResourceType#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #resolveToResourceTypeAsString}.
     * </p>
     * 
     * @return The type of the resolved resource.
     * @see ResolveToResourceType
     */
    public final ResolveToResourceType resolveToResourceType() {
        return ResolveToResourceType.fromValue(resolveToResourceType);
    }

    /**
     * <p>
     * The type of the resolved resource.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #resolveToResourceType} will return {@link ResolveToResourceType#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #resolveToResourceTypeAsString}.
     * </p>
     * 
     * @return The type of the resolved resource.
     * @see ResolveToResourceType
     */
    public final String resolveToResourceTypeAsString() {
        return resolveToResourceType;
    }

    /**
     * <p>
     * The ID of the resolved resource.
     * </p>
     * 
     * @return The ID of the resolved resource.
     */
    public final String resolveToResourceId() {
        return resolveToResourceId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(targetResourceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(targetResourceId());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(resolveToResourceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(resolveToResourceId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListActionsRequest)) {
            return false;
        }
        ListActionsRequest other = (ListActionsRequest) obj;
        return Objects.equals(targetResourceTypeAsString(), other.targetResourceTypeAsString())
                && Objects.equals(targetResourceId(), other.targetResourceId()) && Objects.equals(nextToken(), other.nextToken())
                && Objects.equals(maxResults(), other.maxResults())
                && Objects.equals(resolveToResourceTypeAsString(), other.resolveToResourceTypeAsString())
                && Objects.equals(resolveToResourceId(), other.resolveToResourceId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListActionsRequest").add("TargetResourceType", targetResourceTypeAsString())
                .add("TargetResourceId", targetResourceId()).add("NextToken", nextToken()).add("MaxResults", maxResults())
                .add("ResolveToResourceType", resolveToResourceTypeAsString()).add("ResolveToResourceId", resolveToResourceId())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "targetResourceType":
            return Optional.ofNullable(clazz.cast(targetResourceTypeAsString()));
        case "targetResourceId":
            return Optional.ofNullable(clazz.cast(targetResourceId()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "maxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "resolveToResourceType":
            return Optional.ofNullable(clazz.cast(resolveToResourceTypeAsString()));
        case "resolveToResourceId":
            return Optional.ofNullable(clazz.cast(resolveToResourceId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("targetResourceType", TARGET_RESOURCE_TYPE_FIELD);
        map.put("targetResourceId", TARGET_RESOURCE_ID_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("maxResults", MAX_RESULTS_FIELD);
        map.put("resolveToResourceType", RESOLVE_TO_RESOURCE_TYPE_FIELD);
        map.put("resolveToResourceId", RESOLVE_TO_RESOURCE_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListActionsRequest, T> g) {
        return obj -> g.apply((ListActionsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends IoTSiteWiseRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListActionsRequest> {
        /**
         * <p>
         * The type of resource.
         * </p>
         * 
         * @param targetResourceType
         *        The type of resource.
         * @see TargetResourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TargetResourceType
         */
        Builder targetResourceType(String targetResourceType);

        /**
         * <p>
         * The type of resource.
         * </p>
         * 
         * @param targetResourceType
         *        The type of resource.
         * @see TargetResourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TargetResourceType
         */
        Builder targetResourceType(TargetResourceType targetResourceType);

        /**
         * <p>
         * The ID of the target resource.
         * </p>
         * 
         * @param targetResourceId
         *        The ID of the target resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetResourceId(String targetResourceId);

        /**
         * <p>
         * The token to be used for the next set of paginated results.
         * </p>
         * 
         * @param nextToken
         *        The token to be used for the next set of paginated results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The maximum number of results to return for each paginated request.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of results to return for each paginated request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * The type of the resolved resource.
         * </p>
         * 
         * @param resolveToResourceType
         *        The type of the resolved resource.
         * @see ResolveToResourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResolveToResourceType
         */
        Builder resolveToResourceType(String resolveToResourceType);

        /**
         * <p>
         * The type of the resolved resource.
         * </p>
         * 
         * @param resolveToResourceType
         *        The type of the resolved resource.
         * @see ResolveToResourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResolveToResourceType
         */
        Builder resolveToResourceType(ResolveToResourceType resolveToResourceType);

        /**
         * <p>
         * The ID of the resolved resource.
         * </p>
         * 
         * @param resolveToResourceId
         *        The ID of the resolved resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resolveToResourceId(String resolveToResourceId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends IoTSiteWiseRequest.BuilderImpl implements Builder {
        private String targetResourceType;

        private String targetResourceId;

        private String nextToken;

        private Integer maxResults;

        private String resolveToResourceType;

        private String resolveToResourceId;

        private BuilderImpl() {
        }

        private BuilderImpl(ListActionsRequest model) {
            super(model);
            targetResourceType(model.targetResourceType);
            targetResourceId(model.targetResourceId);
            nextToken(model.nextToken);
            maxResults(model.maxResults);
            resolveToResourceType(model.resolveToResourceType);
            resolveToResourceId(model.resolveToResourceId);
        }

        public final String getTargetResourceType() {
            return targetResourceType;
        }

        public final void setTargetResourceType(String targetResourceType) {
            this.targetResourceType = targetResourceType;
        }

        @Override
        public final Builder targetResourceType(String targetResourceType) {
            this.targetResourceType = targetResourceType;
            return this;
        }

        @Override
        public final Builder targetResourceType(TargetResourceType targetResourceType) {
            this.targetResourceType(targetResourceType == null ? null : targetResourceType.toString());
            return this;
        }

        public final String getTargetResourceId() {
            return targetResourceId;
        }

        public final void setTargetResourceId(String targetResourceId) {
            this.targetResourceId = targetResourceId;
        }

        @Override
        public final Builder targetResourceId(String targetResourceId) {
            this.targetResourceId = targetResourceId;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getResolveToResourceType() {
            return resolveToResourceType;
        }

        public final void setResolveToResourceType(String resolveToResourceType) {
            this.resolveToResourceType = resolveToResourceType;
        }

        @Override
        public final Builder resolveToResourceType(String resolveToResourceType) {
            this.resolveToResourceType = resolveToResourceType;
            return this;
        }

        @Override
        public final Builder resolveToResourceType(ResolveToResourceType resolveToResourceType) {
            this.resolveToResourceType(resolveToResourceType == null ? null : resolveToResourceType.toString());
            return this;
        }

        public final String getResolveToResourceId() {
            return resolveToResourceId;
        }

        public final void setResolveToResourceId(String resolveToResourceId) {
            this.resolveToResourceId = resolveToResourceId;
        }

        @Override
        public final Builder resolveToResourceId(String resolveToResourceId) {
            this.resolveToResourceId = resolveToResourceId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListActionsRequest build() {
            return new ListActionsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
