/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotsitewise.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains summary information about an interface that a property belongs to.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class InterfaceSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<InterfaceSummary.Builder, InterfaceSummary> {
    private static final SdkField<String> INTERFACE_ASSET_MODEL_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("interfaceAssetModelId").getter(getter(InterfaceSummary::interfaceAssetModelId))
            .setter(setter(Builder::interfaceAssetModelId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("interfaceAssetModelId").build())
            .build();

    private static final SdkField<String> INTERFACE_ASSET_MODEL_PROPERTY_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("interfaceAssetModelPropertyId")
            .getter(getter(InterfaceSummary::interfaceAssetModelPropertyId))
            .setter(setter(Builder::interfaceAssetModelPropertyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("interfaceAssetModelPropertyId")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            INTERFACE_ASSET_MODEL_ID_FIELD, INTERFACE_ASSET_MODEL_PROPERTY_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String interfaceAssetModelId;

    private final String interfaceAssetModelPropertyId;

    private InterfaceSummary(BuilderImpl builder) {
        this.interfaceAssetModelId = builder.interfaceAssetModelId;
        this.interfaceAssetModelPropertyId = builder.interfaceAssetModelPropertyId;
    }

    /**
     * <p>
     * The ID of the interface asset model that contains this property.
     * </p>
     * 
     * @return The ID of the interface asset model that contains this property.
     */
    public final String interfaceAssetModelId() {
        return interfaceAssetModelId;
    }

    /**
     * <p>
     * The ID of the property in the interface asset model that corresponds to this property.
     * </p>
     * 
     * @return The ID of the property in the interface asset model that corresponds to this property.
     */
    public final String interfaceAssetModelPropertyId() {
        return interfaceAssetModelPropertyId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(interfaceAssetModelId());
        hashCode = 31 * hashCode + Objects.hashCode(interfaceAssetModelPropertyId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InterfaceSummary)) {
            return false;
        }
        InterfaceSummary other = (InterfaceSummary) obj;
        return Objects.equals(interfaceAssetModelId(), other.interfaceAssetModelId())
                && Objects.equals(interfaceAssetModelPropertyId(), other.interfaceAssetModelPropertyId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("InterfaceSummary").add("InterfaceAssetModelId", interfaceAssetModelId())
                .add("InterfaceAssetModelPropertyId", interfaceAssetModelPropertyId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "interfaceAssetModelId":
            return Optional.ofNullable(clazz.cast(interfaceAssetModelId()));
        case "interfaceAssetModelPropertyId":
            return Optional.ofNullable(clazz.cast(interfaceAssetModelPropertyId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("interfaceAssetModelId", INTERFACE_ASSET_MODEL_ID_FIELD);
        map.put("interfaceAssetModelPropertyId", INTERFACE_ASSET_MODEL_PROPERTY_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<InterfaceSummary, T> g) {
        return obj -> g.apply((InterfaceSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, InterfaceSummary> {
        /**
         * <p>
         * The ID of the interface asset model that contains this property.
         * </p>
         * 
         * @param interfaceAssetModelId
         *        The ID of the interface asset model that contains this property.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder interfaceAssetModelId(String interfaceAssetModelId);

        /**
         * <p>
         * The ID of the property in the interface asset model that corresponds to this property.
         * </p>
         * 
         * @param interfaceAssetModelPropertyId
         *        The ID of the property in the interface asset model that corresponds to this property.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder interfaceAssetModelPropertyId(String interfaceAssetModelPropertyId);
    }

    static final class BuilderImpl implements Builder {
        private String interfaceAssetModelId;

        private String interfaceAssetModelPropertyId;

        private BuilderImpl() {
        }

        private BuilderImpl(InterfaceSummary model) {
            interfaceAssetModelId(model.interfaceAssetModelId);
            interfaceAssetModelPropertyId(model.interfaceAssetModelPropertyId);
        }

        public final String getInterfaceAssetModelId() {
            return interfaceAssetModelId;
        }

        public final void setInterfaceAssetModelId(String interfaceAssetModelId) {
            this.interfaceAssetModelId = interfaceAssetModelId;
        }

        @Override
        public final Builder interfaceAssetModelId(String interfaceAssetModelId) {
            this.interfaceAssetModelId = interfaceAssetModelId;
            return this;
        }

        public final String getInterfaceAssetModelPropertyId() {
            return interfaceAssetModelPropertyId;
        }

        public final void setInterfaceAssetModelPropertyId(String interfaceAssetModelPropertyId) {
            this.interfaceAssetModelPropertyId = interfaceAssetModelPropertyId;
        }

        @Override
        public final Builder interfaceAssetModelPropertyId(String interfaceAssetModelPropertyId) {
            this.interfaceAssetModelPropertyId = interfaceAssetModelPropertyId;
            return this;
        }

        @Override
        public InterfaceSummary build() {
            return new InterfaceSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
