/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotsitewise.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeDatasetResponse extends IoTSiteWiseResponse implements
        ToCopyableBuilder<DescribeDatasetResponse.Builder, DescribeDatasetResponse> {
    private static final SdkField<String> DATASET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("datasetId").getter(getter(DescribeDatasetResponse::datasetId)).setter(setter(Builder::datasetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("datasetId").build()).build();

    private static final SdkField<String> DATASET_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("datasetArn").getter(getter(DescribeDatasetResponse::datasetArn)).setter(setter(Builder::datasetArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("datasetArn").build()).build();

    private static final SdkField<String> DATASET_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("datasetName").getter(getter(DescribeDatasetResponse::datasetName)).setter(setter(Builder::datasetName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("datasetName").build()).build();

    private static final SdkField<String> DATASET_DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("datasetDescription").getter(getter(DescribeDatasetResponse::datasetDescription))
            .setter(setter(Builder::datasetDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("datasetDescription").build())
            .build();

    private static final SdkField<DatasetSource> DATASET_SOURCE_FIELD = SdkField
            .<DatasetSource> builder(MarshallingType.SDK_POJO).memberName("datasetSource")
            .getter(getter(DescribeDatasetResponse::datasetSource)).setter(setter(Builder::datasetSource))
            .constructor(DatasetSource::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("datasetSource").build()).build();

    private static final SdkField<DatasetStatus> DATASET_STATUS_FIELD = SdkField
            .<DatasetStatus> builder(MarshallingType.SDK_POJO).memberName("datasetStatus")
            .getter(getter(DescribeDatasetResponse::datasetStatus)).setter(setter(Builder::datasetStatus))
            .constructor(DatasetStatus::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("datasetStatus").build()).build();

    private static final SdkField<Instant> DATASET_CREATION_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("datasetCreationDate").getter(getter(DescribeDatasetResponse::datasetCreationDate))
            .setter(setter(Builder::datasetCreationDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("datasetCreationDate").build())
            .build();

    private static final SdkField<Instant> DATASET_LAST_UPDATE_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("datasetLastUpdateDate").getter(getter(DescribeDatasetResponse::datasetLastUpdateDate))
            .setter(setter(Builder::datasetLastUpdateDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("datasetLastUpdateDate").build())
            .build();

    private static final SdkField<String> DATASET_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("datasetVersion").getter(getter(DescribeDatasetResponse::datasetVersion))
            .setter(setter(Builder::datasetVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("datasetVersion").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATASET_ID_FIELD,
            DATASET_ARN_FIELD, DATASET_NAME_FIELD, DATASET_DESCRIPTION_FIELD, DATASET_SOURCE_FIELD, DATASET_STATUS_FIELD,
            DATASET_CREATION_DATE_FIELD, DATASET_LAST_UPDATE_DATE_FIELD, DATASET_VERSION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String datasetId;

    private final String datasetArn;

    private final String datasetName;

    private final String datasetDescription;

    private final DatasetSource datasetSource;

    private final DatasetStatus datasetStatus;

    private final Instant datasetCreationDate;

    private final Instant datasetLastUpdateDate;

    private final String datasetVersion;

    private DescribeDatasetResponse(BuilderImpl builder) {
        super(builder);
        this.datasetId = builder.datasetId;
        this.datasetArn = builder.datasetArn;
        this.datasetName = builder.datasetName;
        this.datasetDescription = builder.datasetDescription;
        this.datasetSource = builder.datasetSource;
        this.datasetStatus = builder.datasetStatus;
        this.datasetCreationDate = builder.datasetCreationDate;
        this.datasetLastUpdateDate = builder.datasetLastUpdateDate;
        this.datasetVersion = builder.datasetVersion;
    }

    /**
     * <p>
     * The ID of the dataset.
     * </p>
     * 
     * @return The ID of the dataset.
     */
    public final String datasetId() {
        return datasetId;
    }

    /**
     * <p>
     * The <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference-arns.html">ARN</a> of the dataset. The
     * format is <code>arn:${Partition}:iotsitewise:${Region}:${Account}:dataset/${DatasetId}</code>.
     * </p>
     * 
     * @return The <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference-arns.html">ARN</a> of the
     *         dataset. The format is
     *         <code>arn:${Partition}:iotsitewise:${Region}:${Account}:dataset/${DatasetId}</code>.
     */
    public final String datasetArn() {
        return datasetArn;
    }

    /**
     * <p>
     * The name of the dataset.
     * </p>
     * 
     * @return The name of the dataset.
     */
    public final String datasetName() {
        return datasetName;
    }

    /**
     * <p>
     * A description about the dataset, and its functionality.
     * </p>
     * 
     * @return A description about the dataset, and its functionality.
     */
    public final String datasetDescription() {
        return datasetDescription;
    }

    /**
     * <p>
     * The data source for the dataset.
     * </p>
     * 
     * @return The data source for the dataset.
     */
    public final DatasetSource datasetSource() {
        return datasetSource;
    }

    /**
     * <p>
     * The status of the dataset. This contains the state and any error messages. State is <code>CREATING</code> after a
     * successfull call to this API, and any associated error message. The state is <code>ACTIVE</code> when ready to
     * use.
     * </p>
     * 
     * @return The status of the dataset. This contains the state and any error messages. State is <code>CREATING</code>
     *         after a successfull call to this API, and any associated error message. The state is <code>ACTIVE</code>
     *         when ready to use.
     */
    public final DatasetStatus datasetStatus() {
        return datasetStatus;
    }

    /**
     * <p>
     * The dataset creation date, in Unix epoch time.
     * </p>
     * 
     * @return The dataset creation date, in Unix epoch time.
     */
    public final Instant datasetCreationDate() {
        return datasetCreationDate;
    }

    /**
     * <p>
     * The date the dataset was last updated, in Unix epoch time.
     * </p>
     * 
     * @return The date the dataset was last updated, in Unix epoch time.
     */
    public final Instant datasetLastUpdateDate() {
        return datasetLastUpdateDate;
    }

    /**
     * <p>
     * The version of the dataset.
     * </p>
     * 
     * @return The version of the dataset.
     */
    public final String datasetVersion() {
        return datasetVersion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(datasetId());
        hashCode = 31 * hashCode + Objects.hashCode(datasetArn());
        hashCode = 31 * hashCode + Objects.hashCode(datasetName());
        hashCode = 31 * hashCode + Objects.hashCode(datasetDescription());
        hashCode = 31 * hashCode + Objects.hashCode(datasetSource());
        hashCode = 31 * hashCode + Objects.hashCode(datasetStatus());
        hashCode = 31 * hashCode + Objects.hashCode(datasetCreationDate());
        hashCode = 31 * hashCode + Objects.hashCode(datasetLastUpdateDate());
        hashCode = 31 * hashCode + Objects.hashCode(datasetVersion());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeDatasetResponse)) {
            return false;
        }
        DescribeDatasetResponse other = (DescribeDatasetResponse) obj;
        return Objects.equals(datasetId(), other.datasetId()) && Objects.equals(datasetArn(), other.datasetArn())
                && Objects.equals(datasetName(), other.datasetName())
                && Objects.equals(datasetDescription(), other.datasetDescription())
                && Objects.equals(datasetSource(), other.datasetSource())
                && Objects.equals(datasetStatus(), other.datasetStatus())
                && Objects.equals(datasetCreationDate(), other.datasetCreationDate())
                && Objects.equals(datasetLastUpdateDate(), other.datasetLastUpdateDate())
                && Objects.equals(datasetVersion(), other.datasetVersion());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeDatasetResponse").add("DatasetId", datasetId()).add("DatasetArn", datasetArn())
                .add("DatasetName", datasetName()).add("DatasetDescription", datasetDescription())
                .add("DatasetSource", datasetSource()).add("DatasetStatus", datasetStatus())
                .add("DatasetCreationDate", datasetCreationDate()).add("DatasetLastUpdateDate", datasetLastUpdateDate())
                .add("DatasetVersion", datasetVersion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "datasetId":
            return Optional.ofNullable(clazz.cast(datasetId()));
        case "datasetArn":
            return Optional.ofNullable(clazz.cast(datasetArn()));
        case "datasetName":
            return Optional.ofNullable(clazz.cast(datasetName()));
        case "datasetDescription":
            return Optional.ofNullable(clazz.cast(datasetDescription()));
        case "datasetSource":
            return Optional.ofNullable(clazz.cast(datasetSource()));
        case "datasetStatus":
            return Optional.ofNullable(clazz.cast(datasetStatus()));
        case "datasetCreationDate":
            return Optional.ofNullable(clazz.cast(datasetCreationDate()));
        case "datasetLastUpdateDate":
            return Optional.ofNullable(clazz.cast(datasetLastUpdateDate()));
        case "datasetVersion":
            return Optional.ofNullable(clazz.cast(datasetVersion()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("datasetId", DATASET_ID_FIELD);
        map.put("datasetArn", DATASET_ARN_FIELD);
        map.put("datasetName", DATASET_NAME_FIELD);
        map.put("datasetDescription", DATASET_DESCRIPTION_FIELD);
        map.put("datasetSource", DATASET_SOURCE_FIELD);
        map.put("datasetStatus", DATASET_STATUS_FIELD);
        map.put("datasetCreationDate", DATASET_CREATION_DATE_FIELD);
        map.put("datasetLastUpdateDate", DATASET_LAST_UPDATE_DATE_FIELD);
        map.put("datasetVersion", DATASET_VERSION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeDatasetResponse, T> g) {
        return obj -> g.apply((DescribeDatasetResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends IoTSiteWiseResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeDatasetResponse> {
        /**
         * <p>
         * The ID of the dataset.
         * </p>
         * 
         * @param datasetId
         *        The ID of the dataset.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder datasetId(String datasetId);

        /**
         * <p>
         * The <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference-arns.html">ARN</a> of the dataset.
         * The format is <code>arn:${Partition}:iotsitewise:${Region}:${Account}:dataset/${DatasetId}</code>.
         * </p>
         * 
         * @param datasetArn
         *        The <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference-arns.html">ARN</a> of the
         *        dataset. The format is
         *        <code>arn:${Partition}:iotsitewise:${Region}:${Account}:dataset/${DatasetId}</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder datasetArn(String datasetArn);

        /**
         * <p>
         * The name of the dataset.
         * </p>
         * 
         * @param datasetName
         *        The name of the dataset.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder datasetName(String datasetName);

        /**
         * <p>
         * A description about the dataset, and its functionality.
         * </p>
         * 
         * @param datasetDescription
         *        A description about the dataset, and its functionality.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder datasetDescription(String datasetDescription);

        /**
         * <p>
         * The data source for the dataset.
         * </p>
         * 
         * @param datasetSource
         *        The data source for the dataset.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder datasetSource(DatasetSource datasetSource);

        /**
         * <p>
         * The data source for the dataset.
         * </p>
         * This is a convenience method that creates an instance of the {@link DatasetSource.Builder} avoiding the need
         * to create one manually via {@link DatasetSource#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DatasetSource.Builder#build()} is called immediately and its
         * result is passed to {@link #datasetSource(DatasetSource)}.
         * 
         * @param datasetSource
         *        a consumer that will call methods on {@link DatasetSource.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #datasetSource(DatasetSource)
         */
        default Builder datasetSource(Consumer<DatasetSource.Builder> datasetSource) {
            return datasetSource(DatasetSource.builder().applyMutation(datasetSource).build());
        }

        /**
         * <p>
         * The status of the dataset. This contains the state and any error messages. State is <code>CREATING</code>
         * after a successfull call to this API, and any associated error message. The state is <code>ACTIVE</code> when
         * ready to use.
         * </p>
         * 
         * @param datasetStatus
         *        The status of the dataset. This contains the state and any error messages. State is
         *        <code>CREATING</code> after a successfull call to this API, and any associated error message. The
         *        state is <code>ACTIVE</code> when ready to use.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder datasetStatus(DatasetStatus datasetStatus);

        /**
         * <p>
         * The status of the dataset. This contains the state and any error messages. State is <code>CREATING</code>
         * after a successfull call to this API, and any associated error message. The state is <code>ACTIVE</code> when
         * ready to use.
         * </p>
         * This is a convenience method that creates an instance of the {@link DatasetStatus.Builder} avoiding the need
         * to create one manually via {@link DatasetStatus#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DatasetStatus.Builder#build()} is called immediately and its
         * result is passed to {@link #datasetStatus(DatasetStatus)}.
         * 
         * @param datasetStatus
         *        a consumer that will call methods on {@link DatasetStatus.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #datasetStatus(DatasetStatus)
         */
        default Builder datasetStatus(Consumer<DatasetStatus.Builder> datasetStatus) {
            return datasetStatus(DatasetStatus.builder().applyMutation(datasetStatus).build());
        }

        /**
         * <p>
         * The dataset creation date, in Unix epoch time.
         * </p>
         * 
         * @param datasetCreationDate
         *        The dataset creation date, in Unix epoch time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder datasetCreationDate(Instant datasetCreationDate);

        /**
         * <p>
         * The date the dataset was last updated, in Unix epoch time.
         * </p>
         * 
         * @param datasetLastUpdateDate
         *        The date the dataset was last updated, in Unix epoch time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder datasetLastUpdateDate(Instant datasetLastUpdateDate);

        /**
         * <p>
         * The version of the dataset.
         * </p>
         * 
         * @param datasetVersion
         *        The version of the dataset.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder datasetVersion(String datasetVersion);
    }

    static final class BuilderImpl extends IoTSiteWiseResponse.BuilderImpl implements Builder {
        private String datasetId;

        private String datasetArn;

        private String datasetName;

        private String datasetDescription;

        private DatasetSource datasetSource;

        private DatasetStatus datasetStatus;

        private Instant datasetCreationDate;

        private Instant datasetLastUpdateDate;

        private String datasetVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeDatasetResponse model) {
            super(model);
            datasetId(model.datasetId);
            datasetArn(model.datasetArn);
            datasetName(model.datasetName);
            datasetDescription(model.datasetDescription);
            datasetSource(model.datasetSource);
            datasetStatus(model.datasetStatus);
            datasetCreationDate(model.datasetCreationDate);
            datasetLastUpdateDate(model.datasetLastUpdateDate);
            datasetVersion(model.datasetVersion);
        }

        public final String getDatasetId() {
            return datasetId;
        }

        public final void setDatasetId(String datasetId) {
            this.datasetId = datasetId;
        }

        @Override
        public final Builder datasetId(String datasetId) {
            this.datasetId = datasetId;
            return this;
        }

        public final String getDatasetArn() {
            return datasetArn;
        }

        public final void setDatasetArn(String datasetArn) {
            this.datasetArn = datasetArn;
        }

        @Override
        public final Builder datasetArn(String datasetArn) {
            this.datasetArn = datasetArn;
            return this;
        }

        public final String getDatasetName() {
            return datasetName;
        }

        public final void setDatasetName(String datasetName) {
            this.datasetName = datasetName;
        }

        @Override
        public final Builder datasetName(String datasetName) {
            this.datasetName = datasetName;
            return this;
        }

        public final String getDatasetDescription() {
            return datasetDescription;
        }

        public final void setDatasetDescription(String datasetDescription) {
            this.datasetDescription = datasetDescription;
        }

        @Override
        public final Builder datasetDescription(String datasetDescription) {
            this.datasetDescription = datasetDescription;
            return this;
        }

        public final DatasetSource.Builder getDatasetSource() {
            return datasetSource != null ? datasetSource.toBuilder() : null;
        }

        public final void setDatasetSource(DatasetSource.BuilderImpl datasetSource) {
            this.datasetSource = datasetSource != null ? datasetSource.build() : null;
        }

        @Override
        public final Builder datasetSource(DatasetSource datasetSource) {
            this.datasetSource = datasetSource;
            return this;
        }

        public final DatasetStatus.Builder getDatasetStatus() {
            return datasetStatus != null ? datasetStatus.toBuilder() : null;
        }

        public final void setDatasetStatus(DatasetStatus.BuilderImpl datasetStatus) {
            this.datasetStatus = datasetStatus != null ? datasetStatus.build() : null;
        }

        @Override
        public final Builder datasetStatus(DatasetStatus datasetStatus) {
            this.datasetStatus = datasetStatus;
            return this;
        }

        public final Instant getDatasetCreationDate() {
            return datasetCreationDate;
        }

        public final void setDatasetCreationDate(Instant datasetCreationDate) {
            this.datasetCreationDate = datasetCreationDate;
        }

        @Override
        public final Builder datasetCreationDate(Instant datasetCreationDate) {
            this.datasetCreationDate = datasetCreationDate;
            return this;
        }

        public final Instant getDatasetLastUpdateDate() {
            return datasetLastUpdateDate;
        }

        public final void setDatasetLastUpdateDate(Instant datasetLastUpdateDate) {
            this.datasetLastUpdateDate = datasetLastUpdateDate;
        }

        @Override
        public final Builder datasetLastUpdateDate(Instant datasetLastUpdateDate) {
            this.datasetLastUpdateDate = datasetLastUpdateDate;
            return this;
        }

        public final String getDatasetVersion() {
            return datasetVersion;
        }

        public final void setDatasetVersion(String datasetVersion) {
            this.datasetVersion = datasetVersion;
        }

        @Override
        public final Builder datasetVersion(String datasetVersion) {
            this.datasetVersion = datasetVersion;
            return this;
        }

        @Override
        public DescribeDatasetResponse build() {
            return new DescribeDatasetResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
