/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotsitewise.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeAssetModelResponse extends IoTSiteWiseResponse implements
        ToCopyableBuilder<DescribeAssetModelResponse.Builder, DescribeAssetModelResponse> {
    private static final SdkField<String> ASSET_MODEL_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("assetModelId").getter(getter(DescribeAssetModelResponse::assetModelId))
            .setter(setter(Builder::assetModelId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assetModelId").build()).build();

    private static final SdkField<String> ASSET_MODEL_EXTERNAL_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("assetModelExternalId").getter(getter(DescribeAssetModelResponse::assetModelExternalId))
            .setter(setter(Builder::assetModelExternalId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assetModelExternalId").build())
            .build();

    private static final SdkField<String> ASSET_MODEL_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("assetModelArn").getter(getter(DescribeAssetModelResponse::assetModelArn))
            .setter(setter(Builder::assetModelArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assetModelArn").build()).build();

    private static final SdkField<String> ASSET_MODEL_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("assetModelName").getter(getter(DescribeAssetModelResponse::assetModelName))
            .setter(setter(Builder::assetModelName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assetModelName").build()).build();

    private static final SdkField<String> ASSET_MODEL_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("assetModelType").getter(getter(DescribeAssetModelResponse::assetModelTypeAsString))
            .setter(setter(Builder::assetModelType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assetModelType").build()).build();

    private static final SdkField<String> ASSET_MODEL_DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("assetModelDescription").getter(getter(DescribeAssetModelResponse::assetModelDescription))
            .setter(setter(Builder::assetModelDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assetModelDescription").build())
            .build();

    private static final SdkField<List<AssetModelProperty>> ASSET_MODEL_PROPERTIES_FIELD = SdkField
            .<List<AssetModelProperty>> builder(MarshallingType.LIST)
            .memberName("assetModelProperties")
            .getter(getter(DescribeAssetModelResponse::assetModelProperties))
            .setter(setter(Builder::assetModelProperties))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assetModelProperties").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AssetModelProperty> builder(MarshallingType.SDK_POJO)
                                            .constructor(AssetModelProperty::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<AssetModelHierarchy>> ASSET_MODEL_HIERARCHIES_FIELD = SdkField
            .<List<AssetModelHierarchy>> builder(MarshallingType.LIST)
            .memberName("assetModelHierarchies")
            .getter(getter(DescribeAssetModelResponse::assetModelHierarchies))
            .setter(setter(Builder::assetModelHierarchies))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assetModelHierarchies").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AssetModelHierarchy> builder(MarshallingType.SDK_POJO)
                                            .constructor(AssetModelHierarchy::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<AssetModelCompositeModel>> ASSET_MODEL_COMPOSITE_MODELS_FIELD = SdkField
            .<List<AssetModelCompositeModel>> builder(MarshallingType.LIST)
            .memberName("assetModelCompositeModels")
            .getter(getter(DescribeAssetModelResponse::assetModelCompositeModels))
            .setter(setter(Builder::assetModelCompositeModels))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assetModelCompositeModels").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AssetModelCompositeModel> builder(MarshallingType.SDK_POJO)
                                            .constructor(AssetModelCompositeModel::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<AssetModelCompositeModelSummary>> ASSET_MODEL_COMPOSITE_MODEL_SUMMARIES_FIELD = SdkField
            .<List<AssetModelCompositeModelSummary>> builder(MarshallingType.LIST)
            .memberName("assetModelCompositeModelSummaries")
            .getter(getter(DescribeAssetModelResponse::assetModelCompositeModelSummaries))
            .setter(setter(Builder::assetModelCompositeModelSummaries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assetModelCompositeModelSummaries")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AssetModelCompositeModelSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(AssetModelCompositeModelSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Instant> ASSET_MODEL_CREATION_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("assetModelCreationDate").getter(getter(DescribeAssetModelResponse::assetModelCreationDate))
            .setter(setter(Builder::assetModelCreationDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assetModelCreationDate").build())
            .build();

    private static final SdkField<Instant> ASSET_MODEL_LAST_UPDATE_DATE_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT).memberName("assetModelLastUpdateDate")
            .getter(getter(DescribeAssetModelResponse::assetModelLastUpdateDate))
            .setter(setter(Builder::assetModelLastUpdateDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assetModelLastUpdateDate").build())
            .build();

    private static final SdkField<AssetModelStatus> ASSET_MODEL_STATUS_FIELD = SdkField
            .<AssetModelStatus> builder(MarshallingType.SDK_POJO).memberName("assetModelStatus")
            .getter(getter(DescribeAssetModelResponse::assetModelStatus)).setter(setter(Builder::assetModelStatus))
            .constructor(AssetModelStatus::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assetModelStatus").build()).build();

    private static final SdkField<String> ASSET_MODEL_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("assetModelVersion").getter(getter(DescribeAssetModelResponse::assetModelVersion))
            .setter(setter(Builder::assetModelVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assetModelVersion").build()).build();

    private static final SdkField<List<InterfaceRelationship>> INTERFACE_DETAILS_FIELD = SdkField
            .<List<InterfaceRelationship>> builder(MarshallingType.LIST)
            .memberName("interfaceDetails")
            .getter(getter(DescribeAssetModelResponse::interfaceDetails))
            .setter(setter(Builder::interfaceDetails))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("interfaceDetails").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<InterfaceRelationship> builder(MarshallingType.SDK_POJO)
                                            .constructor(InterfaceRelationship::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> E_TAG_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("eTag")
            .getter(getter(DescribeAssetModelResponse::eTag)).setter(setter(Builder::eTag))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("ETag").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSET_MODEL_ID_FIELD,
            ASSET_MODEL_EXTERNAL_ID_FIELD, ASSET_MODEL_ARN_FIELD, ASSET_MODEL_NAME_FIELD, ASSET_MODEL_TYPE_FIELD,
            ASSET_MODEL_DESCRIPTION_FIELD, ASSET_MODEL_PROPERTIES_FIELD, ASSET_MODEL_HIERARCHIES_FIELD,
            ASSET_MODEL_COMPOSITE_MODELS_FIELD, ASSET_MODEL_COMPOSITE_MODEL_SUMMARIES_FIELD, ASSET_MODEL_CREATION_DATE_FIELD,
            ASSET_MODEL_LAST_UPDATE_DATE_FIELD, ASSET_MODEL_STATUS_FIELD, ASSET_MODEL_VERSION_FIELD, INTERFACE_DETAILS_FIELD,
            E_TAG_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String assetModelId;

    private final String assetModelExternalId;

    private final String assetModelArn;

    private final String assetModelName;

    private final String assetModelType;

    private final String assetModelDescription;

    private final List<AssetModelProperty> assetModelProperties;

    private final List<AssetModelHierarchy> assetModelHierarchies;

    private final List<AssetModelCompositeModel> assetModelCompositeModels;

    private final List<AssetModelCompositeModelSummary> assetModelCompositeModelSummaries;

    private final Instant assetModelCreationDate;

    private final Instant assetModelLastUpdateDate;

    private final AssetModelStatus assetModelStatus;

    private final String assetModelVersion;

    private final List<InterfaceRelationship> interfaceDetails;

    private final String eTag;

    private DescribeAssetModelResponse(BuilderImpl builder) {
        super(builder);
        this.assetModelId = builder.assetModelId;
        this.assetModelExternalId = builder.assetModelExternalId;
        this.assetModelArn = builder.assetModelArn;
        this.assetModelName = builder.assetModelName;
        this.assetModelType = builder.assetModelType;
        this.assetModelDescription = builder.assetModelDescription;
        this.assetModelProperties = builder.assetModelProperties;
        this.assetModelHierarchies = builder.assetModelHierarchies;
        this.assetModelCompositeModels = builder.assetModelCompositeModels;
        this.assetModelCompositeModelSummaries = builder.assetModelCompositeModelSummaries;
        this.assetModelCreationDate = builder.assetModelCreationDate;
        this.assetModelLastUpdateDate = builder.assetModelLastUpdateDate;
        this.assetModelStatus = builder.assetModelStatus;
        this.assetModelVersion = builder.assetModelVersion;
        this.interfaceDetails = builder.interfaceDetails;
        this.eTag = builder.eTag;
    }

    /**
     * <p>
     * The ID of the asset model, in UUID format.
     * </p>
     * 
     * @return The ID of the asset model, in UUID format.
     */
    public final String assetModelId() {
        return assetModelId;
    }

    /**
     * <p>
     * The external ID of the asset model, if any.
     * </p>
     * 
     * @return The external ID of the asset model, if any.
     */
    public final String assetModelExternalId() {
        return assetModelExternalId;
    }

    /**
     * <p>
     * The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the asset
     * model, which has the following format.
     * </p>
     * <p>
     * <code>arn:${Partition}:iotsitewise:${Region}:${Account}:asset-model/${AssetModelId}</code>
     * </p>
     * 
     * @return The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the
     *         asset model, which has the following format.</p>
     *         <p>
     *         <code>arn:${Partition}:iotsitewise:${Region}:${Account}:asset-model/${AssetModelId}</code>
     */
    public final String assetModelArn() {
        return assetModelArn;
    }

    /**
     * <p>
     * The name of the asset model.
     * </p>
     * 
     * @return The name of the asset model.
     */
    public final String assetModelName() {
        return assetModelName;
    }

    /**
     * <p>
     * The type of asset model.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>ASSET_MODEL</b> – (default) An asset model that you can use to create assets. Can't be included as a component
     * in another asset model.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>COMPONENT_MODEL</b> – A reusable component that you can include in the composite models of other asset models.
     * You can't create assets directly from this type of asset model.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #assetModelType}
     * will return {@link AssetModelType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #assetModelTypeAsString}.
     * </p>
     * 
     * @return The type of asset model.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <b>ASSET_MODEL</b> – (default) An asset model that you can use to create assets. Can't be included as a
     *         component in another asset model.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>COMPONENT_MODEL</b> – A reusable component that you can include in the composite models of other asset
     *         models. You can't create assets directly from this type of asset model.
     *         </p>
     *         </li>
     * @see AssetModelType
     */
    public final AssetModelType assetModelType() {
        return AssetModelType.fromValue(assetModelType);
    }

    /**
     * <p>
     * The type of asset model.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>ASSET_MODEL</b> – (default) An asset model that you can use to create assets. Can't be included as a component
     * in another asset model.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>COMPONENT_MODEL</b> – A reusable component that you can include in the composite models of other asset models.
     * You can't create assets directly from this type of asset model.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #assetModelType}
     * will return {@link AssetModelType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #assetModelTypeAsString}.
     * </p>
     * 
     * @return The type of asset model.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <b>ASSET_MODEL</b> – (default) An asset model that you can use to create assets. Can't be included as a
     *         component in another asset model.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>COMPONENT_MODEL</b> – A reusable component that you can include in the composite models of other asset
     *         models. You can't create assets directly from this type of asset model.
     *         </p>
     *         </li>
     * @see AssetModelType
     */
    public final String assetModelTypeAsString() {
        return assetModelType;
    }

    /**
     * <p>
     * The asset model's description.
     * </p>
     * 
     * @return The asset model's description.
     */
    public final String assetModelDescription() {
        return assetModelDescription;
    }

    /**
     * For responses, this returns true if the service returned a value for the AssetModelProperties property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAssetModelProperties() {
        return assetModelProperties != null && !(assetModelProperties instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of asset properties for the asset model.
     * </p>
     * <p>
     * This object doesn't include properties that you define in composite models. You can find composite model
     * properties in the <code>assetModelCompositeModels</code> object.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAssetModelProperties} method.
     * </p>
     * 
     * @return The list of asset properties for the asset model.</p>
     *         <p>
     *         This object doesn't include properties that you define in composite models. You can find composite model
     *         properties in the <code>assetModelCompositeModels</code> object.
     */
    public final List<AssetModelProperty> assetModelProperties() {
        return assetModelProperties;
    }

    /**
     * For responses, this returns true if the service returned a value for the AssetModelHierarchies property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasAssetModelHierarchies() {
        return assetModelHierarchies != null && !(assetModelHierarchies instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of asset model hierarchies that each contain a <code>childAssetModelId</code> and a
     * <code>hierarchyId</code> (named <code>id</code>). A hierarchy specifies allowed parent/child asset relationships
     * for an asset model.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAssetModelHierarchies} method.
     * </p>
     * 
     * @return A list of asset model hierarchies that each contain a <code>childAssetModelId</code> and a
     *         <code>hierarchyId</code> (named <code>id</code>). A hierarchy specifies allowed parent/child asset
     *         relationships for an asset model.
     */
    public final List<AssetModelHierarchy> assetModelHierarchies() {
        return assetModelHierarchies;
    }

    /**
     * For responses, this returns true if the service returned a value for the AssetModelCompositeModels property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasAssetModelCompositeModels() {
        return assetModelCompositeModels != null && !(assetModelCompositeModels instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of built-in composite models for the asset model, such as those with those of type
     * <code>AWS/ALARMS</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAssetModelCompositeModels} method.
     * </p>
     * 
     * @return The list of built-in composite models for the asset model, such as those with those of type
     *         <code>AWS/ALARMS</code>.
     */
    public final List<AssetModelCompositeModel> assetModelCompositeModels() {
        return assetModelCompositeModels;
    }

    /**
     * For responses, this returns true if the service returned a value for the AssetModelCompositeModelSummaries
     * property. This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()}
     * method on the property). This is useful because the SDK will never return a null collection or map, but you may
     * need to differentiate between the service returning nothing (or null) and the service returning an empty
     * collection or map. For requests, this returns true if a value for the property was specified in the request
     * builder, and false if a value was not specified.
     */
    public final boolean hasAssetModelCompositeModelSummaries() {
        return assetModelCompositeModelSummaries != null && !(assetModelCompositeModelSummaries instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of the immediate child custom composite model summaries for the asset model.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAssetModelCompositeModelSummaries}
     * method.
     * </p>
     * 
     * @return The list of the immediate child custom composite model summaries for the asset model.
     */
    public final List<AssetModelCompositeModelSummary> assetModelCompositeModelSummaries() {
        return assetModelCompositeModelSummaries;
    }

    /**
     * <p>
     * The date the asset model was created, in Unix epoch time.
     * </p>
     * 
     * @return The date the asset model was created, in Unix epoch time.
     */
    public final Instant assetModelCreationDate() {
        return assetModelCreationDate;
    }

    /**
     * <p>
     * The date the asset model was last updated, in Unix epoch time.
     * </p>
     * 
     * @return The date the asset model was last updated, in Unix epoch time.
     */
    public final Instant assetModelLastUpdateDate() {
        return assetModelLastUpdateDate;
    }

    /**
     * <p>
     * The current status of the asset model, which contains a state and any error message.
     * </p>
     * 
     * @return The current status of the asset model, which contains a state and any error message.
     */
    public final AssetModelStatus assetModelStatus() {
        return assetModelStatus;
    }

    /**
     * <p>
     * The version of the asset model. See <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/model-active-version.html"> Asset model
     * versions</a> in the <i>IoT SiteWise User Guide</i>.
     * </p>
     * 
     * @return The version of the asset model. See <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/model-active-version.html"> Asset model
     *         versions</a> in the <i>IoT SiteWise User Guide</i>.
     */
    public final String assetModelVersion() {
        return assetModelVersion;
    }

    /**
     * For responses, this returns true if the service returned a value for the InterfaceDetails property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasInterfaceDetails() {
        return interfaceDetails != null && !(interfaceDetails instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of interface details that describe the interfaces implemented by this asset model, including interface
     * asset model IDs and property mappings.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasInterfaceDetails} method.
     * </p>
     * 
     * @return A list of interface details that describe the interfaces implemented by this asset model, including
     *         interface asset model IDs and property mappings.
     */
    public final List<InterfaceRelationship> interfaceDetails() {
        return interfaceDetails;
    }

    /**
     * <p>
     * The entity tag (ETag) is a hash of the retrieved version of the asset model. It's used to make concurrent updates
     * safely to the resource. See <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/opt-locking-for-model.html">Optimistic locking
     * for asset model writes</a> in the <i>IoT SiteWise User Guide</i>.
     * </p>
     * <p>
     * See <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/opt-locking-for-model.html"> Optimistic
     * locking for asset model writes</a> in the <i>IoT SiteWise User Guide</i>.
     * </p>
     * 
     * @return The entity tag (ETag) is a hash of the retrieved version of the asset model. It's used to make concurrent
     *         updates safely to the resource. See <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/opt-locking-for-model.html">Optimistic
     *         locking for asset model writes</a> in the <i>IoT SiteWise User Guide</i>. </p>
     *         <p>
     *         See <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/opt-locking-for-model.html">
     *         Optimistic locking for asset model writes</a> in the <i>IoT SiteWise User Guide</i>.
     */
    public final String eTag() {
        return eTag;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(assetModelId());
        hashCode = 31 * hashCode + Objects.hashCode(assetModelExternalId());
        hashCode = 31 * hashCode + Objects.hashCode(assetModelArn());
        hashCode = 31 * hashCode + Objects.hashCode(assetModelName());
        hashCode = 31 * hashCode + Objects.hashCode(assetModelTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(assetModelDescription());
        hashCode = 31 * hashCode + Objects.hashCode(hasAssetModelProperties() ? assetModelProperties() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasAssetModelHierarchies() ? assetModelHierarchies() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasAssetModelCompositeModels() ? assetModelCompositeModels() : null);
        hashCode = 31 * hashCode
                + Objects.hashCode(hasAssetModelCompositeModelSummaries() ? assetModelCompositeModelSummaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(assetModelCreationDate());
        hashCode = 31 * hashCode + Objects.hashCode(assetModelLastUpdateDate());
        hashCode = 31 * hashCode + Objects.hashCode(assetModelStatus());
        hashCode = 31 * hashCode + Objects.hashCode(assetModelVersion());
        hashCode = 31 * hashCode + Objects.hashCode(hasInterfaceDetails() ? interfaceDetails() : null);
        hashCode = 31 * hashCode + Objects.hashCode(eTag());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeAssetModelResponse)) {
            return false;
        }
        DescribeAssetModelResponse other = (DescribeAssetModelResponse) obj;
        return Objects.equals(assetModelId(), other.assetModelId())
                && Objects.equals(assetModelExternalId(), other.assetModelExternalId())
                && Objects.equals(assetModelArn(), other.assetModelArn())
                && Objects.equals(assetModelName(), other.assetModelName())
                && Objects.equals(assetModelTypeAsString(), other.assetModelTypeAsString())
                && Objects.equals(assetModelDescription(), other.assetModelDescription())
                && hasAssetModelProperties() == other.hasAssetModelProperties()
                && Objects.equals(assetModelProperties(), other.assetModelProperties())
                && hasAssetModelHierarchies() == other.hasAssetModelHierarchies()
                && Objects.equals(assetModelHierarchies(), other.assetModelHierarchies())
                && hasAssetModelCompositeModels() == other.hasAssetModelCompositeModels()
                && Objects.equals(assetModelCompositeModels(), other.assetModelCompositeModels())
                && hasAssetModelCompositeModelSummaries() == other.hasAssetModelCompositeModelSummaries()
                && Objects.equals(assetModelCompositeModelSummaries(), other.assetModelCompositeModelSummaries())
                && Objects.equals(assetModelCreationDate(), other.assetModelCreationDate())
                && Objects.equals(assetModelLastUpdateDate(), other.assetModelLastUpdateDate())
                && Objects.equals(assetModelStatus(), other.assetModelStatus())
                && Objects.equals(assetModelVersion(), other.assetModelVersion())
                && hasInterfaceDetails() == other.hasInterfaceDetails()
                && Objects.equals(interfaceDetails(), other.interfaceDetails()) && Objects.equals(eTag(), other.eTag());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("DescribeAssetModelResponse")
                .add("AssetModelId", assetModelId())
                .add("AssetModelExternalId", assetModelExternalId())
                .add("AssetModelArn", assetModelArn())
                .add("AssetModelName", assetModelName())
                .add("AssetModelType", assetModelTypeAsString())
                .add("AssetModelDescription", assetModelDescription())
                .add("AssetModelProperties", hasAssetModelProperties() ? assetModelProperties() : null)
                .add("AssetModelHierarchies", hasAssetModelHierarchies() ? assetModelHierarchies() : null)
                .add("AssetModelCompositeModels", hasAssetModelCompositeModels() ? assetModelCompositeModels() : null)
                .add("AssetModelCompositeModelSummaries",
                        hasAssetModelCompositeModelSummaries() ? assetModelCompositeModelSummaries() : null)
                .add("AssetModelCreationDate", assetModelCreationDate())
                .add("AssetModelLastUpdateDate", assetModelLastUpdateDate()).add("AssetModelStatus", assetModelStatus())
                .add("AssetModelVersion", assetModelVersion())
                .add("InterfaceDetails", hasInterfaceDetails() ? interfaceDetails() : null).add("ETag", eTag()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "assetModelId":
            return Optional.ofNullable(clazz.cast(assetModelId()));
        case "assetModelExternalId":
            return Optional.ofNullable(clazz.cast(assetModelExternalId()));
        case "assetModelArn":
            return Optional.ofNullable(clazz.cast(assetModelArn()));
        case "assetModelName":
            return Optional.ofNullable(clazz.cast(assetModelName()));
        case "assetModelType":
            return Optional.ofNullable(clazz.cast(assetModelTypeAsString()));
        case "assetModelDescription":
            return Optional.ofNullable(clazz.cast(assetModelDescription()));
        case "assetModelProperties":
            return Optional.ofNullable(clazz.cast(assetModelProperties()));
        case "assetModelHierarchies":
            return Optional.ofNullable(clazz.cast(assetModelHierarchies()));
        case "assetModelCompositeModels":
            return Optional.ofNullable(clazz.cast(assetModelCompositeModels()));
        case "assetModelCompositeModelSummaries":
            return Optional.ofNullable(clazz.cast(assetModelCompositeModelSummaries()));
        case "assetModelCreationDate":
            return Optional.ofNullable(clazz.cast(assetModelCreationDate()));
        case "assetModelLastUpdateDate":
            return Optional.ofNullable(clazz.cast(assetModelLastUpdateDate()));
        case "assetModelStatus":
            return Optional.ofNullable(clazz.cast(assetModelStatus()));
        case "assetModelVersion":
            return Optional.ofNullable(clazz.cast(assetModelVersion()));
        case "interfaceDetails":
            return Optional.ofNullable(clazz.cast(interfaceDetails()));
        case "eTag":
            return Optional.ofNullable(clazz.cast(eTag()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("assetModelId", ASSET_MODEL_ID_FIELD);
        map.put("assetModelExternalId", ASSET_MODEL_EXTERNAL_ID_FIELD);
        map.put("assetModelArn", ASSET_MODEL_ARN_FIELD);
        map.put("assetModelName", ASSET_MODEL_NAME_FIELD);
        map.put("assetModelType", ASSET_MODEL_TYPE_FIELD);
        map.put("assetModelDescription", ASSET_MODEL_DESCRIPTION_FIELD);
        map.put("assetModelProperties", ASSET_MODEL_PROPERTIES_FIELD);
        map.put("assetModelHierarchies", ASSET_MODEL_HIERARCHIES_FIELD);
        map.put("assetModelCompositeModels", ASSET_MODEL_COMPOSITE_MODELS_FIELD);
        map.put("assetModelCompositeModelSummaries", ASSET_MODEL_COMPOSITE_MODEL_SUMMARIES_FIELD);
        map.put("assetModelCreationDate", ASSET_MODEL_CREATION_DATE_FIELD);
        map.put("assetModelLastUpdateDate", ASSET_MODEL_LAST_UPDATE_DATE_FIELD);
        map.put("assetModelStatus", ASSET_MODEL_STATUS_FIELD);
        map.put("assetModelVersion", ASSET_MODEL_VERSION_FIELD);
        map.put("interfaceDetails", INTERFACE_DETAILS_FIELD);
        map.put("ETag", E_TAG_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeAssetModelResponse, T> g) {
        return obj -> g.apply((DescribeAssetModelResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends IoTSiteWiseResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeAssetModelResponse> {
        /**
         * <p>
         * The ID of the asset model, in UUID format.
         * </p>
         * 
         * @param assetModelId
         *        The ID of the asset model, in UUID format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assetModelId(String assetModelId);

        /**
         * <p>
         * The external ID of the asset model, if any.
         * </p>
         * 
         * @param assetModelExternalId
         *        The external ID of the asset model, if any.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assetModelExternalId(String assetModelExternalId);

        /**
         * <p>
         * The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the asset
         * model, which has the following format.
         * </p>
         * <p>
         * <code>arn:${Partition}:iotsitewise:${Region}:${Account}:asset-model/${AssetModelId}</code>
         * </p>
         * 
         * @param assetModelArn
         *        The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of
         *        the asset model, which has the following format.</p>
         *        <p>
         *        <code>arn:${Partition}:iotsitewise:${Region}:${Account}:asset-model/${AssetModelId}</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assetModelArn(String assetModelArn);

        /**
         * <p>
         * The name of the asset model.
         * </p>
         * 
         * @param assetModelName
         *        The name of the asset model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assetModelName(String assetModelName);

        /**
         * <p>
         * The type of asset model.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <b>ASSET_MODEL</b> – (default) An asset model that you can use to create assets. Can't be included as a
         * component in another asset model.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>COMPONENT_MODEL</b> – A reusable component that you can include in the composite models of other asset
         * models. You can't create assets directly from this type of asset model.
         * </p>
         * </li>
         * </ul>
         * 
         * @param assetModelType
         *        The type of asset model.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <b>ASSET_MODEL</b> – (default) An asset model that you can use to create assets. Can't be included as
         *        a component in another asset model.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>COMPONENT_MODEL</b> – A reusable component that you can include in the composite models of other
         *        asset models. You can't create assets directly from this type of asset model.
         *        </p>
         *        </li>
         * @see AssetModelType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AssetModelType
         */
        Builder assetModelType(String assetModelType);

        /**
         * <p>
         * The type of asset model.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <b>ASSET_MODEL</b> – (default) An asset model that you can use to create assets. Can't be included as a
         * component in another asset model.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>COMPONENT_MODEL</b> – A reusable component that you can include in the composite models of other asset
         * models. You can't create assets directly from this type of asset model.
         * </p>
         * </li>
         * </ul>
         * 
         * @param assetModelType
         *        The type of asset model.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <b>ASSET_MODEL</b> – (default) An asset model that you can use to create assets. Can't be included as
         *        a component in another asset model.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>COMPONENT_MODEL</b> – A reusable component that you can include in the composite models of other
         *        asset models. You can't create assets directly from this type of asset model.
         *        </p>
         *        </li>
         * @see AssetModelType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AssetModelType
         */
        Builder assetModelType(AssetModelType assetModelType);

        /**
         * <p>
         * The asset model's description.
         * </p>
         * 
         * @param assetModelDescription
         *        The asset model's description.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assetModelDescription(String assetModelDescription);

        /**
         * <p>
         * The list of asset properties for the asset model.
         * </p>
         * <p>
         * This object doesn't include properties that you define in composite models. You can find composite model
         * properties in the <code>assetModelCompositeModels</code> object.
         * </p>
         * 
         * @param assetModelProperties
         *        The list of asset properties for the asset model.</p>
         *        <p>
         *        This object doesn't include properties that you define in composite models. You can find composite
         *        model properties in the <code>assetModelCompositeModels</code> object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assetModelProperties(Collection<AssetModelProperty> assetModelProperties);

        /**
         * <p>
         * The list of asset properties for the asset model.
         * </p>
         * <p>
         * This object doesn't include properties that you define in composite models. You can find composite model
         * properties in the <code>assetModelCompositeModels</code> object.
         * </p>
         * 
         * @param assetModelProperties
         *        The list of asset properties for the asset model.</p>
         *        <p>
         *        This object doesn't include properties that you define in composite models. You can find composite
         *        model properties in the <code>assetModelCompositeModels</code> object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assetModelProperties(AssetModelProperty... assetModelProperties);

        /**
         * <p>
         * The list of asset properties for the asset model.
         * </p>
         * <p>
         * This object doesn't include properties that you define in composite models. You can find composite model
         * properties in the <code>assetModelCompositeModels</code> object.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.iotsitewise.model.AssetModelProperty.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.iotsitewise.model.AssetModelProperty#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.iotsitewise.model.AssetModelProperty.Builder#build()} is called
         * immediately and its result is passed to {@link #assetModelProperties(List<AssetModelProperty>)}.
         * 
         * @param assetModelProperties
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.iotsitewise.model.AssetModelProperty.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #assetModelProperties(java.util.Collection<AssetModelProperty>)
         */
        Builder assetModelProperties(Consumer<AssetModelProperty.Builder>... assetModelProperties);

        /**
         * <p>
         * A list of asset model hierarchies that each contain a <code>childAssetModelId</code> and a
         * <code>hierarchyId</code> (named <code>id</code>). A hierarchy specifies allowed parent/child asset
         * relationships for an asset model.
         * </p>
         * 
         * @param assetModelHierarchies
         *        A list of asset model hierarchies that each contain a <code>childAssetModelId</code> and a
         *        <code>hierarchyId</code> (named <code>id</code>). A hierarchy specifies allowed parent/child asset
         *        relationships for an asset model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assetModelHierarchies(Collection<AssetModelHierarchy> assetModelHierarchies);

        /**
         * <p>
         * A list of asset model hierarchies that each contain a <code>childAssetModelId</code> and a
         * <code>hierarchyId</code> (named <code>id</code>). A hierarchy specifies allowed parent/child asset
         * relationships for an asset model.
         * </p>
         * 
         * @param assetModelHierarchies
         *        A list of asset model hierarchies that each contain a <code>childAssetModelId</code> and a
         *        <code>hierarchyId</code> (named <code>id</code>). A hierarchy specifies allowed parent/child asset
         *        relationships for an asset model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assetModelHierarchies(AssetModelHierarchy... assetModelHierarchies);

        /**
         * <p>
         * A list of asset model hierarchies that each contain a <code>childAssetModelId</code> and a
         * <code>hierarchyId</code> (named <code>id</code>). A hierarchy specifies allowed parent/child asset
         * relationships for an asset model.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.iotsitewise.model.AssetModelHierarchy.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.iotsitewise.model.AssetModelHierarchy#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.iotsitewise.model.AssetModelHierarchy.Builder#build()} is called
         * immediately and its result is passed to {@link #assetModelHierarchies(List<AssetModelHierarchy>)}.
         * 
         * @param assetModelHierarchies
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.iotsitewise.model.AssetModelHierarchy.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #assetModelHierarchies(java.util.Collection<AssetModelHierarchy>)
         */
        Builder assetModelHierarchies(Consumer<AssetModelHierarchy.Builder>... assetModelHierarchies);

        /**
         * <p>
         * The list of built-in composite models for the asset model, such as those with those of type
         * <code>AWS/ALARMS</code>.
         * </p>
         * 
         * @param assetModelCompositeModels
         *        The list of built-in composite models for the asset model, such as those with those of type
         *        <code>AWS/ALARMS</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assetModelCompositeModels(Collection<AssetModelCompositeModel> assetModelCompositeModels);

        /**
         * <p>
         * The list of built-in composite models for the asset model, such as those with those of type
         * <code>AWS/ALARMS</code>.
         * </p>
         * 
         * @param assetModelCompositeModels
         *        The list of built-in composite models for the asset model, such as those with those of type
         *        <code>AWS/ALARMS</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assetModelCompositeModels(AssetModelCompositeModel... assetModelCompositeModels);

        /**
         * <p>
         * The list of built-in composite models for the asset model, such as those with those of type
         * <code>AWS/ALARMS</code>.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.iotsitewise.model.AssetModelCompositeModel.Builder} avoiding the need
         * to create one manually via
         * {@link software.amazon.awssdk.services.iotsitewise.model.AssetModelCompositeModel#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.iotsitewise.model.AssetModelCompositeModel.Builder#build()} is called
         * immediately and its result is passed to {@link #assetModelCompositeModels(List<AssetModelCompositeModel>)}.
         * 
         * @param assetModelCompositeModels
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.iotsitewise.model.AssetModelCompositeModel.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #assetModelCompositeModels(java.util.Collection<AssetModelCompositeModel>)
         */
        Builder assetModelCompositeModels(Consumer<AssetModelCompositeModel.Builder>... assetModelCompositeModels);

        /**
         * <p>
         * The list of the immediate child custom composite model summaries for the asset model.
         * </p>
         * 
         * @param assetModelCompositeModelSummaries
         *        The list of the immediate child custom composite model summaries for the asset model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assetModelCompositeModelSummaries(Collection<AssetModelCompositeModelSummary> assetModelCompositeModelSummaries);

        /**
         * <p>
         * The list of the immediate child custom composite model summaries for the asset model.
         * </p>
         * 
         * @param assetModelCompositeModelSummaries
         *        The list of the immediate child custom composite model summaries for the asset model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assetModelCompositeModelSummaries(AssetModelCompositeModelSummary... assetModelCompositeModelSummaries);

        /**
         * <p>
         * The list of the immediate child custom composite model summaries for the asset model.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.iotsitewise.model.AssetModelCompositeModelSummary.Builder} avoiding
         * the need to create one manually via
         * {@link software.amazon.awssdk.services.iotsitewise.model.AssetModelCompositeModelSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.iotsitewise.model.AssetModelCompositeModelSummary.Builder#build()} is
         * called immediately and its result is passed to {@link
         * #assetModelCompositeModelSummaries(List<AssetModelCompositeModelSummary>)}.
         * 
         * @param assetModelCompositeModelSummaries
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.iotsitewise.model.AssetModelCompositeModelSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #assetModelCompositeModelSummaries(java.util.Collection<AssetModelCompositeModelSummary>)
         */
        Builder assetModelCompositeModelSummaries(
                Consumer<AssetModelCompositeModelSummary.Builder>... assetModelCompositeModelSummaries);

        /**
         * <p>
         * The date the asset model was created, in Unix epoch time.
         * </p>
         * 
         * @param assetModelCreationDate
         *        The date the asset model was created, in Unix epoch time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assetModelCreationDate(Instant assetModelCreationDate);

        /**
         * <p>
         * The date the asset model was last updated, in Unix epoch time.
         * </p>
         * 
         * @param assetModelLastUpdateDate
         *        The date the asset model was last updated, in Unix epoch time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assetModelLastUpdateDate(Instant assetModelLastUpdateDate);

        /**
         * <p>
         * The current status of the asset model, which contains a state and any error message.
         * </p>
         * 
         * @param assetModelStatus
         *        The current status of the asset model, which contains a state and any error message.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assetModelStatus(AssetModelStatus assetModelStatus);

        /**
         * <p>
         * The current status of the asset model, which contains a state and any error message.
         * </p>
         * This is a convenience method that creates an instance of the {@link AssetModelStatus.Builder} avoiding the
         * need to create one manually via {@link AssetModelStatus#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AssetModelStatus.Builder#build()} is called immediately and its
         * result is passed to {@link #assetModelStatus(AssetModelStatus)}.
         * 
         * @param assetModelStatus
         *        a consumer that will call methods on {@link AssetModelStatus.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #assetModelStatus(AssetModelStatus)
         */
        default Builder assetModelStatus(Consumer<AssetModelStatus.Builder> assetModelStatus) {
            return assetModelStatus(AssetModelStatus.builder().applyMutation(assetModelStatus).build());
        }

        /**
         * <p>
         * The version of the asset model. See <a
         * href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/model-active-version.html"> Asset model
         * versions</a> in the <i>IoT SiteWise User Guide</i>.
         * </p>
         * 
         * @param assetModelVersion
         *        The version of the asset model. See <a
         *        href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/model-active-version.html"> Asset
         *        model versions</a> in the <i>IoT SiteWise User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assetModelVersion(String assetModelVersion);

        /**
         * <p>
         * A list of interface details that describe the interfaces implemented by this asset model, including interface
         * asset model IDs and property mappings.
         * </p>
         * 
         * @param interfaceDetails
         *        A list of interface details that describe the interfaces implemented by this asset model, including
         *        interface asset model IDs and property mappings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder interfaceDetails(Collection<InterfaceRelationship> interfaceDetails);

        /**
         * <p>
         * A list of interface details that describe the interfaces implemented by this asset model, including interface
         * asset model IDs and property mappings.
         * </p>
         * 
         * @param interfaceDetails
         *        A list of interface details that describe the interfaces implemented by this asset model, including
         *        interface asset model IDs and property mappings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder interfaceDetails(InterfaceRelationship... interfaceDetails);

        /**
         * <p>
         * A list of interface details that describe the interfaces implemented by this asset model, including interface
         * asset model IDs and property mappings.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.iotsitewise.model.InterfaceRelationship.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.iotsitewise.model.InterfaceRelationship#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.iotsitewise.model.InterfaceRelationship.Builder#build()} is called
         * immediately and its result is passed to {@link #interfaceDetails(List<InterfaceRelationship>)}.
         * 
         * @param interfaceDetails
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.iotsitewise.model.InterfaceRelationship.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #interfaceDetails(java.util.Collection<InterfaceRelationship>)
         */
        Builder interfaceDetails(Consumer<InterfaceRelationship.Builder>... interfaceDetails);

        /**
         * <p>
         * The entity tag (ETag) is a hash of the retrieved version of the asset model. It's used to make concurrent
         * updates safely to the resource. See <a
         * href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/opt-locking-for-model.html">Optimistic
         * locking for asset model writes</a> in the <i>IoT SiteWise User Guide</i>.
         * </p>
         * <p>
         * See <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/opt-locking-for-model.html">
         * Optimistic locking for asset model writes</a> in the <i>IoT SiteWise User Guide</i>.
         * </p>
         * 
         * @param eTag
         *        The entity tag (ETag) is a hash of the retrieved version of the asset model. It's used to make
         *        concurrent updates safely to the resource. See <a
         *        href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/opt-locking-for-model.html">Optimistic
         *        locking for asset model writes</a> in the <i>IoT SiteWise User Guide</i>. </p>
         *        <p>
         *        See <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/opt-locking-for-model.html">
         *        Optimistic locking for asset model writes</a> in the <i>IoT SiteWise User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eTag(String eTag);
    }

    static final class BuilderImpl extends IoTSiteWiseResponse.BuilderImpl implements Builder {
        private String assetModelId;

        private String assetModelExternalId;

        private String assetModelArn;

        private String assetModelName;

        private String assetModelType;

        private String assetModelDescription;

        private List<AssetModelProperty> assetModelProperties = DefaultSdkAutoConstructList.getInstance();

        private List<AssetModelHierarchy> assetModelHierarchies = DefaultSdkAutoConstructList.getInstance();

        private List<AssetModelCompositeModel> assetModelCompositeModels = DefaultSdkAutoConstructList.getInstance();

        private List<AssetModelCompositeModelSummary> assetModelCompositeModelSummaries = DefaultSdkAutoConstructList
                .getInstance();

        private Instant assetModelCreationDate;

        private Instant assetModelLastUpdateDate;

        private AssetModelStatus assetModelStatus;

        private String assetModelVersion;

        private List<InterfaceRelationship> interfaceDetails = DefaultSdkAutoConstructList.getInstance();

        private String eTag;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeAssetModelResponse model) {
            super(model);
            assetModelId(model.assetModelId);
            assetModelExternalId(model.assetModelExternalId);
            assetModelArn(model.assetModelArn);
            assetModelName(model.assetModelName);
            assetModelType(model.assetModelType);
            assetModelDescription(model.assetModelDescription);
            assetModelProperties(model.assetModelProperties);
            assetModelHierarchies(model.assetModelHierarchies);
            assetModelCompositeModels(model.assetModelCompositeModels);
            assetModelCompositeModelSummaries(model.assetModelCompositeModelSummaries);
            assetModelCreationDate(model.assetModelCreationDate);
            assetModelLastUpdateDate(model.assetModelLastUpdateDate);
            assetModelStatus(model.assetModelStatus);
            assetModelVersion(model.assetModelVersion);
            interfaceDetails(model.interfaceDetails);
            eTag(model.eTag);
        }

        public final String getAssetModelId() {
            return assetModelId;
        }

        public final void setAssetModelId(String assetModelId) {
            this.assetModelId = assetModelId;
        }

        @Override
        public final Builder assetModelId(String assetModelId) {
            this.assetModelId = assetModelId;
            return this;
        }

        public final String getAssetModelExternalId() {
            return assetModelExternalId;
        }

        public final void setAssetModelExternalId(String assetModelExternalId) {
            this.assetModelExternalId = assetModelExternalId;
        }

        @Override
        public final Builder assetModelExternalId(String assetModelExternalId) {
            this.assetModelExternalId = assetModelExternalId;
            return this;
        }

        public final String getAssetModelArn() {
            return assetModelArn;
        }

        public final void setAssetModelArn(String assetModelArn) {
            this.assetModelArn = assetModelArn;
        }

        @Override
        public final Builder assetModelArn(String assetModelArn) {
            this.assetModelArn = assetModelArn;
            return this;
        }

        public final String getAssetModelName() {
            return assetModelName;
        }

        public final void setAssetModelName(String assetModelName) {
            this.assetModelName = assetModelName;
        }

        @Override
        public final Builder assetModelName(String assetModelName) {
            this.assetModelName = assetModelName;
            return this;
        }

        public final String getAssetModelType() {
            return assetModelType;
        }

        public final void setAssetModelType(String assetModelType) {
            this.assetModelType = assetModelType;
        }

        @Override
        public final Builder assetModelType(String assetModelType) {
            this.assetModelType = assetModelType;
            return this;
        }

        @Override
        public final Builder assetModelType(AssetModelType assetModelType) {
            this.assetModelType(assetModelType == null ? null : assetModelType.toString());
            return this;
        }

        public final String getAssetModelDescription() {
            return assetModelDescription;
        }

        public final void setAssetModelDescription(String assetModelDescription) {
            this.assetModelDescription = assetModelDescription;
        }

        @Override
        public final Builder assetModelDescription(String assetModelDescription) {
            this.assetModelDescription = assetModelDescription;
            return this;
        }

        public final List<AssetModelProperty.Builder> getAssetModelProperties() {
            List<AssetModelProperty.Builder> result = AssetModelPropertiesCopier.copyToBuilder(this.assetModelProperties);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAssetModelProperties(Collection<AssetModelProperty.BuilderImpl> assetModelProperties) {
            this.assetModelProperties = AssetModelPropertiesCopier.copyFromBuilder(assetModelProperties);
        }

        @Override
        public final Builder assetModelProperties(Collection<AssetModelProperty> assetModelProperties) {
            this.assetModelProperties = AssetModelPropertiesCopier.copy(assetModelProperties);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder assetModelProperties(AssetModelProperty... assetModelProperties) {
            assetModelProperties(Arrays.asList(assetModelProperties));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder assetModelProperties(Consumer<AssetModelProperty.Builder>... assetModelProperties) {
            assetModelProperties(Stream.of(assetModelProperties).map(c -> AssetModelProperty.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<AssetModelHierarchy.Builder> getAssetModelHierarchies() {
            List<AssetModelHierarchy.Builder> result = AssetModelHierarchiesCopier.copyToBuilder(this.assetModelHierarchies);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAssetModelHierarchies(Collection<AssetModelHierarchy.BuilderImpl> assetModelHierarchies) {
            this.assetModelHierarchies = AssetModelHierarchiesCopier.copyFromBuilder(assetModelHierarchies);
        }

        @Override
        public final Builder assetModelHierarchies(Collection<AssetModelHierarchy> assetModelHierarchies) {
            this.assetModelHierarchies = AssetModelHierarchiesCopier.copy(assetModelHierarchies);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder assetModelHierarchies(AssetModelHierarchy... assetModelHierarchies) {
            assetModelHierarchies(Arrays.asList(assetModelHierarchies));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder assetModelHierarchies(Consumer<AssetModelHierarchy.Builder>... assetModelHierarchies) {
            assetModelHierarchies(Stream.of(assetModelHierarchies)
                    .map(c -> AssetModelHierarchy.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<AssetModelCompositeModel.Builder> getAssetModelCompositeModels() {
            List<AssetModelCompositeModel.Builder> result = AssetModelCompositeModelsCopier
                    .copyToBuilder(this.assetModelCompositeModels);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAssetModelCompositeModels(Collection<AssetModelCompositeModel.BuilderImpl> assetModelCompositeModels) {
            this.assetModelCompositeModels = AssetModelCompositeModelsCopier.copyFromBuilder(assetModelCompositeModels);
        }

        @Override
        public final Builder assetModelCompositeModels(Collection<AssetModelCompositeModel> assetModelCompositeModels) {
            this.assetModelCompositeModels = AssetModelCompositeModelsCopier.copy(assetModelCompositeModels);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder assetModelCompositeModels(AssetModelCompositeModel... assetModelCompositeModels) {
            assetModelCompositeModels(Arrays.asList(assetModelCompositeModels));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder assetModelCompositeModels(Consumer<AssetModelCompositeModel.Builder>... assetModelCompositeModels) {
            assetModelCompositeModels(Stream.of(assetModelCompositeModels)
                    .map(c -> AssetModelCompositeModel.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<AssetModelCompositeModelSummary.Builder> getAssetModelCompositeModelSummaries() {
            List<AssetModelCompositeModelSummary.Builder> result = AssetModelCompositeModelSummariesCopier
                    .copyToBuilder(this.assetModelCompositeModelSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAssetModelCompositeModelSummaries(
                Collection<AssetModelCompositeModelSummary.BuilderImpl> assetModelCompositeModelSummaries) {
            this.assetModelCompositeModelSummaries = AssetModelCompositeModelSummariesCopier
                    .copyFromBuilder(assetModelCompositeModelSummaries);
        }

        @Override
        public final Builder assetModelCompositeModelSummaries(
                Collection<AssetModelCompositeModelSummary> assetModelCompositeModelSummaries) {
            this.assetModelCompositeModelSummaries = AssetModelCompositeModelSummariesCopier
                    .copy(assetModelCompositeModelSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder assetModelCompositeModelSummaries(
                AssetModelCompositeModelSummary... assetModelCompositeModelSummaries) {
            assetModelCompositeModelSummaries(Arrays.asList(assetModelCompositeModelSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder assetModelCompositeModelSummaries(
                Consumer<AssetModelCompositeModelSummary.Builder>... assetModelCompositeModelSummaries) {
            assetModelCompositeModelSummaries(Stream.of(assetModelCompositeModelSummaries)
                    .map(c -> AssetModelCompositeModelSummary.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final Instant getAssetModelCreationDate() {
            return assetModelCreationDate;
        }

        public final void setAssetModelCreationDate(Instant assetModelCreationDate) {
            this.assetModelCreationDate = assetModelCreationDate;
        }

        @Override
        public final Builder assetModelCreationDate(Instant assetModelCreationDate) {
            this.assetModelCreationDate = assetModelCreationDate;
            return this;
        }

        public final Instant getAssetModelLastUpdateDate() {
            return assetModelLastUpdateDate;
        }

        public final void setAssetModelLastUpdateDate(Instant assetModelLastUpdateDate) {
            this.assetModelLastUpdateDate = assetModelLastUpdateDate;
        }

        @Override
        public final Builder assetModelLastUpdateDate(Instant assetModelLastUpdateDate) {
            this.assetModelLastUpdateDate = assetModelLastUpdateDate;
            return this;
        }

        public final AssetModelStatus.Builder getAssetModelStatus() {
            return assetModelStatus != null ? assetModelStatus.toBuilder() : null;
        }

        public final void setAssetModelStatus(AssetModelStatus.BuilderImpl assetModelStatus) {
            this.assetModelStatus = assetModelStatus != null ? assetModelStatus.build() : null;
        }

        @Override
        public final Builder assetModelStatus(AssetModelStatus assetModelStatus) {
            this.assetModelStatus = assetModelStatus;
            return this;
        }

        public final String getAssetModelVersion() {
            return assetModelVersion;
        }

        public final void setAssetModelVersion(String assetModelVersion) {
            this.assetModelVersion = assetModelVersion;
        }

        @Override
        public final Builder assetModelVersion(String assetModelVersion) {
            this.assetModelVersion = assetModelVersion;
            return this;
        }

        public final List<InterfaceRelationship.Builder> getInterfaceDetails() {
            List<InterfaceRelationship.Builder> result = InterfaceDetailsCopier.copyToBuilder(this.interfaceDetails);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setInterfaceDetails(Collection<InterfaceRelationship.BuilderImpl> interfaceDetails) {
            this.interfaceDetails = InterfaceDetailsCopier.copyFromBuilder(interfaceDetails);
        }

        @Override
        public final Builder interfaceDetails(Collection<InterfaceRelationship> interfaceDetails) {
            this.interfaceDetails = InterfaceDetailsCopier.copy(interfaceDetails);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder interfaceDetails(InterfaceRelationship... interfaceDetails) {
            interfaceDetails(Arrays.asList(interfaceDetails));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder interfaceDetails(Consumer<InterfaceRelationship.Builder>... interfaceDetails) {
            interfaceDetails(Stream.of(interfaceDetails).map(c -> InterfaceRelationship.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getETag() {
            return eTag;
        }

        public final void setETag(String eTag) {
            this.eTag = eTag;
        }

        @Override
        public final Builder eTag(String eTag) {
            this.eTag = eTag;
            return this;
        }

        @Override
        public DescribeAssetModelResponse build() {
            return new DescribeAssetModelResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
