/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotsitewise.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeAssetModelInterfaceRelationshipResponse extends IoTSiteWiseResponse
        implements
        ToCopyableBuilder<DescribeAssetModelInterfaceRelationshipResponse.Builder, DescribeAssetModelInterfaceRelationshipResponse> {
    private static final SdkField<String> ASSET_MODEL_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("assetModelId").getter(getter(DescribeAssetModelInterfaceRelationshipResponse::assetModelId))
            .setter(setter(Builder::assetModelId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assetModelId").build()).build();

    private static final SdkField<String> INTERFACE_ASSET_MODEL_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("interfaceAssetModelId")
            .getter(getter(DescribeAssetModelInterfaceRelationshipResponse::interfaceAssetModelId))
            .setter(setter(Builder::interfaceAssetModelId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("interfaceAssetModelId").build())
            .build();

    private static final SdkField<List<PropertyMapping>> PROPERTY_MAPPINGS_FIELD = SdkField
            .<List<PropertyMapping>> builder(MarshallingType.LIST)
            .memberName("propertyMappings")
            .getter(getter(DescribeAssetModelInterfaceRelationshipResponse::propertyMappings))
            .setter(setter(Builder::propertyMappings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("propertyMappings").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<PropertyMapping> builder(MarshallingType.SDK_POJO)
                                            .constructor(PropertyMapping::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<HierarchyMapping>> HIERARCHY_MAPPINGS_FIELD = SdkField
            .<List<HierarchyMapping>> builder(MarshallingType.LIST)
            .memberName("hierarchyMappings")
            .getter(getter(DescribeAssetModelInterfaceRelationshipResponse::hierarchyMappings))
            .setter(setter(Builder::hierarchyMappings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("hierarchyMappings").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<HierarchyMapping> builder(MarshallingType.SDK_POJO)
                                            .constructor(HierarchyMapping::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSET_MODEL_ID_FIELD,
            INTERFACE_ASSET_MODEL_ID_FIELD, PROPERTY_MAPPINGS_FIELD, HIERARCHY_MAPPINGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String assetModelId;

    private final String interfaceAssetModelId;

    private final List<PropertyMapping> propertyMappings;

    private final List<HierarchyMapping> hierarchyMappings;

    private DescribeAssetModelInterfaceRelationshipResponse(BuilderImpl builder) {
        super(builder);
        this.assetModelId = builder.assetModelId;
        this.interfaceAssetModelId = builder.interfaceAssetModelId;
        this.propertyMappings = builder.propertyMappings;
        this.hierarchyMappings = builder.hierarchyMappings;
    }

    /**
     * <p>
     * The ID of the asset model.
     * </p>
     * 
     * @return The ID of the asset model.
     */
    public final String assetModelId() {
        return assetModelId;
    }

    /**
     * <p>
     * The ID of the interface asset model.
     * </p>
     * 
     * @return The ID of the interface asset model.
     */
    public final String interfaceAssetModelId() {
        return interfaceAssetModelId;
    }

    /**
     * For responses, this returns true if the service returned a value for the PropertyMappings property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasPropertyMappings() {
        return propertyMappings != null && !(propertyMappings instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of property mappings between the interface asset model and the asset model where the interface is applied.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPropertyMappings} method.
     * </p>
     * 
     * @return A list of property mappings between the interface asset model and the asset model where the interface is
     *         applied.
     */
    public final List<PropertyMapping> propertyMappings() {
        return propertyMappings;
    }

    /**
     * For responses, this returns true if the service returned a value for the HierarchyMappings property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasHierarchyMappings() {
        return hierarchyMappings != null && !(hierarchyMappings instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of hierarchy mappings between the interface asset model and the asset model where the interface is
     * applied.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasHierarchyMappings} method.
     * </p>
     * 
     * @return A list of hierarchy mappings between the interface asset model and the asset model where the interface is
     *         applied.
     */
    public final List<HierarchyMapping> hierarchyMappings() {
        return hierarchyMappings;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(assetModelId());
        hashCode = 31 * hashCode + Objects.hashCode(interfaceAssetModelId());
        hashCode = 31 * hashCode + Objects.hashCode(hasPropertyMappings() ? propertyMappings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasHierarchyMappings() ? hierarchyMappings() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeAssetModelInterfaceRelationshipResponse)) {
            return false;
        }
        DescribeAssetModelInterfaceRelationshipResponse other = (DescribeAssetModelInterfaceRelationshipResponse) obj;
        return Objects.equals(assetModelId(), other.assetModelId())
                && Objects.equals(interfaceAssetModelId(), other.interfaceAssetModelId())
                && hasPropertyMappings() == other.hasPropertyMappings()
                && Objects.equals(propertyMappings(), other.propertyMappings())
                && hasHierarchyMappings() == other.hasHierarchyMappings()
                && Objects.equals(hierarchyMappings(), other.hierarchyMappings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeAssetModelInterfaceRelationshipResponse").add("AssetModelId", assetModelId())
                .add("InterfaceAssetModelId", interfaceAssetModelId())
                .add("PropertyMappings", hasPropertyMappings() ? propertyMappings() : null)
                .add("HierarchyMappings", hasHierarchyMappings() ? hierarchyMappings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "assetModelId":
            return Optional.ofNullable(clazz.cast(assetModelId()));
        case "interfaceAssetModelId":
            return Optional.ofNullable(clazz.cast(interfaceAssetModelId()));
        case "propertyMappings":
            return Optional.ofNullable(clazz.cast(propertyMappings()));
        case "hierarchyMappings":
            return Optional.ofNullable(clazz.cast(hierarchyMappings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("assetModelId", ASSET_MODEL_ID_FIELD);
        map.put("interfaceAssetModelId", INTERFACE_ASSET_MODEL_ID_FIELD);
        map.put("propertyMappings", PROPERTY_MAPPINGS_FIELD);
        map.put("hierarchyMappings", HIERARCHY_MAPPINGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeAssetModelInterfaceRelationshipResponse, T> g) {
        return obj -> g.apply((DescribeAssetModelInterfaceRelationshipResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends IoTSiteWiseResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeAssetModelInterfaceRelationshipResponse> {
        /**
         * <p>
         * The ID of the asset model.
         * </p>
         * 
         * @param assetModelId
         *        The ID of the asset model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assetModelId(String assetModelId);

        /**
         * <p>
         * The ID of the interface asset model.
         * </p>
         * 
         * @param interfaceAssetModelId
         *        The ID of the interface asset model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder interfaceAssetModelId(String interfaceAssetModelId);

        /**
         * <p>
         * A list of property mappings between the interface asset model and the asset model where the interface is
         * applied.
         * </p>
         * 
         * @param propertyMappings
         *        A list of property mappings between the interface asset model and the asset model where the interface
         *        is applied.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder propertyMappings(Collection<PropertyMapping> propertyMappings);

        /**
         * <p>
         * A list of property mappings between the interface asset model and the asset model where the interface is
         * applied.
         * </p>
         * 
         * @param propertyMappings
         *        A list of property mappings between the interface asset model and the asset model where the interface
         *        is applied.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder propertyMappings(PropertyMapping... propertyMappings);

        /**
         * <p>
         * A list of property mappings between the interface asset model and the asset model where the interface is
         * applied.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.iotsitewise.model.PropertyMapping.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.iotsitewise.model.PropertyMapping#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.iotsitewise.model.PropertyMapping.Builder#build()} is called
         * immediately and its result is passed to {@link #propertyMappings(List<PropertyMapping>)}.
         * 
         * @param propertyMappings
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.iotsitewise.model.PropertyMapping.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #propertyMappings(java.util.Collection<PropertyMapping>)
         */
        Builder propertyMappings(Consumer<PropertyMapping.Builder>... propertyMappings);

        /**
         * <p>
         * A list of hierarchy mappings between the interface asset model and the asset model where the interface is
         * applied.
         * </p>
         * 
         * @param hierarchyMappings
         *        A list of hierarchy mappings between the interface asset model and the asset model where the interface
         *        is applied.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hierarchyMappings(Collection<HierarchyMapping> hierarchyMappings);

        /**
         * <p>
         * A list of hierarchy mappings between the interface asset model and the asset model where the interface is
         * applied.
         * </p>
         * 
         * @param hierarchyMappings
         *        A list of hierarchy mappings between the interface asset model and the asset model where the interface
         *        is applied.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hierarchyMappings(HierarchyMapping... hierarchyMappings);

        /**
         * <p>
         * A list of hierarchy mappings between the interface asset model and the asset model where the interface is
         * applied.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.iotsitewise.model.HierarchyMapping.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.iotsitewise.model.HierarchyMapping#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.iotsitewise.model.HierarchyMapping.Builder#build()} is called
         * immediately and its result is passed to {@link #hierarchyMappings(List<HierarchyMapping>)}.
         * 
         * @param hierarchyMappings
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.iotsitewise.model.HierarchyMapping.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #hierarchyMappings(java.util.Collection<HierarchyMapping>)
         */
        Builder hierarchyMappings(Consumer<HierarchyMapping.Builder>... hierarchyMappings);
    }

    static final class BuilderImpl extends IoTSiteWiseResponse.BuilderImpl implements Builder {
        private String assetModelId;

        private String interfaceAssetModelId;

        private List<PropertyMapping> propertyMappings = DefaultSdkAutoConstructList.getInstance();

        private List<HierarchyMapping> hierarchyMappings = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeAssetModelInterfaceRelationshipResponse model) {
            super(model);
            assetModelId(model.assetModelId);
            interfaceAssetModelId(model.interfaceAssetModelId);
            propertyMappings(model.propertyMappings);
            hierarchyMappings(model.hierarchyMappings);
        }

        public final String getAssetModelId() {
            return assetModelId;
        }

        public final void setAssetModelId(String assetModelId) {
            this.assetModelId = assetModelId;
        }

        @Override
        public final Builder assetModelId(String assetModelId) {
            this.assetModelId = assetModelId;
            return this;
        }

        public final String getInterfaceAssetModelId() {
            return interfaceAssetModelId;
        }

        public final void setInterfaceAssetModelId(String interfaceAssetModelId) {
            this.interfaceAssetModelId = interfaceAssetModelId;
        }

        @Override
        public final Builder interfaceAssetModelId(String interfaceAssetModelId) {
            this.interfaceAssetModelId = interfaceAssetModelId;
            return this;
        }

        public final List<PropertyMapping.Builder> getPropertyMappings() {
            List<PropertyMapping.Builder> result = PropertyMappingsCopier.copyToBuilder(this.propertyMappings);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPropertyMappings(Collection<PropertyMapping.BuilderImpl> propertyMappings) {
            this.propertyMappings = PropertyMappingsCopier.copyFromBuilder(propertyMappings);
        }

        @Override
        public final Builder propertyMappings(Collection<PropertyMapping> propertyMappings) {
            this.propertyMappings = PropertyMappingsCopier.copy(propertyMappings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder propertyMappings(PropertyMapping... propertyMappings) {
            propertyMappings(Arrays.asList(propertyMappings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder propertyMappings(Consumer<PropertyMapping.Builder>... propertyMappings) {
            propertyMappings(Stream.of(propertyMappings).map(c -> PropertyMapping.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<HierarchyMapping.Builder> getHierarchyMappings() {
            List<HierarchyMapping.Builder> result = HierarchyMappingsCopier.copyToBuilder(this.hierarchyMappings);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setHierarchyMappings(Collection<HierarchyMapping.BuilderImpl> hierarchyMappings) {
            this.hierarchyMappings = HierarchyMappingsCopier.copyFromBuilder(hierarchyMappings);
        }

        @Override
        public final Builder hierarchyMappings(Collection<HierarchyMapping> hierarchyMappings) {
            this.hierarchyMappings = HierarchyMappingsCopier.copy(hierarchyMappings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder hierarchyMappings(HierarchyMapping... hierarchyMappings) {
            hierarchyMappings(Arrays.asList(hierarchyMappings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder hierarchyMappings(Consumer<HierarchyMapping.Builder>... hierarchyMappings) {
            hierarchyMappings(Stream.of(hierarchyMappings).map(c -> HierarchyMapping.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public DescribeAssetModelInterfaceRelationshipResponse build() {
            return new DescribeAssetModelInterfaceRelationshipResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
