/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotsitewise.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteAssetModelInterfaceRelationshipResponse extends IoTSiteWiseResponse implements
        ToCopyableBuilder<DeleteAssetModelInterfaceRelationshipResponse.Builder, DeleteAssetModelInterfaceRelationshipResponse> {
    private static final SdkField<String> ASSET_MODEL_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("assetModelId").getter(getter(DeleteAssetModelInterfaceRelationshipResponse::assetModelId))
            .setter(setter(Builder::assetModelId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assetModelId").build()).build();

    private static final SdkField<String> INTERFACE_ASSET_MODEL_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("interfaceAssetModelId")
            .getter(getter(DeleteAssetModelInterfaceRelationshipResponse::interfaceAssetModelId))
            .setter(setter(Builder::interfaceAssetModelId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("interfaceAssetModelId").build())
            .build();

    private static final SdkField<String> ASSET_MODEL_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("assetModelArn").getter(getter(DeleteAssetModelInterfaceRelationshipResponse::assetModelArn))
            .setter(setter(Builder::assetModelArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assetModelArn").build()).build();

    private static final SdkField<AssetModelStatus> ASSET_MODEL_STATUS_FIELD = SdkField
            .<AssetModelStatus> builder(MarshallingType.SDK_POJO).memberName("assetModelStatus")
            .getter(getter(DeleteAssetModelInterfaceRelationshipResponse::assetModelStatus))
            .setter(setter(Builder::assetModelStatus)).constructor(AssetModelStatus::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assetModelStatus").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSET_MODEL_ID_FIELD,
            INTERFACE_ASSET_MODEL_ID_FIELD, ASSET_MODEL_ARN_FIELD, ASSET_MODEL_STATUS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String assetModelId;

    private final String interfaceAssetModelId;

    private final String assetModelArn;

    private final AssetModelStatus assetModelStatus;

    private DeleteAssetModelInterfaceRelationshipResponse(BuilderImpl builder) {
        super(builder);
        this.assetModelId = builder.assetModelId;
        this.interfaceAssetModelId = builder.interfaceAssetModelId;
        this.assetModelArn = builder.assetModelArn;
        this.assetModelStatus = builder.assetModelStatus;
    }

    /**
     * <p>
     * The ID of the asset model.
     * </p>
     * 
     * @return The ID of the asset model.
     */
    public final String assetModelId() {
        return assetModelId;
    }

    /**
     * <p>
     * The ID of the interface asset model.
     * </p>
     * 
     * @return The ID of the interface asset model.
     */
    public final String interfaceAssetModelId() {
        return interfaceAssetModelId;
    }

    /**
     * <p>
     * The ARN of the asset model, which has the following format.
     * <code>arn:${Partition}:iotsitewise:${Region}:${Account}:asset-model/${AssetModelId}</code>
     * </p>
     * 
     * @return The ARN of the asset model, which has the following format.
     *         <code>arn:${Partition}:iotsitewise:${Region}:${Account}:asset-model/${AssetModelId}</code>
     */
    public final String assetModelArn() {
        return assetModelArn;
    }

    /**
     * Returns the value of the AssetModelStatus property for this object.
     * 
     * @return The value of the AssetModelStatus property for this object.
     */
    public final AssetModelStatus assetModelStatus() {
        return assetModelStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(assetModelId());
        hashCode = 31 * hashCode + Objects.hashCode(interfaceAssetModelId());
        hashCode = 31 * hashCode + Objects.hashCode(assetModelArn());
        hashCode = 31 * hashCode + Objects.hashCode(assetModelStatus());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteAssetModelInterfaceRelationshipResponse)) {
            return false;
        }
        DeleteAssetModelInterfaceRelationshipResponse other = (DeleteAssetModelInterfaceRelationshipResponse) obj;
        return Objects.equals(assetModelId(), other.assetModelId())
                && Objects.equals(interfaceAssetModelId(), other.interfaceAssetModelId())
                && Objects.equals(assetModelArn(), other.assetModelArn())
                && Objects.equals(assetModelStatus(), other.assetModelStatus());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeleteAssetModelInterfaceRelationshipResponse").add("AssetModelId", assetModelId())
                .add("InterfaceAssetModelId", interfaceAssetModelId()).add("AssetModelArn", assetModelArn())
                .add("AssetModelStatus", assetModelStatus()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "assetModelId":
            return Optional.ofNullable(clazz.cast(assetModelId()));
        case "interfaceAssetModelId":
            return Optional.ofNullable(clazz.cast(interfaceAssetModelId()));
        case "assetModelArn":
            return Optional.ofNullable(clazz.cast(assetModelArn()));
        case "assetModelStatus":
            return Optional.ofNullable(clazz.cast(assetModelStatus()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("assetModelId", ASSET_MODEL_ID_FIELD);
        map.put("interfaceAssetModelId", INTERFACE_ASSET_MODEL_ID_FIELD);
        map.put("assetModelArn", ASSET_MODEL_ARN_FIELD);
        map.put("assetModelStatus", ASSET_MODEL_STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DeleteAssetModelInterfaceRelationshipResponse, T> g) {
        return obj -> g.apply((DeleteAssetModelInterfaceRelationshipResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends IoTSiteWiseResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DeleteAssetModelInterfaceRelationshipResponse> {
        /**
         * <p>
         * The ID of the asset model.
         * </p>
         * 
         * @param assetModelId
         *        The ID of the asset model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assetModelId(String assetModelId);

        /**
         * <p>
         * The ID of the interface asset model.
         * </p>
         * 
         * @param interfaceAssetModelId
         *        The ID of the interface asset model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder interfaceAssetModelId(String interfaceAssetModelId);

        /**
         * <p>
         * The ARN of the asset model, which has the following format.
         * <code>arn:${Partition}:iotsitewise:${Region}:${Account}:asset-model/${AssetModelId}</code>
         * </p>
         * 
         * @param assetModelArn
         *        The ARN of the asset model, which has the following format.
         *        <code>arn:${Partition}:iotsitewise:${Region}:${Account}:asset-model/${AssetModelId}</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assetModelArn(String assetModelArn);

        /**
         * Sets the value of the AssetModelStatus property for this object.
         *
         * @param assetModelStatus
         *        The new value for the AssetModelStatus property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assetModelStatus(AssetModelStatus assetModelStatus);

        /**
         * Sets the value of the AssetModelStatus property for this object.
         *
         * This is a convenience method that creates an instance of the {@link AssetModelStatus.Builder} avoiding the
         * need to create one manually via {@link AssetModelStatus#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AssetModelStatus.Builder#build()} is called immediately and its
         * result is passed to {@link #assetModelStatus(AssetModelStatus)}.
         * 
         * @param assetModelStatus
         *        a consumer that will call methods on {@link AssetModelStatus.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #assetModelStatus(AssetModelStatus)
         */
        default Builder assetModelStatus(Consumer<AssetModelStatus.Builder> assetModelStatus) {
            return assetModelStatus(AssetModelStatus.builder().applyMutation(assetModelStatus).build());
        }
    }

    static final class BuilderImpl extends IoTSiteWiseResponse.BuilderImpl implements Builder {
        private String assetModelId;

        private String interfaceAssetModelId;

        private String assetModelArn;

        private AssetModelStatus assetModelStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteAssetModelInterfaceRelationshipResponse model) {
            super(model);
            assetModelId(model.assetModelId);
            interfaceAssetModelId(model.interfaceAssetModelId);
            assetModelArn(model.assetModelArn);
            assetModelStatus(model.assetModelStatus);
        }

        public final String getAssetModelId() {
            return assetModelId;
        }

        public final void setAssetModelId(String assetModelId) {
            this.assetModelId = assetModelId;
        }

        @Override
        public final Builder assetModelId(String assetModelId) {
            this.assetModelId = assetModelId;
            return this;
        }

        public final String getInterfaceAssetModelId() {
            return interfaceAssetModelId;
        }

        public final void setInterfaceAssetModelId(String interfaceAssetModelId) {
            this.interfaceAssetModelId = interfaceAssetModelId;
        }

        @Override
        public final Builder interfaceAssetModelId(String interfaceAssetModelId) {
            this.interfaceAssetModelId = interfaceAssetModelId;
            return this;
        }

        public final String getAssetModelArn() {
            return assetModelArn;
        }

        public final void setAssetModelArn(String assetModelArn) {
            this.assetModelArn = assetModelArn;
        }

        @Override
        public final Builder assetModelArn(String assetModelArn) {
            this.assetModelArn = assetModelArn;
            return this;
        }

        public final AssetModelStatus.Builder getAssetModelStatus() {
            return assetModelStatus != null ? assetModelStatus.toBuilder() : null;
        }

        public final void setAssetModelStatus(AssetModelStatus.BuilderImpl assetModelStatus) {
            this.assetModelStatus = assetModelStatus != null ? assetModelStatus.build() : null;
        }

        @Override
        public final Builder assetModelStatus(AssetModelStatus assetModelStatus) {
            this.assetModelStatus = assetModelStatus;
            return this;
        }

        @Override
        public DeleteAssetModelInterfaceRelationshipResponse build() {
            return new DeleteAssetModelInterfaceRelationshipResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
