/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotsitewise.model;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;

@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
final class DefaultInvokeAssistantVisitorBuilder implements InvokeAssistantResponseHandler.Visitor.Builder {
    private Consumer<ResponseStream> onDefault;

    private Consumer<Trace> onTrace;

    private Consumer<InvocationOutput> onOutput;

    @Override
    public InvokeAssistantResponseHandler.Visitor.Builder onDefault(Consumer<ResponseStream> c) {
        this.onDefault = c;
        return this;
    }

    @Override
    public InvokeAssistantResponseHandler.Visitor build() {
        return new VisitorFromBuilder(this);
    }

    @Override
    public InvokeAssistantResponseHandler.Visitor.Builder onTrace(Consumer<Trace> c) {
        this.onTrace = c;
        return this;
    }

    @Override
    public InvokeAssistantResponseHandler.Visitor.Builder onOutput(Consumer<InvocationOutput> c) {
        this.onOutput = c;
        return this;
    }

    @Generated("software.amazon.awssdk:codegen")
    static class VisitorFromBuilder implements InvokeAssistantResponseHandler.Visitor {
        private final Consumer<ResponseStream> onDefault;

        private final Consumer<Trace> onTrace;

        private final Consumer<InvocationOutput> onOutput;

        VisitorFromBuilder(DefaultInvokeAssistantVisitorBuilder builder) {
            this.onDefault = builder.onDefault != null ? builder.onDefault
                    : InvokeAssistantResponseHandler.Visitor.super::visitDefault;
            this.onTrace = builder.onTrace != null ? builder.onTrace : InvokeAssistantResponseHandler.Visitor.super::visitTrace;
            this.onOutput = builder.onOutput != null ? builder.onOutput
                    : InvokeAssistantResponseHandler.Visitor.super::visitOutput;
        }

        @Override
        public void visitDefault(ResponseStream event) {
            onDefault.accept(event);
        }

        @Override
        public void visitTrace(Trace event) {
            onTrace.accept(event);
        }

        @Override
        public void visitOutput(InvocationOutput event) {
            onOutput.accept(event);
        }
    }
}
