/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotsitewise.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A filter used to match specific data binding values based on criteria. This filter allows searching for data bindings
 * by asset, asset model, asset property, or asset model property.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DataBindingValueFilter implements SdkPojo, Serializable,
        ToCopyableBuilder<DataBindingValueFilter.Builder, DataBindingValueFilter> {
    private static final SdkField<AssetBindingValueFilter> ASSET_FIELD = SdkField
            .<AssetBindingValueFilter> builder(MarshallingType.SDK_POJO).memberName("asset")
            .getter(getter(DataBindingValueFilter::asset)).setter(setter(Builder::asset))
            .constructor(AssetBindingValueFilter::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("asset").build()).build();

    private static final SdkField<AssetModelBindingValueFilter> ASSET_MODEL_FIELD = SdkField
            .<AssetModelBindingValueFilter> builder(MarshallingType.SDK_POJO).memberName("assetModel")
            .getter(getter(DataBindingValueFilter::assetModel)).setter(setter(Builder::assetModel))
            .constructor(AssetModelBindingValueFilter::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assetModel").build()).build();

    private static final SdkField<AssetPropertyBindingValueFilter> ASSET_PROPERTY_FIELD = SdkField
            .<AssetPropertyBindingValueFilter> builder(MarshallingType.SDK_POJO).memberName("assetProperty")
            .getter(getter(DataBindingValueFilter::assetProperty)).setter(setter(Builder::assetProperty))
            .constructor(AssetPropertyBindingValueFilter::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assetProperty").build()).build();

    private static final SdkField<AssetModelPropertyBindingValueFilter> ASSET_MODEL_PROPERTY_FIELD = SdkField
            .<AssetModelPropertyBindingValueFilter> builder(MarshallingType.SDK_POJO).memberName("assetModelProperty")
            .getter(getter(DataBindingValueFilter::assetModelProperty)).setter(setter(Builder::assetModelProperty))
            .constructor(AssetModelPropertyBindingValueFilter::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assetModelProperty").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSET_FIELD,
            ASSET_MODEL_FIELD, ASSET_PROPERTY_FIELD, ASSET_MODEL_PROPERTY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final AssetBindingValueFilter asset;

    private final AssetModelBindingValueFilter assetModel;

    private final AssetPropertyBindingValueFilter assetProperty;

    private final AssetModelPropertyBindingValueFilter assetModelProperty;

    private DataBindingValueFilter(BuilderImpl builder) {
        this.asset = builder.asset;
        this.assetModel = builder.assetModel;
        this.assetProperty = builder.assetProperty;
        this.assetModelProperty = builder.assetModelProperty;
    }

    /**
     * <p>
     * Filter criteria for matching data bindings based on a specific asset. Used to list all data bindings referencing
     * a particular asset or its properties.
     * </p>
     * 
     * @return Filter criteria for matching data bindings based on a specific asset. Used to list all data bindings
     *         referencing a particular asset or its properties.
     */
    public final AssetBindingValueFilter asset() {
        return asset;
    }

    /**
     * <p>
     * Filter criteria for matching data bindings based on a specific asset model. Used to list all data bindings
     * referencing a particular asset model or its properties.
     * </p>
     * 
     * @return Filter criteria for matching data bindings based on a specific asset model. Used to list all data
     *         bindings referencing a particular asset model or its properties.
     */
    public final AssetModelBindingValueFilter assetModel() {
        return assetModel;
    }

    /**
     * <p>
     * Filter criteria for matching data bindings based on a specific asset property. Used to list all data bindings
     * referencing a particular property of an asset.
     * </p>
     * 
     * @return Filter criteria for matching data bindings based on a specific asset property. Used to list all data
     *         bindings referencing a particular property of an asset.
     */
    public final AssetPropertyBindingValueFilter assetProperty() {
        return assetProperty;
    }

    /**
     * <p>
     * Filter criteria for matching data bindings based on a specific asset model property. Used to list all data
     * bindings referencing a particular property of an asset model.
     * </p>
     * 
     * @return Filter criteria for matching data bindings based on a specific asset model property. Used to list all
     *         data bindings referencing a particular property of an asset model.
     */
    public final AssetModelPropertyBindingValueFilter assetModelProperty() {
        return assetModelProperty;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(asset());
        hashCode = 31 * hashCode + Objects.hashCode(assetModel());
        hashCode = 31 * hashCode + Objects.hashCode(assetProperty());
        hashCode = 31 * hashCode + Objects.hashCode(assetModelProperty());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataBindingValueFilter)) {
            return false;
        }
        DataBindingValueFilter other = (DataBindingValueFilter) obj;
        return Objects.equals(asset(), other.asset()) && Objects.equals(assetModel(), other.assetModel())
                && Objects.equals(assetProperty(), other.assetProperty())
                && Objects.equals(assetModelProperty(), other.assetModelProperty());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DataBindingValueFilter").add("Asset", asset()).add("AssetModel", assetModel())
                .add("AssetProperty", assetProperty()).add("AssetModelProperty", assetModelProperty()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "asset":
            return Optional.ofNullable(clazz.cast(asset()));
        case "assetModel":
            return Optional.ofNullable(clazz.cast(assetModel()));
        case "assetProperty":
            return Optional.ofNullable(clazz.cast(assetProperty()));
        case "assetModelProperty":
            return Optional.ofNullable(clazz.cast(assetModelProperty()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("asset", ASSET_FIELD);
        map.put("assetModel", ASSET_MODEL_FIELD);
        map.put("assetProperty", ASSET_PROPERTY_FIELD);
        map.put("assetModelProperty", ASSET_MODEL_PROPERTY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DataBindingValueFilter, T> g) {
        return obj -> g.apply((DataBindingValueFilter) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DataBindingValueFilter> {
        /**
         * <p>
         * Filter criteria for matching data bindings based on a specific asset. Used to list all data bindings
         * referencing a particular asset or its properties.
         * </p>
         * 
         * @param asset
         *        Filter criteria for matching data bindings based on a specific asset. Used to list all data bindings
         *        referencing a particular asset or its properties.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder asset(AssetBindingValueFilter asset);

        /**
         * <p>
         * Filter criteria for matching data bindings based on a specific asset. Used to list all data bindings
         * referencing a particular asset or its properties.
         * </p>
         * This is a convenience method that creates an instance of the {@link AssetBindingValueFilter.Builder} avoiding
         * the need to create one manually via {@link AssetBindingValueFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AssetBindingValueFilter.Builder#build()} is called immediately
         * and its result is passed to {@link #asset(AssetBindingValueFilter)}.
         * 
         * @param asset
         *        a consumer that will call methods on {@link AssetBindingValueFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #asset(AssetBindingValueFilter)
         */
        default Builder asset(Consumer<AssetBindingValueFilter.Builder> asset) {
            return asset(AssetBindingValueFilter.builder().applyMutation(asset).build());
        }

        /**
         * <p>
         * Filter criteria for matching data bindings based on a specific asset model. Used to list all data bindings
         * referencing a particular asset model or its properties.
         * </p>
         * 
         * @param assetModel
         *        Filter criteria for matching data bindings based on a specific asset model. Used to list all data
         *        bindings referencing a particular asset model or its properties.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assetModel(AssetModelBindingValueFilter assetModel);

        /**
         * <p>
         * Filter criteria for matching data bindings based on a specific asset model. Used to list all data bindings
         * referencing a particular asset model or its properties.
         * </p>
         * This is a convenience method that creates an instance of the {@link AssetModelBindingValueFilter.Builder}
         * avoiding the need to create one manually via {@link AssetModelBindingValueFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AssetModelBindingValueFilter.Builder#build()} is called
         * immediately and its result is passed to {@link #assetModel(AssetModelBindingValueFilter)}.
         * 
         * @param assetModel
         *        a consumer that will call methods on {@link AssetModelBindingValueFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #assetModel(AssetModelBindingValueFilter)
         */
        default Builder assetModel(Consumer<AssetModelBindingValueFilter.Builder> assetModel) {
            return assetModel(AssetModelBindingValueFilter.builder().applyMutation(assetModel).build());
        }

        /**
         * <p>
         * Filter criteria for matching data bindings based on a specific asset property. Used to list all data bindings
         * referencing a particular property of an asset.
         * </p>
         * 
         * @param assetProperty
         *        Filter criteria for matching data bindings based on a specific asset property. Used to list all data
         *        bindings referencing a particular property of an asset.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assetProperty(AssetPropertyBindingValueFilter assetProperty);

        /**
         * <p>
         * Filter criteria for matching data bindings based on a specific asset property. Used to list all data bindings
         * referencing a particular property of an asset.
         * </p>
         * This is a convenience method that creates an instance of the {@link AssetPropertyBindingValueFilter.Builder}
         * avoiding the need to create one manually via {@link AssetPropertyBindingValueFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AssetPropertyBindingValueFilter.Builder#build()} is called
         * immediately and its result is passed to {@link #assetProperty(AssetPropertyBindingValueFilter)}.
         * 
         * @param assetProperty
         *        a consumer that will call methods on {@link AssetPropertyBindingValueFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #assetProperty(AssetPropertyBindingValueFilter)
         */
        default Builder assetProperty(Consumer<AssetPropertyBindingValueFilter.Builder> assetProperty) {
            return assetProperty(AssetPropertyBindingValueFilter.builder().applyMutation(assetProperty).build());
        }

        /**
         * <p>
         * Filter criteria for matching data bindings based on a specific asset model property. Used to list all data
         * bindings referencing a particular property of an asset model.
         * </p>
         * 
         * @param assetModelProperty
         *        Filter criteria for matching data bindings based on a specific asset model property. Used to list all
         *        data bindings referencing a particular property of an asset model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assetModelProperty(AssetModelPropertyBindingValueFilter assetModelProperty);

        /**
         * <p>
         * Filter criteria for matching data bindings based on a specific asset model property. Used to list all data
         * bindings referencing a particular property of an asset model.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link AssetModelPropertyBindingValueFilter.Builder} avoiding the need to create one manually via
         * {@link AssetModelPropertyBindingValueFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AssetModelPropertyBindingValueFilter.Builder#build()} is called
         * immediately and its result is passed to {@link #assetModelProperty(AssetModelPropertyBindingValueFilter)}.
         * 
         * @param assetModelProperty
         *        a consumer that will call methods on {@link AssetModelPropertyBindingValueFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #assetModelProperty(AssetModelPropertyBindingValueFilter)
         */
        default Builder assetModelProperty(Consumer<AssetModelPropertyBindingValueFilter.Builder> assetModelProperty) {
            return assetModelProperty(AssetModelPropertyBindingValueFilter.builder().applyMutation(assetModelProperty).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private AssetBindingValueFilter asset;

        private AssetModelBindingValueFilter assetModel;

        private AssetPropertyBindingValueFilter assetProperty;

        private AssetModelPropertyBindingValueFilter assetModelProperty;

        private BuilderImpl() {
        }

        private BuilderImpl(DataBindingValueFilter model) {
            asset(model.asset);
            assetModel(model.assetModel);
            assetProperty(model.assetProperty);
            assetModelProperty(model.assetModelProperty);
        }

        public final AssetBindingValueFilter.Builder getAsset() {
            return asset != null ? asset.toBuilder() : null;
        }

        public final void setAsset(AssetBindingValueFilter.BuilderImpl asset) {
            this.asset = asset != null ? asset.build() : null;
        }

        @Override
        public final Builder asset(AssetBindingValueFilter asset) {
            this.asset = asset;
            return this;
        }

        public final AssetModelBindingValueFilter.Builder getAssetModel() {
            return assetModel != null ? assetModel.toBuilder() : null;
        }

        public final void setAssetModel(AssetModelBindingValueFilter.BuilderImpl assetModel) {
            this.assetModel = assetModel != null ? assetModel.build() : null;
        }

        @Override
        public final Builder assetModel(AssetModelBindingValueFilter assetModel) {
            this.assetModel = assetModel;
            return this;
        }

        public final AssetPropertyBindingValueFilter.Builder getAssetProperty() {
            return assetProperty != null ? assetProperty.toBuilder() : null;
        }

        public final void setAssetProperty(AssetPropertyBindingValueFilter.BuilderImpl assetProperty) {
            this.assetProperty = assetProperty != null ? assetProperty.build() : null;
        }

        @Override
        public final Builder assetProperty(AssetPropertyBindingValueFilter assetProperty) {
            this.assetProperty = assetProperty;
            return this;
        }

        public final AssetModelPropertyBindingValueFilter.Builder getAssetModelProperty() {
            return assetModelProperty != null ? assetModelProperty.toBuilder() : null;
        }

        public final void setAssetModelProperty(AssetModelPropertyBindingValueFilter.BuilderImpl assetModelProperty) {
            this.assetModelProperty = assetModelProperty != null ? assetModelProperty.build() : null;
        }

        @Override
        public final Builder assetModelProperty(AssetModelPropertyBindingValueFilter assetModelProperty) {
            this.assetModelProperty = assetModelProperty;
            return this;
        }

        @Override
        public DataBindingValueFilter build() {
            return new DataBindingValueFilter(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
