/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotsitewise.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateComputationModelResponse extends IoTSiteWiseResponse implements
        ToCopyableBuilder<CreateComputationModelResponse.Builder, CreateComputationModelResponse> {
    private static final SdkField<String> COMPUTATION_MODEL_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("computationModelId").getter(getter(CreateComputationModelResponse::computationModelId))
            .setter(setter(Builder::computationModelId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("computationModelId").build())
            .build();

    private static final SdkField<String> COMPUTATION_MODEL_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("computationModelArn").getter(getter(CreateComputationModelResponse::computationModelArn))
            .setter(setter(Builder::computationModelArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("computationModelArn").build())
            .build();

    private static final SdkField<ComputationModelStatus> COMPUTATION_MODEL_STATUS_FIELD = SdkField
            .<ComputationModelStatus> builder(MarshallingType.SDK_POJO).memberName("computationModelStatus")
            .getter(getter(CreateComputationModelResponse::computationModelStatus))
            .setter(setter(Builder::computationModelStatus)).constructor(ComputationModelStatus::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("computationModelStatus").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMPUTATION_MODEL_ID_FIELD,
            COMPUTATION_MODEL_ARN_FIELD, COMPUTATION_MODEL_STATUS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String computationModelId;

    private final String computationModelArn;

    private final ComputationModelStatus computationModelStatus;

    private CreateComputationModelResponse(BuilderImpl builder) {
        super(builder);
        this.computationModelId = builder.computationModelId;
        this.computationModelArn = builder.computationModelArn;
        this.computationModelStatus = builder.computationModelStatus;
    }

    /**
     * <p>
     * The ID of the computation model.
     * </p>
     * 
     * @return The ID of the computation model.
     */
    public final String computationModelId() {
        return computationModelId;
    }

    /**
     * <p>
     * The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the
     * computation model, which has the following format.
     * </p>
     * <p>
     * <code>arn:${Partition}:iotsitewise:${Region}:${Account}:computation-model/${ComputationModelId}</code>
     * </p>
     * 
     * @return The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the
     *         computation model, which has the following format.</p>
     *         <p>
     *         <code>arn:${Partition}:iotsitewise:${Region}:${Account}:computation-model/${ComputationModelId}</code>
     */
    public final String computationModelArn() {
        return computationModelArn;
    }

    /**
     * <p>
     * The status of the computation model, containing a state (CREATING after successfully calling this operation) and
     * any error messages.
     * </p>
     * 
     * @return The status of the computation model, containing a state (CREATING after successfully calling this
     *         operation) and any error messages.
     */
    public final ComputationModelStatus computationModelStatus() {
        return computationModelStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(computationModelId());
        hashCode = 31 * hashCode + Objects.hashCode(computationModelArn());
        hashCode = 31 * hashCode + Objects.hashCode(computationModelStatus());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateComputationModelResponse)) {
            return false;
        }
        CreateComputationModelResponse other = (CreateComputationModelResponse) obj;
        return Objects.equals(computationModelId(), other.computationModelId())
                && Objects.equals(computationModelArn(), other.computationModelArn())
                && Objects.equals(computationModelStatus(), other.computationModelStatus());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateComputationModelResponse").add("ComputationModelId", computationModelId())
                .add("ComputationModelArn", computationModelArn()).add("ComputationModelStatus", computationModelStatus())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "computationModelId":
            return Optional.ofNullable(clazz.cast(computationModelId()));
        case "computationModelArn":
            return Optional.ofNullable(clazz.cast(computationModelArn()));
        case "computationModelStatus":
            return Optional.ofNullable(clazz.cast(computationModelStatus()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("computationModelId", COMPUTATION_MODEL_ID_FIELD);
        map.put("computationModelArn", COMPUTATION_MODEL_ARN_FIELD);
        map.put("computationModelStatus", COMPUTATION_MODEL_STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateComputationModelResponse, T> g) {
        return obj -> g.apply((CreateComputationModelResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends IoTSiteWiseResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateComputationModelResponse> {
        /**
         * <p>
         * The ID of the computation model.
         * </p>
         * 
         * @param computationModelId
         *        The ID of the computation model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder computationModelId(String computationModelId);

        /**
         * <p>
         * The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the
         * computation model, which has the following format.
         * </p>
         * <p>
         * <code>arn:${Partition}:iotsitewise:${Region}:${Account}:computation-model/${ComputationModelId}</code>
         * </p>
         * 
         * @param computationModelArn
         *        The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of
         *        the computation model, which has the following format.</p>
         *        <p>
         *        <code>arn:${Partition}:iotsitewise:${Region}:${Account}:computation-model/${ComputationModelId}</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder computationModelArn(String computationModelArn);

        /**
         * <p>
         * The status of the computation model, containing a state (CREATING after successfully calling this operation)
         * and any error messages.
         * </p>
         * 
         * @param computationModelStatus
         *        The status of the computation model, containing a state (CREATING after successfully calling this
         *        operation) and any error messages.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder computationModelStatus(ComputationModelStatus computationModelStatus);

        /**
         * <p>
         * The status of the computation model, containing a state (CREATING after successfully calling this operation)
         * and any error messages.
         * </p>
         * This is a convenience method that creates an instance of the {@link ComputationModelStatus.Builder} avoiding
         * the need to create one manually via {@link ComputationModelStatus#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ComputationModelStatus.Builder#build()} is called immediately and
         * its result is passed to {@link #computationModelStatus(ComputationModelStatus)}.
         * 
         * @param computationModelStatus
         *        a consumer that will call methods on {@link ComputationModelStatus.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #computationModelStatus(ComputationModelStatus)
         */
        default Builder computationModelStatus(Consumer<ComputationModelStatus.Builder> computationModelStatus) {
            return computationModelStatus(ComputationModelStatus.builder().applyMutation(computationModelStatus).build());
        }
    }

    static final class BuilderImpl extends IoTSiteWiseResponse.BuilderImpl implements Builder {
        private String computationModelId;

        private String computationModelArn;

        private ComputationModelStatus computationModelStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateComputationModelResponse model) {
            super(model);
            computationModelId(model.computationModelId);
            computationModelArn(model.computationModelArn);
            computationModelStatus(model.computationModelStatus);
        }

        public final String getComputationModelId() {
            return computationModelId;
        }

        public final void setComputationModelId(String computationModelId) {
            this.computationModelId = computationModelId;
        }

        @Override
        public final Builder computationModelId(String computationModelId) {
            this.computationModelId = computationModelId;
            return this;
        }

        public final String getComputationModelArn() {
            return computationModelArn;
        }

        public final void setComputationModelArn(String computationModelArn) {
            this.computationModelArn = computationModelArn;
        }

        @Override
        public final Builder computationModelArn(String computationModelArn) {
            this.computationModelArn = computationModelArn;
            return this;
        }

        public final ComputationModelStatus.Builder getComputationModelStatus() {
            return computationModelStatus != null ? computationModelStatus.toBuilder() : null;
        }

        public final void setComputationModelStatus(ComputationModelStatus.BuilderImpl computationModelStatus) {
            this.computationModelStatus = computationModelStatus != null ? computationModelStatus.build() : null;
        }

        @Override
        public final Builder computationModelStatus(ComputationModelStatus computationModelStatus) {
            this.computationModelStatus = computationModelStatus;
            return this;
        }

        @Override
        public CreateComputationModelResponse build() {
            return new CreateComputationModelResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
