/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotsitewise.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateAssetRequest extends IoTSiteWiseRequest implements
        ToCopyableBuilder<CreateAssetRequest.Builder, CreateAssetRequest> {
    private static final SdkField<String> ASSET_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("assetName").getter(getter(CreateAssetRequest::assetName)).setter(setter(Builder::assetName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assetName").build()).build();

    private static final SdkField<String> ASSET_MODEL_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("assetModelId").getter(getter(CreateAssetRequest::assetModelId)).setter(setter(Builder::assetModelId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assetModelId").build()).build();

    private static final SdkField<String> ASSET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("assetId").getter(getter(CreateAssetRequest::assetId)).setter(setter(Builder::assetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assetId").build()).build();

    private static final SdkField<String> ASSET_EXTERNAL_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("assetExternalId").getter(getter(CreateAssetRequest::assetExternalId))
            .setter(setter(Builder::assetExternalId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assetExternalId").build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("clientToken")
            .getter(getter(CreateAssetRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(CreateAssetRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> ASSET_DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("assetDescription").getter(getter(CreateAssetRequest::assetDescription))
            .setter(setter(Builder::assetDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assetDescription").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSET_NAME_FIELD,
            ASSET_MODEL_ID_FIELD, ASSET_ID_FIELD, ASSET_EXTERNAL_ID_FIELD, CLIENT_TOKEN_FIELD, TAGS_FIELD,
            ASSET_DESCRIPTION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String assetName;

    private final String assetModelId;

    private final String assetId;

    private final String assetExternalId;

    private final String clientToken;

    private final Map<String, String> tags;

    private final String assetDescription;

    private CreateAssetRequest(BuilderImpl builder) {
        super(builder);
        this.assetName = builder.assetName;
        this.assetModelId = builder.assetModelId;
        this.assetId = builder.assetId;
        this.assetExternalId = builder.assetExternalId;
        this.clientToken = builder.clientToken;
        this.tags = builder.tags;
        this.assetDescription = builder.assetDescription;
    }

    /**
     * <p>
     * A friendly name for the asset.
     * </p>
     * 
     * @return A friendly name for the asset.
     */
    public final String assetName() {
        return assetName;
    }

    /**
     * <p>
     * The ID of the asset model from which to create the asset. This can be either the actual ID in UUID format, or
     * else <code>externalId:</code> followed by the external ID, if it has one. For more information, see <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/object-ids.html#external-id-references"
     * >Referencing objects with external IDs</a> in the <i>IoT SiteWise User Guide</i>.
     * </p>
     * 
     * @return The ID of the asset model from which to create the asset. This can be either the actual ID in UUID
     *         format, or else <code>externalId:</code> followed by the external ID, if it has one. For more
     *         information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/object-ids.html#external-id-references"
     *         >Referencing objects with external IDs</a> in the <i>IoT SiteWise User Guide</i>.
     */
    public final String assetModelId() {
        return assetModelId;
    }

    /**
     * <p>
     * The ID to assign to the asset, if desired. IoT SiteWise automatically generates a unique ID for you, so this
     * parameter is never required. However, if you prefer to supply your own ID instead, you can specify it here in
     * UUID format. If you specify your own ID, it must be globally unique.
     * </p>
     * 
     * @return The ID to assign to the asset, if desired. IoT SiteWise automatically generates a unique ID for you, so
     *         this parameter is never required. However, if you prefer to supply your own ID instead, you can specify
     *         it here in UUID format. If you specify your own ID, it must be globally unique.
     */
    public final String assetId() {
        return assetId;
    }

    /**
     * <p>
     * An external ID to assign to the asset. The external ID must be unique within your Amazon Web Services account.
     * For more information, see <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/object-ids.html#external-ids">Using external
     * IDs</a> in the <i>IoT SiteWise User Guide</i>.
     * </p>
     * 
     * @return An external ID to assign to the asset. The external ID must be unique within your Amazon Web Services
     *         account. For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/object-ids.html#external-ids">Using
     *         external IDs</a> in the <i>IoT SiteWise User Guide</i>.
     */
    public final String assetExternalId() {
        return assetExternalId;
    }

    /**
     * <p>
     * A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don't reuse
     * this client token if a new idempotent request is required.
     * </p>
     * 
     * @return A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don't
     *         reuse this client token if a new idempotent request is required.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A list of key-value pairs that contain metadata for the asset. For more information, see <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/tag-resources.html">Tagging your IoT SiteWise
     * resources</a> in the <i>IoT SiteWise User Guide</i>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return A list of key-value pairs that contain metadata for the asset. For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/tag-resources.html">Tagging your IoT
     *         SiteWise resources</a> in the <i>IoT SiteWise User Guide</i>.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    /**
     * <p>
     * A description for the asset.
     * </p>
     * 
     * @return A description for the asset.
     */
    public final String assetDescription() {
        return assetDescription;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(assetName());
        hashCode = 31 * hashCode + Objects.hashCode(assetModelId());
        hashCode = 31 * hashCode + Objects.hashCode(assetId());
        hashCode = 31 * hashCode + Objects.hashCode(assetExternalId());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(assetDescription());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateAssetRequest)) {
            return false;
        }
        CreateAssetRequest other = (CreateAssetRequest) obj;
        return Objects.equals(assetName(), other.assetName()) && Objects.equals(assetModelId(), other.assetModelId())
                && Objects.equals(assetId(), other.assetId()) && Objects.equals(assetExternalId(), other.assetExternalId())
                && Objects.equals(clientToken(), other.clientToken()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags()) && Objects.equals(assetDescription(), other.assetDescription());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateAssetRequest").add("AssetName", assetName()).add("AssetModelId", assetModelId())
                .add("AssetId", assetId()).add("AssetExternalId", assetExternalId()).add("ClientToken", clientToken())
                .add("Tags", hasTags() ? tags() : null).add("AssetDescription", assetDescription()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "assetName":
            return Optional.ofNullable(clazz.cast(assetName()));
        case "assetModelId":
            return Optional.ofNullable(clazz.cast(assetModelId()));
        case "assetId":
            return Optional.ofNullable(clazz.cast(assetId()));
        case "assetExternalId":
            return Optional.ofNullable(clazz.cast(assetExternalId()));
        case "clientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "assetDescription":
            return Optional.ofNullable(clazz.cast(assetDescription()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("assetName", ASSET_NAME_FIELD);
        map.put("assetModelId", ASSET_MODEL_ID_FIELD);
        map.put("assetId", ASSET_ID_FIELD);
        map.put("assetExternalId", ASSET_EXTERNAL_ID_FIELD);
        map.put("clientToken", CLIENT_TOKEN_FIELD);
        map.put("tags", TAGS_FIELD);
        map.put("assetDescription", ASSET_DESCRIPTION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateAssetRequest, T> g) {
        return obj -> g.apply((CreateAssetRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends IoTSiteWiseRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateAssetRequest> {
        /**
         * <p>
         * A friendly name for the asset.
         * </p>
         * 
         * @param assetName
         *        A friendly name for the asset.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assetName(String assetName);

        /**
         * <p>
         * The ID of the asset model from which to create the asset. This can be either the actual ID in UUID format, or
         * else <code>externalId:</code> followed by the external ID, if it has one. For more information, see <a
         * href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/object-ids.html#external-id-references"
         * >Referencing objects with external IDs</a> in the <i>IoT SiteWise User Guide</i>.
         * </p>
         * 
         * @param assetModelId
         *        The ID of the asset model from which to create the asset. This can be either the actual ID in UUID
         *        format, or else <code>externalId:</code> followed by the external ID, if it has one. For more
         *        information, see <a href=
         *        "https://docs.aws.amazon.com/iot-sitewise/latest/userguide/object-ids.html#external-id-references"
         *        >Referencing objects with external IDs</a> in the <i>IoT SiteWise User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assetModelId(String assetModelId);

        /**
         * <p>
         * The ID to assign to the asset, if desired. IoT SiteWise automatically generates a unique ID for you, so this
         * parameter is never required. However, if you prefer to supply your own ID instead, you can specify it here in
         * UUID format. If you specify your own ID, it must be globally unique.
         * </p>
         * 
         * @param assetId
         *        The ID to assign to the asset, if desired. IoT SiteWise automatically generates a unique ID for you,
         *        so this parameter is never required. However, if you prefer to supply your own ID instead, you can
         *        specify it here in UUID format. If you specify your own ID, it must be globally unique.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assetId(String assetId);

        /**
         * <p>
         * An external ID to assign to the asset. The external ID must be unique within your Amazon Web Services
         * account. For more information, see <a
         * href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/object-ids.html#external-ids">Using external
         * IDs</a> in the <i>IoT SiteWise User Guide</i>.
         * </p>
         * 
         * @param assetExternalId
         *        An external ID to assign to the asset. The external ID must be unique within your Amazon Web Services
         *        account. For more information, see <a
         *        href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/object-ids.html#external-ids">Using
         *        external IDs</a> in the <i>IoT SiteWise User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assetExternalId(String assetExternalId);

        /**
         * <p>
         * A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don't reuse
         * this client token if a new idempotent request is required.
         * </p>
         * 
         * @param clientToken
         *        A unique case-sensitive identifier that you can provide to ensure the idempotency of the request.
         *        Don't reuse this client token if a new idempotent request is required.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * A list of key-value pairs that contain metadata for the asset. For more information, see <a
         * href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/tag-resources.html">Tagging your IoT SiteWise
         * resources</a> in the <i>IoT SiteWise User Guide</i>.
         * </p>
         * 
         * @param tags
         *        A list of key-value pairs that contain metadata for the asset. For more information, see <a
         *        href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/tag-resources.html">Tagging your IoT
         *        SiteWise resources</a> in the <i>IoT SiteWise User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        /**
         * <p>
         * A description for the asset.
         * </p>
         * 
         * @param assetDescription
         *        A description for the asset.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assetDescription(String assetDescription);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends IoTSiteWiseRequest.BuilderImpl implements Builder {
        private String assetName;

        private String assetModelId;

        private String assetId;

        private String assetExternalId;

        private String clientToken;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private String assetDescription;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateAssetRequest model) {
            super(model);
            assetName(model.assetName);
            assetModelId(model.assetModelId);
            assetId(model.assetId);
            assetExternalId(model.assetExternalId);
            clientToken(model.clientToken);
            tags(model.tags);
            assetDescription(model.assetDescription);
        }

        public final String getAssetName() {
            return assetName;
        }

        public final void setAssetName(String assetName) {
            this.assetName = assetName;
        }

        @Override
        public final Builder assetName(String assetName) {
            this.assetName = assetName;
            return this;
        }

        public final String getAssetModelId() {
            return assetModelId;
        }

        public final void setAssetModelId(String assetModelId) {
            this.assetModelId = assetModelId;
        }

        @Override
        public final Builder assetModelId(String assetModelId) {
            this.assetModelId = assetModelId;
            return this;
        }

        public final String getAssetId() {
            return assetId;
        }

        public final void setAssetId(String assetId) {
            this.assetId = assetId;
        }

        @Override
        public final Builder assetId(String assetId) {
            this.assetId = assetId;
            return this;
        }

        public final String getAssetExternalId() {
            return assetExternalId;
        }

        public final void setAssetExternalId(String assetExternalId) {
            this.assetExternalId = assetExternalId;
        }

        @Override
        public final Builder assetExternalId(String assetExternalId) {
            this.assetExternalId = assetExternalId;
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final String getAssetDescription() {
            return assetDescription;
        }

        public final void setAssetDescription(String assetDescription) {
            this.assetDescription = assetDescription;
        }

        @Override
        public final Builder assetDescription(String assetDescription) {
            this.assetDescription = assetDescription;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateAssetRequest build() {
            return new CreateAssetRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
