/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotsitewise.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A summary of how a specific data binding is used across computation models. This tracks dependencies between data
 * sources and computation models, allowing you to understand the impact of changes to data sources.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ComputationModelDataBindingUsageSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<ComputationModelDataBindingUsageSummary.Builder, ComputationModelDataBindingUsageSummary> {
    private static final SdkField<List<String>> COMPUTATION_MODEL_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("computationModelIds")
            .getter(getter(ComputationModelDataBindingUsageSummary::computationModelIds))
            .setter(setter(Builder::computationModelIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("computationModelIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<MatchedDataBinding> MATCHED_DATA_BINDING_FIELD = SdkField
            .<MatchedDataBinding> builder(MarshallingType.SDK_POJO).memberName("matchedDataBinding")
            .getter(getter(ComputationModelDataBindingUsageSummary::matchedDataBinding))
            .setter(setter(Builder::matchedDataBinding)).constructor(MatchedDataBinding::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("matchedDataBinding").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMPUTATION_MODEL_IDS_FIELD,
            MATCHED_DATA_BINDING_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<String> computationModelIds;

    private final MatchedDataBinding matchedDataBinding;

    private ComputationModelDataBindingUsageSummary(BuilderImpl builder) {
        this.computationModelIds = builder.computationModelIds;
        this.matchedDataBinding = builder.matchedDataBinding;
    }

    /**
     * For responses, this returns true if the service returned a value for the ComputationModelIds property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasComputationModelIds() {
        return computationModelIds != null && !(computationModelIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of computation model IDs that use this data binding. This allows identification of all computation
     * models affected by changes to the referenced data source.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasComputationModelIds} method.
     * </p>
     * 
     * @return The list of computation model IDs that use this data binding. This allows identification of all
     *         computation models affected by changes to the referenced data source.
     */
    public final List<String> computationModelIds() {
        return computationModelIds;
    }

    /**
     * <p>
     * The data binding matched by the filter criteria. Contains details about specific data binding values used by the
     * computation models.
     * </p>
     * 
     * @return The data binding matched by the filter criteria. Contains details about specific data binding values used
     *         by the computation models.
     */
    public final MatchedDataBinding matchedDataBinding() {
        return matchedDataBinding;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasComputationModelIds() ? computationModelIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(matchedDataBinding());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ComputationModelDataBindingUsageSummary)) {
            return false;
        }
        ComputationModelDataBindingUsageSummary other = (ComputationModelDataBindingUsageSummary) obj;
        return hasComputationModelIds() == other.hasComputationModelIds()
                && Objects.equals(computationModelIds(), other.computationModelIds())
                && Objects.equals(matchedDataBinding(), other.matchedDataBinding());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ComputationModelDataBindingUsageSummary")
                .add("ComputationModelIds", hasComputationModelIds() ? computationModelIds() : null)
                .add("MatchedDataBinding", matchedDataBinding()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "computationModelIds":
            return Optional.ofNullable(clazz.cast(computationModelIds()));
        case "matchedDataBinding":
            return Optional.ofNullable(clazz.cast(matchedDataBinding()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("computationModelIds", COMPUTATION_MODEL_IDS_FIELD);
        map.put("matchedDataBinding", MATCHED_DATA_BINDING_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ComputationModelDataBindingUsageSummary, T> g) {
        return obj -> g.apply((ComputationModelDataBindingUsageSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ComputationModelDataBindingUsageSummary> {
        /**
         * <p>
         * The list of computation model IDs that use this data binding. This allows identification of all computation
         * models affected by changes to the referenced data source.
         * </p>
         * 
         * @param computationModelIds
         *        The list of computation model IDs that use this data binding. This allows identification of all
         *        computation models affected by changes to the referenced data source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder computationModelIds(Collection<String> computationModelIds);

        /**
         * <p>
         * The list of computation model IDs that use this data binding. This allows identification of all computation
         * models affected by changes to the referenced data source.
         * </p>
         * 
         * @param computationModelIds
         *        The list of computation model IDs that use this data binding. This allows identification of all
         *        computation models affected by changes to the referenced data source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder computationModelIds(String... computationModelIds);

        /**
         * <p>
         * The data binding matched by the filter criteria. Contains details about specific data binding values used by
         * the computation models.
         * </p>
         * 
         * @param matchedDataBinding
         *        The data binding matched by the filter criteria. Contains details about specific data binding values
         *        used by the computation models.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder matchedDataBinding(MatchedDataBinding matchedDataBinding);

        /**
         * <p>
         * The data binding matched by the filter criteria. Contains details about specific data binding values used by
         * the computation models.
         * </p>
         * This is a convenience method that creates an instance of the {@link MatchedDataBinding.Builder} avoiding the
         * need to create one manually via {@link MatchedDataBinding#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MatchedDataBinding.Builder#build()} is called immediately and its
         * result is passed to {@link #matchedDataBinding(MatchedDataBinding)}.
         * 
         * @param matchedDataBinding
         *        a consumer that will call methods on {@link MatchedDataBinding.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #matchedDataBinding(MatchedDataBinding)
         */
        default Builder matchedDataBinding(Consumer<MatchedDataBinding.Builder> matchedDataBinding) {
            return matchedDataBinding(MatchedDataBinding.builder().applyMutation(matchedDataBinding).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private List<String> computationModelIds = DefaultSdkAutoConstructList.getInstance();

        private MatchedDataBinding matchedDataBinding;

        private BuilderImpl() {
        }

        private BuilderImpl(ComputationModelDataBindingUsageSummary model) {
            computationModelIds(model.computationModelIds);
            matchedDataBinding(model.matchedDataBinding);
        }

        public final Collection<String> getComputationModelIds() {
            if (computationModelIds instanceof SdkAutoConstructList) {
                return null;
            }
            return computationModelIds;
        }

        public final void setComputationModelIds(Collection<String> computationModelIds) {
            this.computationModelIds = ComputationModelIdListCopier.copy(computationModelIds);
        }

        @Override
        public final Builder computationModelIds(Collection<String> computationModelIds) {
            this.computationModelIds = ComputationModelIdListCopier.copy(computationModelIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder computationModelIds(String... computationModelIds) {
            computationModelIds(Arrays.asList(computationModelIds));
            return this;
        }

        public final MatchedDataBinding.Builder getMatchedDataBinding() {
            return matchedDataBinding != null ? matchedDataBinding.toBuilder() : null;
        }

        public final void setMatchedDataBinding(MatchedDataBinding.BuilderImpl matchedDataBinding) {
            this.matchedDataBinding = matchedDataBinding != null ? matchedDataBinding.build() : null;
        }

        @Override
        public final Builder matchedDataBinding(MatchedDataBinding matchedDataBinding) {
            this.matchedDataBinding = matchedDataBinding;
            return this;
        }

        @Override
        public ComputationModelDataBindingUsageSummary build() {
            return new ComputationModelDataBindingUsageSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
