/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotsitewise.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchGetAssetPropertyAggregatesResponse extends IoTSiteWiseResponse implements
        ToCopyableBuilder<BatchGetAssetPropertyAggregatesResponse.Builder, BatchGetAssetPropertyAggregatesResponse> {
    private static final SdkField<List<BatchGetAssetPropertyAggregatesErrorEntry>> ERROR_ENTRIES_FIELD = SdkField
            .<List<BatchGetAssetPropertyAggregatesErrorEntry>> builder(MarshallingType.LIST)
            .memberName("errorEntries")
            .getter(getter(BatchGetAssetPropertyAggregatesResponse::errorEntries))
            .setter(setter(Builder::errorEntries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errorEntries").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<BatchGetAssetPropertyAggregatesErrorEntry> builder(MarshallingType.SDK_POJO)
                                            .constructor(BatchGetAssetPropertyAggregatesErrorEntry::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<BatchGetAssetPropertyAggregatesSuccessEntry>> SUCCESS_ENTRIES_FIELD = SdkField
            .<List<BatchGetAssetPropertyAggregatesSuccessEntry>> builder(MarshallingType.LIST)
            .memberName("successEntries")
            .getter(getter(BatchGetAssetPropertyAggregatesResponse::successEntries))
            .setter(setter(Builder::successEntries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("successEntries").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<BatchGetAssetPropertyAggregatesSuccessEntry> builder(MarshallingType.SDK_POJO)
                                            .constructor(BatchGetAssetPropertyAggregatesSuccessEntry::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<BatchGetAssetPropertyAggregatesSkippedEntry>> SKIPPED_ENTRIES_FIELD = SdkField
            .<List<BatchGetAssetPropertyAggregatesSkippedEntry>> builder(MarshallingType.LIST)
            .memberName("skippedEntries")
            .getter(getter(BatchGetAssetPropertyAggregatesResponse::skippedEntries))
            .setter(setter(Builder::skippedEntries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("skippedEntries").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<BatchGetAssetPropertyAggregatesSkippedEntry> builder(MarshallingType.SDK_POJO)
                                            .constructor(BatchGetAssetPropertyAggregatesSkippedEntry::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(BatchGetAssetPropertyAggregatesResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ERROR_ENTRIES_FIELD,
            SUCCESS_ENTRIES_FIELD, SKIPPED_ENTRIES_FIELD, NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<BatchGetAssetPropertyAggregatesErrorEntry> errorEntries;

    private final List<BatchGetAssetPropertyAggregatesSuccessEntry> successEntries;

    private final List<BatchGetAssetPropertyAggregatesSkippedEntry> skippedEntries;

    private final String nextToken;

    private BatchGetAssetPropertyAggregatesResponse(BuilderImpl builder) {
        super(builder);
        this.errorEntries = builder.errorEntries;
        this.successEntries = builder.successEntries;
        this.skippedEntries = builder.skippedEntries;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the ErrorEntries property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasErrorEntries() {
        return errorEntries != null && !(errorEntries instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of the errors (if any) associated with the batch request. Each error entry contains the
     * <code>entryId</code> of the entry that failed.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasErrorEntries} method.
     * </p>
     * 
     * @return A list of the errors (if any) associated with the batch request. Each error entry contains the
     *         <code>entryId</code> of the entry that failed.
     */
    public final List<BatchGetAssetPropertyAggregatesErrorEntry> errorEntries() {
        return errorEntries;
    }

    /**
     * For responses, this returns true if the service returned a value for the SuccessEntries property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSuccessEntries() {
        return successEntries != null && !(successEntries instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of entries that were processed successfully by this batch request. Each success entry contains the
     * <code>entryId</code> of the entry that succeeded and the latest query result.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSuccessEntries} method.
     * </p>
     * 
     * @return A list of entries that were processed successfully by this batch request. Each success entry contains the
     *         <code>entryId</code> of the entry that succeeded and the latest query result.
     */
    public final List<BatchGetAssetPropertyAggregatesSuccessEntry> successEntries() {
        return successEntries;
    }

    /**
     * For responses, this returns true if the service returned a value for the SkippedEntries property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSkippedEntries() {
        return skippedEntries != null && !(skippedEntries instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of entries that were not processed by this batch request. because these entries had been completely
     * processed by previous paginated requests. Each skipped entry contains the <code>entryId</code> of the entry that
     * skipped.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSkippedEntries} method.
     * </p>
     * 
     * @return A list of entries that were not processed by this batch request. because these entries had been
     *         completely processed by previous paginated requests. Each skipped entry contains the <code>entryId</code>
     *         of the entry that skipped.
     */
    public final List<BatchGetAssetPropertyAggregatesSkippedEntry> skippedEntries() {
        return skippedEntries;
    }

    /**
     * <p>
     * The token for the next set of results, or null if there are no additional results.
     * </p>
     * 
     * @return The token for the next set of results, or null if there are no additional results.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasErrorEntries() ? errorEntries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasSuccessEntries() ? successEntries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasSkippedEntries() ? skippedEntries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetAssetPropertyAggregatesResponse)) {
            return false;
        }
        BatchGetAssetPropertyAggregatesResponse other = (BatchGetAssetPropertyAggregatesResponse) obj;
        return hasErrorEntries() == other.hasErrorEntries() && Objects.equals(errorEntries(), other.errorEntries())
                && hasSuccessEntries() == other.hasSuccessEntries() && Objects.equals(successEntries(), other.successEntries())
                && hasSkippedEntries() == other.hasSkippedEntries() && Objects.equals(skippedEntries(), other.skippedEntries())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BatchGetAssetPropertyAggregatesResponse")
                .add("ErrorEntries", hasErrorEntries() ? errorEntries() : null)
                .add("SuccessEntries", hasSuccessEntries() ? successEntries() : null)
                .add("SkippedEntries", hasSkippedEntries() ? skippedEntries() : null).add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "errorEntries":
            return Optional.ofNullable(clazz.cast(errorEntries()));
        case "successEntries":
            return Optional.ofNullable(clazz.cast(successEntries()));
        case "skippedEntries":
            return Optional.ofNullable(clazz.cast(skippedEntries()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("errorEntries", ERROR_ENTRIES_FIELD);
        map.put("successEntries", SUCCESS_ENTRIES_FIELD);
        map.put("skippedEntries", SKIPPED_ENTRIES_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BatchGetAssetPropertyAggregatesResponse, T> g) {
        return obj -> g.apply((BatchGetAssetPropertyAggregatesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends IoTSiteWiseResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, BatchGetAssetPropertyAggregatesResponse> {
        /**
         * <p>
         * A list of the errors (if any) associated with the batch request. Each error entry contains the
         * <code>entryId</code> of the entry that failed.
         * </p>
         * 
         * @param errorEntries
         *        A list of the errors (if any) associated with the batch request. Each error entry contains the
         *        <code>entryId</code> of the entry that failed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorEntries(Collection<BatchGetAssetPropertyAggregatesErrorEntry> errorEntries);

        /**
         * <p>
         * A list of the errors (if any) associated with the batch request. Each error entry contains the
         * <code>entryId</code> of the entry that failed.
         * </p>
         * 
         * @param errorEntries
         *        A list of the errors (if any) associated with the batch request. Each error entry contains the
         *        <code>entryId</code> of the entry that failed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorEntries(BatchGetAssetPropertyAggregatesErrorEntry... errorEntries);

        /**
         * <p>
         * A list of the errors (if any) associated with the batch request. Each error entry contains the
         * <code>entryId</code> of the entry that failed.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.iotsitewise.model.BatchGetAssetPropertyAggregatesErrorEntry.Builder}
         * avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.iotsitewise.model.BatchGetAssetPropertyAggregatesErrorEntry#builder()}
         * .
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.iotsitewise.model.BatchGetAssetPropertyAggregatesErrorEntry.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #errorEntries(List<BatchGetAssetPropertyAggregatesErrorEntry>)}.
         * 
         * @param errorEntries
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.iotsitewise.model.BatchGetAssetPropertyAggregatesErrorEntry.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #errorEntries(java.util.Collection<BatchGetAssetPropertyAggregatesErrorEntry>)
         */
        Builder errorEntries(Consumer<BatchGetAssetPropertyAggregatesErrorEntry.Builder>... errorEntries);

        /**
         * <p>
         * A list of entries that were processed successfully by this batch request. Each success entry contains the
         * <code>entryId</code> of the entry that succeeded and the latest query result.
         * </p>
         * 
         * @param successEntries
         *        A list of entries that were processed successfully by this batch request. Each success entry contains
         *        the <code>entryId</code> of the entry that succeeded and the latest query result.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder successEntries(Collection<BatchGetAssetPropertyAggregatesSuccessEntry> successEntries);

        /**
         * <p>
         * A list of entries that were processed successfully by this batch request. Each success entry contains the
         * <code>entryId</code> of the entry that succeeded and the latest query result.
         * </p>
         * 
         * @param successEntries
         *        A list of entries that were processed successfully by this batch request. Each success entry contains
         *        the <code>entryId</code> of the entry that succeeded and the latest query result.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder successEntries(BatchGetAssetPropertyAggregatesSuccessEntry... successEntries);

        /**
         * <p>
         * A list of entries that were processed successfully by this batch request. Each success entry contains the
         * <code>entryId</code> of the entry that succeeded and the latest query result.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.iotsitewise.model.BatchGetAssetPropertyAggregatesSuccessEntry.Builder}
         * avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.iotsitewise.model.BatchGetAssetPropertyAggregatesSuccessEntry#builder()}
         * .
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.iotsitewise.model.BatchGetAssetPropertyAggregatesSuccessEntry.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #successEntries(List<BatchGetAssetPropertyAggregatesSuccessEntry>)}.
         * 
         * @param successEntries
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.iotsitewise.model.BatchGetAssetPropertyAggregatesSuccessEntry.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #successEntries(java.util.Collection<BatchGetAssetPropertyAggregatesSuccessEntry>)
         */
        Builder successEntries(Consumer<BatchGetAssetPropertyAggregatesSuccessEntry.Builder>... successEntries);

        /**
         * <p>
         * A list of entries that were not processed by this batch request. because these entries had been completely
         * processed by previous paginated requests. Each skipped entry contains the <code>entryId</code> of the entry
         * that skipped.
         * </p>
         * 
         * @param skippedEntries
         *        A list of entries that were not processed by this batch request. because these entries had been
         *        completely processed by previous paginated requests. Each skipped entry contains the
         *        <code>entryId</code> of the entry that skipped.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder skippedEntries(Collection<BatchGetAssetPropertyAggregatesSkippedEntry> skippedEntries);

        /**
         * <p>
         * A list of entries that were not processed by this batch request. because these entries had been completely
         * processed by previous paginated requests. Each skipped entry contains the <code>entryId</code> of the entry
         * that skipped.
         * </p>
         * 
         * @param skippedEntries
         *        A list of entries that were not processed by this batch request. because these entries had been
         *        completely processed by previous paginated requests. Each skipped entry contains the
         *        <code>entryId</code> of the entry that skipped.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder skippedEntries(BatchGetAssetPropertyAggregatesSkippedEntry... skippedEntries);

        /**
         * <p>
         * A list of entries that were not processed by this batch request. because these entries had been completely
         * processed by previous paginated requests. Each skipped entry contains the <code>entryId</code> of the entry
         * that skipped.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.iotsitewise.model.BatchGetAssetPropertyAggregatesSkippedEntry.Builder}
         * avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.iotsitewise.model.BatchGetAssetPropertyAggregatesSkippedEntry#builder()}
         * .
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.iotsitewise.model.BatchGetAssetPropertyAggregatesSkippedEntry.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #skippedEntries(List<BatchGetAssetPropertyAggregatesSkippedEntry>)}.
         * 
         * @param skippedEntries
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.iotsitewise.model.BatchGetAssetPropertyAggregatesSkippedEntry.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #skippedEntries(java.util.Collection<BatchGetAssetPropertyAggregatesSkippedEntry>)
         */
        Builder skippedEntries(Consumer<BatchGetAssetPropertyAggregatesSkippedEntry.Builder>... skippedEntries);

        /**
         * <p>
         * The token for the next set of results, or null if there are no additional results.
         * </p>
         * 
         * @param nextToken
         *        The token for the next set of results, or null if there are no additional results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends IoTSiteWiseResponse.BuilderImpl implements Builder {
        private List<BatchGetAssetPropertyAggregatesErrorEntry> errorEntries = DefaultSdkAutoConstructList.getInstance();

        private List<BatchGetAssetPropertyAggregatesSuccessEntry> successEntries = DefaultSdkAutoConstructList.getInstance();

        private List<BatchGetAssetPropertyAggregatesSkippedEntry> skippedEntries = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchGetAssetPropertyAggregatesResponse model) {
            super(model);
            errorEntries(model.errorEntries);
            successEntries(model.successEntries);
            skippedEntries(model.skippedEntries);
            nextToken(model.nextToken);
        }

        public final List<BatchGetAssetPropertyAggregatesErrorEntry.Builder> getErrorEntries() {
            List<BatchGetAssetPropertyAggregatesErrorEntry.Builder> result = BatchGetAssetPropertyAggregatesErrorEntriesCopier
                    .copyToBuilder(this.errorEntries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setErrorEntries(Collection<BatchGetAssetPropertyAggregatesErrorEntry.BuilderImpl> errorEntries) {
            this.errorEntries = BatchGetAssetPropertyAggregatesErrorEntriesCopier.copyFromBuilder(errorEntries);
        }

        @Override
        public final Builder errorEntries(Collection<BatchGetAssetPropertyAggregatesErrorEntry> errorEntries) {
            this.errorEntries = BatchGetAssetPropertyAggregatesErrorEntriesCopier.copy(errorEntries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errorEntries(BatchGetAssetPropertyAggregatesErrorEntry... errorEntries) {
            errorEntries(Arrays.asList(errorEntries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errorEntries(Consumer<BatchGetAssetPropertyAggregatesErrorEntry.Builder>... errorEntries) {
            errorEntries(Stream.of(errorEntries)
                    .map(c -> BatchGetAssetPropertyAggregatesErrorEntry.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<BatchGetAssetPropertyAggregatesSuccessEntry.Builder> getSuccessEntries() {
            List<BatchGetAssetPropertyAggregatesSuccessEntry.Builder> result = BatchGetAssetPropertyAggregatesSuccessEntriesCopier
                    .copyToBuilder(this.successEntries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSuccessEntries(Collection<BatchGetAssetPropertyAggregatesSuccessEntry.BuilderImpl> successEntries) {
            this.successEntries = BatchGetAssetPropertyAggregatesSuccessEntriesCopier.copyFromBuilder(successEntries);
        }

        @Override
        public final Builder successEntries(Collection<BatchGetAssetPropertyAggregatesSuccessEntry> successEntries) {
            this.successEntries = BatchGetAssetPropertyAggregatesSuccessEntriesCopier.copy(successEntries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder successEntries(BatchGetAssetPropertyAggregatesSuccessEntry... successEntries) {
            successEntries(Arrays.asList(successEntries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder successEntries(Consumer<BatchGetAssetPropertyAggregatesSuccessEntry.Builder>... successEntries) {
            successEntries(Stream.of(successEntries)
                    .map(c -> BatchGetAssetPropertyAggregatesSuccessEntry.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<BatchGetAssetPropertyAggregatesSkippedEntry.Builder> getSkippedEntries() {
            List<BatchGetAssetPropertyAggregatesSkippedEntry.Builder> result = BatchGetAssetPropertyAggregatesSkippedEntriesCopier
                    .copyToBuilder(this.skippedEntries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSkippedEntries(Collection<BatchGetAssetPropertyAggregatesSkippedEntry.BuilderImpl> skippedEntries) {
            this.skippedEntries = BatchGetAssetPropertyAggregatesSkippedEntriesCopier.copyFromBuilder(skippedEntries);
        }

        @Override
        public final Builder skippedEntries(Collection<BatchGetAssetPropertyAggregatesSkippedEntry> skippedEntries) {
            this.skippedEntries = BatchGetAssetPropertyAggregatesSkippedEntriesCopier.copy(skippedEntries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder skippedEntries(BatchGetAssetPropertyAggregatesSkippedEntry... skippedEntries) {
            skippedEntries(Arrays.asList(skippedEntries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder skippedEntries(Consumer<BatchGetAssetPropertyAggregatesSkippedEntry.Builder>... skippedEntries) {
            skippedEntries(Stream.of(skippedEntries)
                    .map(c -> BatchGetAssetPropertyAggregatesSkippedEntry.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public BatchGetAssetPropertyAggregatesResponse build() {
            return new BatchGetAssetPropertyAggregatesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
