/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotsitewise.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about an <code>assetModelProperty</code> binding value.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AssetModelPropertyBindingValue implements SdkPojo, Serializable,
        ToCopyableBuilder<AssetModelPropertyBindingValue.Builder, AssetModelPropertyBindingValue> {
    private static final SdkField<String> ASSET_MODEL_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("assetModelId").getter(getter(AssetModelPropertyBindingValue::assetModelId))
            .setter(setter(Builder::assetModelId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assetModelId").build()).build();

    private static final SdkField<String> PROPERTY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("propertyId").getter(getter(AssetModelPropertyBindingValue::propertyId))
            .setter(setter(Builder::propertyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("propertyId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSET_MODEL_ID_FIELD,
            PROPERTY_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String assetModelId;

    private final String propertyId;

    private AssetModelPropertyBindingValue(BuilderImpl builder) {
        this.assetModelId = builder.assetModelId;
        this.propertyId = builder.propertyId;
    }

    /**
     * <p>
     * The ID of the asset model, in UUID format.
     * </p>
     * 
     * @return The ID of the asset model, in UUID format.
     */
    public final String assetModelId() {
        return assetModelId;
    }

    /**
     * <p>
     * The ID of the asset model property used in data binding value.
     * </p>
     * 
     * @return The ID of the asset model property used in data binding value.
     */
    public final String propertyId() {
        return propertyId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(assetModelId());
        hashCode = 31 * hashCode + Objects.hashCode(propertyId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssetModelPropertyBindingValue)) {
            return false;
        }
        AssetModelPropertyBindingValue other = (AssetModelPropertyBindingValue) obj;
        return Objects.equals(assetModelId(), other.assetModelId()) && Objects.equals(propertyId(), other.propertyId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AssetModelPropertyBindingValue").add("AssetModelId", assetModelId())
                .add("PropertyId", propertyId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "assetModelId":
            return Optional.ofNullable(clazz.cast(assetModelId()));
        case "propertyId":
            return Optional.ofNullable(clazz.cast(propertyId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("assetModelId", ASSET_MODEL_ID_FIELD);
        map.put("propertyId", PROPERTY_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AssetModelPropertyBindingValue, T> g) {
        return obj -> g.apply((AssetModelPropertyBindingValue) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AssetModelPropertyBindingValue> {
        /**
         * <p>
         * The ID of the asset model, in UUID format.
         * </p>
         * 
         * @param assetModelId
         *        The ID of the asset model, in UUID format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assetModelId(String assetModelId);

        /**
         * <p>
         * The ID of the asset model property used in data binding value.
         * </p>
         * 
         * @param propertyId
         *        The ID of the asset model property used in data binding value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder propertyId(String propertyId);
    }

    static final class BuilderImpl implements Builder {
        private String assetModelId;

        private String propertyId;

        private BuilderImpl() {
        }

        private BuilderImpl(AssetModelPropertyBindingValue model) {
            assetModelId(model.assetModelId);
            propertyId(model.propertyId);
        }

        public final String getAssetModelId() {
            return assetModelId;
        }

        public final void setAssetModelId(String assetModelId) {
            this.assetModelId = assetModelId;
        }

        @Override
        public final Builder assetModelId(String assetModelId) {
            this.assetModelId = assetModelId;
            return this;
        }

        public final String getPropertyId() {
            return propertyId;
        }

        public final void setPropertyId(String propertyId) {
            this.propertyId = propertyId;
        }

        @Override
        public final Builder propertyId(String propertyId) {
            this.propertyId = propertyId;
            return this;
        }

        @Override
        public AssetModelPropertyBindingValue build() {
            return new AssetModelPropertyBindingValue(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
