/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotsitewise.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PropertyMapping
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PropertyMapping> {
    private static final SdkField<String> ASSET_MODEL_PROPERTY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("assetModelPropertyId").getter(PropertyMapping.getter(PropertyMapping::assetModelPropertyId)).setter(PropertyMapping.setter(Builder::assetModelPropertyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assetModelPropertyId").build()}).build();
    private static final SdkField<String> INTERFACE_ASSET_MODEL_PROPERTY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("interfaceAssetModelPropertyId").getter(PropertyMapping.getter(PropertyMapping::interfaceAssetModelPropertyId)).setter(PropertyMapping.setter(Builder::interfaceAssetModelPropertyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("interfaceAssetModelPropertyId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSET_MODEL_PROPERTY_ID_FIELD, INTERFACE_ASSET_MODEL_PROPERTY_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = PropertyMapping.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String assetModelPropertyId;
    private final String interfaceAssetModelPropertyId;

    private PropertyMapping(BuilderImpl builder) {
        this.assetModelPropertyId = builder.assetModelPropertyId;
        this.interfaceAssetModelPropertyId = builder.interfaceAssetModelPropertyId;
    }

    public final String assetModelPropertyId() {
        return this.assetModelPropertyId;
    }

    public final String interfaceAssetModelPropertyId() {
        return this.interfaceAssetModelPropertyId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.assetModelPropertyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.interfaceAssetModelPropertyId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PropertyMapping)) {
            return false;
        }
        PropertyMapping other = (PropertyMapping)obj;
        return Objects.equals(this.assetModelPropertyId(), other.assetModelPropertyId()) && Objects.equals(this.interfaceAssetModelPropertyId(), other.interfaceAssetModelPropertyId());
    }

    public final String toString() {
        return ToString.builder((String)"PropertyMapping").add("AssetModelPropertyId", (Object)this.assetModelPropertyId()).add("InterfaceAssetModelPropertyId", (Object)this.interfaceAssetModelPropertyId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "assetModelPropertyId": {
                return Optional.ofNullable(clazz.cast(this.assetModelPropertyId()));
            }
            case "interfaceAssetModelPropertyId": {
                return Optional.ofNullable(clazz.cast(this.interfaceAssetModelPropertyId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("assetModelPropertyId", ASSET_MODEL_PROPERTY_ID_FIELD);
        map.put("interfaceAssetModelPropertyId", INTERFACE_ASSET_MODEL_PROPERTY_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PropertyMapping, T> g) {
        return obj -> g.apply((PropertyMapping)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String assetModelPropertyId;
        private String interfaceAssetModelPropertyId;

        private BuilderImpl() {
        }

        private BuilderImpl(PropertyMapping model) {
            this.assetModelPropertyId(model.assetModelPropertyId);
            this.interfaceAssetModelPropertyId(model.interfaceAssetModelPropertyId);
        }

        public final String getAssetModelPropertyId() {
            return this.assetModelPropertyId;
        }

        public final void setAssetModelPropertyId(String assetModelPropertyId) {
            this.assetModelPropertyId = assetModelPropertyId;
        }

        @Override
        public final Builder assetModelPropertyId(String assetModelPropertyId) {
            this.assetModelPropertyId = assetModelPropertyId;
            return this;
        }

        public final String getInterfaceAssetModelPropertyId() {
            return this.interfaceAssetModelPropertyId;
        }

        public final void setInterfaceAssetModelPropertyId(String interfaceAssetModelPropertyId) {
            this.interfaceAssetModelPropertyId = interfaceAssetModelPropertyId;
        }

        @Override
        public final Builder interfaceAssetModelPropertyId(String interfaceAssetModelPropertyId) {
            this.interfaceAssetModelPropertyId = interfaceAssetModelPropertyId;
            return this;
        }

        public PropertyMapping build() {
            return new PropertyMapping(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PropertyMapping> {
        public Builder assetModelPropertyId(String var1);

        public Builder interfaceAssetModelPropertyId(String var1);
    }
}

