/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotsitewise.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iotsitewise.model.Identity;
import software.amazon.awssdk.services.iotsitewise.model.IoTSiteWiseResponse;
import software.amazon.awssdk.services.iotsitewise.model.Permission;
import software.amazon.awssdk.services.iotsitewise.model.Resource;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeAccessPolicyResponse
extends IoTSiteWiseResponse
implements ToCopyableBuilder<Builder, DescribeAccessPolicyResponse> {
    private static final SdkField<String> ACCESS_POLICY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("accessPolicyId").getter(DescribeAccessPolicyResponse.getter(DescribeAccessPolicyResponse::accessPolicyId)).setter(DescribeAccessPolicyResponse.setter(Builder::accessPolicyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accessPolicyId").build()}).build();
    private static final SdkField<String> ACCESS_POLICY_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("accessPolicyArn").getter(DescribeAccessPolicyResponse.getter(DescribeAccessPolicyResponse::accessPolicyArn)).setter(DescribeAccessPolicyResponse.setter(Builder::accessPolicyArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accessPolicyArn").build()}).build();
    private static final SdkField<Identity> ACCESS_POLICY_IDENTITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("accessPolicyIdentity").getter(DescribeAccessPolicyResponse.getter(DescribeAccessPolicyResponse::accessPolicyIdentity)).setter(DescribeAccessPolicyResponse.setter(Builder::accessPolicyIdentity)).constructor(Identity::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accessPolicyIdentity").build()}).build();
    private static final SdkField<Resource> ACCESS_POLICY_RESOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("accessPolicyResource").getter(DescribeAccessPolicyResponse.getter(DescribeAccessPolicyResponse::accessPolicyResource)).setter(DescribeAccessPolicyResponse.setter(Builder::accessPolicyResource)).constructor(Resource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accessPolicyResource").build()}).build();
    private static final SdkField<String> ACCESS_POLICY_PERMISSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("accessPolicyPermission").getter(DescribeAccessPolicyResponse.getter(DescribeAccessPolicyResponse::accessPolicyPermissionAsString)).setter(DescribeAccessPolicyResponse.setter(Builder::accessPolicyPermission)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accessPolicyPermission").build()}).build();
    private static final SdkField<Instant> ACCESS_POLICY_CREATION_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("accessPolicyCreationDate").getter(DescribeAccessPolicyResponse.getter(DescribeAccessPolicyResponse::accessPolicyCreationDate)).setter(DescribeAccessPolicyResponse.setter(Builder::accessPolicyCreationDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accessPolicyCreationDate").build()}).build();
    private static final SdkField<Instant> ACCESS_POLICY_LAST_UPDATE_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("accessPolicyLastUpdateDate").getter(DescribeAccessPolicyResponse.getter(DescribeAccessPolicyResponse::accessPolicyLastUpdateDate)).setter(DescribeAccessPolicyResponse.setter(Builder::accessPolicyLastUpdateDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accessPolicyLastUpdateDate").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCESS_POLICY_ID_FIELD, ACCESS_POLICY_ARN_FIELD, ACCESS_POLICY_IDENTITY_FIELD, ACCESS_POLICY_RESOURCE_FIELD, ACCESS_POLICY_PERMISSION_FIELD, ACCESS_POLICY_CREATION_DATE_FIELD, ACCESS_POLICY_LAST_UPDATE_DATE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeAccessPolicyResponse.memberNameToFieldInitializer();
    private final String accessPolicyId;
    private final String accessPolicyArn;
    private final Identity accessPolicyIdentity;
    private final Resource accessPolicyResource;
    private final String accessPolicyPermission;
    private final Instant accessPolicyCreationDate;
    private final Instant accessPolicyLastUpdateDate;

    private DescribeAccessPolicyResponse(BuilderImpl builder) {
        super(builder);
        this.accessPolicyId = builder.accessPolicyId;
        this.accessPolicyArn = builder.accessPolicyArn;
        this.accessPolicyIdentity = builder.accessPolicyIdentity;
        this.accessPolicyResource = builder.accessPolicyResource;
        this.accessPolicyPermission = builder.accessPolicyPermission;
        this.accessPolicyCreationDate = builder.accessPolicyCreationDate;
        this.accessPolicyLastUpdateDate = builder.accessPolicyLastUpdateDate;
    }

    public final String accessPolicyId() {
        return this.accessPolicyId;
    }

    public final String accessPolicyArn() {
        return this.accessPolicyArn;
    }

    public final Identity accessPolicyIdentity() {
        return this.accessPolicyIdentity;
    }

    public final Resource accessPolicyResource() {
        return this.accessPolicyResource;
    }

    public final Permission accessPolicyPermission() {
        return Permission.fromValue(this.accessPolicyPermission);
    }

    public final String accessPolicyPermissionAsString() {
        return this.accessPolicyPermission;
    }

    public final Instant accessPolicyCreationDate() {
        return this.accessPolicyCreationDate;
    }

    public final Instant accessPolicyLastUpdateDate() {
        return this.accessPolicyLastUpdateDate;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.accessPolicyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.accessPolicyArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.accessPolicyIdentity());
        hashCode = 31 * hashCode + Objects.hashCode(this.accessPolicyResource());
        hashCode = 31 * hashCode + Objects.hashCode(this.accessPolicyPermissionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.accessPolicyCreationDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.accessPolicyLastUpdateDate());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeAccessPolicyResponse)) {
            return false;
        }
        DescribeAccessPolicyResponse other = (DescribeAccessPolicyResponse)((Object)obj);
        return Objects.equals(this.accessPolicyId(), other.accessPolicyId()) && Objects.equals(this.accessPolicyArn(), other.accessPolicyArn()) && Objects.equals(this.accessPolicyIdentity(), other.accessPolicyIdentity()) && Objects.equals(this.accessPolicyResource(), other.accessPolicyResource()) && Objects.equals(this.accessPolicyPermissionAsString(), other.accessPolicyPermissionAsString()) && Objects.equals(this.accessPolicyCreationDate(), other.accessPolicyCreationDate()) && Objects.equals(this.accessPolicyLastUpdateDate(), other.accessPolicyLastUpdateDate());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeAccessPolicyResponse").add("AccessPolicyId", (Object)this.accessPolicyId()).add("AccessPolicyArn", (Object)this.accessPolicyArn()).add("AccessPolicyIdentity", (Object)this.accessPolicyIdentity()).add("AccessPolicyResource", (Object)this.accessPolicyResource()).add("AccessPolicyPermission", (Object)this.accessPolicyPermissionAsString()).add("AccessPolicyCreationDate", (Object)this.accessPolicyCreationDate()).add("AccessPolicyLastUpdateDate", (Object)this.accessPolicyLastUpdateDate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "accessPolicyId": {
                return Optional.ofNullable(clazz.cast(this.accessPolicyId()));
            }
            case "accessPolicyArn": {
                return Optional.ofNullable(clazz.cast(this.accessPolicyArn()));
            }
            case "accessPolicyIdentity": {
                return Optional.ofNullable(clazz.cast(this.accessPolicyIdentity()));
            }
            case "accessPolicyResource": {
                return Optional.ofNullable(clazz.cast(this.accessPolicyResource()));
            }
            case "accessPolicyPermission": {
                return Optional.ofNullable(clazz.cast(this.accessPolicyPermissionAsString()));
            }
            case "accessPolicyCreationDate": {
                return Optional.ofNullable(clazz.cast(this.accessPolicyCreationDate()));
            }
            case "accessPolicyLastUpdateDate": {
                return Optional.ofNullable(clazz.cast(this.accessPolicyLastUpdateDate()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("accessPolicyId", ACCESS_POLICY_ID_FIELD);
        map.put("accessPolicyArn", ACCESS_POLICY_ARN_FIELD);
        map.put("accessPolicyIdentity", ACCESS_POLICY_IDENTITY_FIELD);
        map.put("accessPolicyResource", ACCESS_POLICY_RESOURCE_FIELD);
        map.put("accessPolicyPermission", ACCESS_POLICY_PERMISSION_FIELD);
        map.put("accessPolicyCreationDate", ACCESS_POLICY_CREATION_DATE_FIELD);
        map.put("accessPolicyLastUpdateDate", ACCESS_POLICY_LAST_UPDATE_DATE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeAccessPolicyResponse, T> g) {
        return obj -> g.apply((DescribeAccessPolicyResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IoTSiteWiseResponse.BuilderImpl
    implements Builder {
        private String accessPolicyId;
        private String accessPolicyArn;
        private Identity accessPolicyIdentity;
        private Resource accessPolicyResource;
        private String accessPolicyPermission;
        private Instant accessPolicyCreationDate;
        private Instant accessPolicyLastUpdateDate;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeAccessPolicyResponse model) {
            super(model);
            this.accessPolicyId(model.accessPolicyId);
            this.accessPolicyArn(model.accessPolicyArn);
            this.accessPolicyIdentity(model.accessPolicyIdentity);
            this.accessPolicyResource(model.accessPolicyResource);
            this.accessPolicyPermission(model.accessPolicyPermission);
            this.accessPolicyCreationDate(model.accessPolicyCreationDate);
            this.accessPolicyLastUpdateDate(model.accessPolicyLastUpdateDate);
        }

        public final String getAccessPolicyId() {
            return this.accessPolicyId;
        }

        public final void setAccessPolicyId(String accessPolicyId) {
            this.accessPolicyId = accessPolicyId;
        }

        @Override
        public final Builder accessPolicyId(String accessPolicyId) {
            this.accessPolicyId = accessPolicyId;
            return this;
        }

        public final String getAccessPolicyArn() {
            return this.accessPolicyArn;
        }

        public final void setAccessPolicyArn(String accessPolicyArn) {
            this.accessPolicyArn = accessPolicyArn;
        }

        @Override
        public final Builder accessPolicyArn(String accessPolicyArn) {
            this.accessPolicyArn = accessPolicyArn;
            return this;
        }

        public final Identity.Builder getAccessPolicyIdentity() {
            return this.accessPolicyIdentity != null ? this.accessPolicyIdentity.toBuilder() : null;
        }

        public final void setAccessPolicyIdentity(Identity.BuilderImpl accessPolicyIdentity) {
            this.accessPolicyIdentity = accessPolicyIdentity != null ? accessPolicyIdentity.build() : null;
        }

        @Override
        public final Builder accessPolicyIdentity(Identity accessPolicyIdentity) {
            this.accessPolicyIdentity = accessPolicyIdentity;
            return this;
        }

        public final Resource.Builder getAccessPolicyResource() {
            return this.accessPolicyResource != null ? this.accessPolicyResource.toBuilder() : null;
        }

        public final void setAccessPolicyResource(Resource.BuilderImpl accessPolicyResource) {
            this.accessPolicyResource = accessPolicyResource != null ? accessPolicyResource.build() : null;
        }

        @Override
        public final Builder accessPolicyResource(Resource accessPolicyResource) {
            this.accessPolicyResource = accessPolicyResource;
            return this;
        }

        public final String getAccessPolicyPermission() {
            return this.accessPolicyPermission;
        }

        public final void setAccessPolicyPermission(String accessPolicyPermission) {
            this.accessPolicyPermission = accessPolicyPermission;
        }

        @Override
        public final Builder accessPolicyPermission(String accessPolicyPermission) {
            this.accessPolicyPermission = accessPolicyPermission;
            return this;
        }

        @Override
        public final Builder accessPolicyPermission(Permission accessPolicyPermission) {
            this.accessPolicyPermission(accessPolicyPermission == null ? null : accessPolicyPermission.toString());
            return this;
        }

        public final Instant getAccessPolicyCreationDate() {
            return this.accessPolicyCreationDate;
        }

        public final void setAccessPolicyCreationDate(Instant accessPolicyCreationDate) {
            this.accessPolicyCreationDate = accessPolicyCreationDate;
        }

        @Override
        public final Builder accessPolicyCreationDate(Instant accessPolicyCreationDate) {
            this.accessPolicyCreationDate = accessPolicyCreationDate;
            return this;
        }

        public final Instant getAccessPolicyLastUpdateDate() {
            return this.accessPolicyLastUpdateDate;
        }

        public final void setAccessPolicyLastUpdateDate(Instant accessPolicyLastUpdateDate) {
            this.accessPolicyLastUpdateDate = accessPolicyLastUpdateDate;
        }

        @Override
        public final Builder accessPolicyLastUpdateDate(Instant accessPolicyLastUpdateDate) {
            this.accessPolicyLastUpdateDate = accessPolicyLastUpdateDate;
            return this;
        }

        @Override
        public DescribeAccessPolicyResponse build() {
            return new DescribeAccessPolicyResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends IoTSiteWiseResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeAccessPolicyResponse> {
        public Builder accessPolicyId(String var1);

        public Builder accessPolicyArn(String var1);

        public Builder accessPolicyIdentity(Identity var1);

        default public Builder accessPolicyIdentity(Consumer<Identity.Builder> accessPolicyIdentity) {
            return this.accessPolicyIdentity((Identity)((Identity.Builder)Identity.builder().applyMutation(accessPolicyIdentity)).build());
        }

        public Builder accessPolicyResource(Resource var1);

        default public Builder accessPolicyResource(Consumer<Resource.Builder> accessPolicyResource) {
            return this.accessPolicyResource((Resource)((Resource.Builder)Resource.builder().applyMutation(accessPolicyResource)).build());
        }

        public Builder accessPolicyPermission(String var1);

        public Builder accessPolicyPermission(Permission var1);

        public Builder accessPolicyCreationDate(Instant var1);

        public Builder accessPolicyLastUpdateDate(Instant var1);
    }
}

