/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotsitewise.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.iotsitewise.model.ErrorReportLocation;
import software.amazon.awssdk.services.iotsitewise.model.File;
import software.amazon.awssdk.services.iotsitewise.model.FilesCopier;
import software.amazon.awssdk.services.iotsitewise.model.IoTSiteWiseResponse;
import software.amazon.awssdk.services.iotsitewise.model.JobConfiguration;
import software.amazon.awssdk.services.iotsitewise.model.JobStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeBulkImportJobResponse
extends IoTSiteWiseResponse
implements ToCopyableBuilder<Builder, DescribeBulkImportJobResponse> {
    private static final SdkField<String> JOB_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("jobId").getter(DescribeBulkImportJobResponse.getter(DescribeBulkImportJobResponse::jobId)).setter(DescribeBulkImportJobResponse.setter(Builder::jobId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobId").build()}).build();
    private static final SdkField<String> JOB_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("jobName").getter(DescribeBulkImportJobResponse.getter(DescribeBulkImportJobResponse::jobName)).setter(DescribeBulkImportJobResponse.setter(Builder::jobName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobName").build()}).build();
    private static final SdkField<String> JOB_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("jobStatus").getter(DescribeBulkImportJobResponse.getter(DescribeBulkImportJobResponse::jobStatusAsString)).setter(DescribeBulkImportJobResponse.setter(Builder::jobStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobStatus").build()}).build();
    private static final SdkField<String> JOB_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("jobRoleArn").getter(DescribeBulkImportJobResponse.getter(DescribeBulkImportJobResponse::jobRoleArn)).setter(DescribeBulkImportJobResponse.setter(Builder::jobRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobRoleArn").build()}).build();
    private static final SdkField<List<File>> FILES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("files").getter(DescribeBulkImportJobResponse.getter(DescribeBulkImportJobResponse::files)).setter(DescribeBulkImportJobResponse.setter(Builder::files)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("files").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(File::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<ErrorReportLocation> ERROR_REPORT_LOCATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("errorReportLocation").getter(DescribeBulkImportJobResponse.getter(DescribeBulkImportJobResponse::errorReportLocation)).setter(DescribeBulkImportJobResponse.setter(Builder::errorReportLocation)).constructor(ErrorReportLocation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errorReportLocation").build()}).build();
    private static final SdkField<JobConfiguration> JOB_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("jobConfiguration").getter(DescribeBulkImportJobResponse.getter(DescribeBulkImportJobResponse::jobConfiguration)).setter(DescribeBulkImportJobResponse.setter(Builder::jobConfiguration)).constructor(JobConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobConfiguration").build()}).build();
    private static final SdkField<Instant> JOB_CREATION_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("jobCreationDate").getter(DescribeBulkImportJobResponse.getter(DescribeBulkImportJobResponse::jobCreationDate)).setter(DescribeBulkImportJobResponse.setter(Builder::jobCreationDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobCreationDate").build()}).build();
    private static final SdkField<Instant> JOB_LAST_UPDATE_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("jobLastUpdateDate").getter(DescribeBulkImportJobResponse.getter(DescribeBulkImportJobResponse::jobLastUpdateDate)).setter(DescribeBulkImportJobResponse.setter(Builder::jobLastUpdateDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobLastUpdateDate").build()}).build();
    private static final SdkField<Boolean> ADAPTIVE_INGESTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("adaptiveIngestion").getter(DescribeBulkImportJobResponse.getter(DescribeBulkImportJobResponse::adaptiveIngestion)).setter(DescribeBulkImportJobResponse.setter(Builder::adaptiveIngestion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("adaptiveIngestion").build()}).build();
    private static final SdkField<Boolean> DELETE_FILES_AFTER_IMPORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("deleteFilesAfterImport").getter(DescribeBulkImportJobResponse.getter(DescribeBulkImportJobResponse::deleteFilesAfterImport)).setter(DescribeBulkImportJobResponse.setter(Builder::deleteFilesAfterImport)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deleteFilesAfterImport").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOB_ID_FIELD, JOB_NAME_FIELD, JOB_STATUS_FIELD, JOB_ROLE_ARN_FIELD, FILES_FIELD, ERROR_REPORT_LOCATION_FIELD, JOB_CONFIGURATION_FIELD, JOB_CREATION_DATE_FIELD, JOB_LAST_UPDATE_DATE_FIELD, ADAPTIVE_INGESTION_FIELD, DELETE_FILES_AFTER_IMPORT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeBulkImportJobResponse.memberNameToFieldInitializer();
    private final String jobId;
    private final String jobName;
    private final String jobStatus;
    private final String jobRoleArn;
    private final List<File> files;
    private final ErrorReportLocation errorReportLocation;
    private final JobConfiguration jobConfiguration;
    private final Instant jobCreationDate;
    private final Instant jobLastUpdateDate;
    private final Boolean adaptiveIngestion;
    private final Boolean deleteFilesAfterImport;

    private DescribeBulkImportJobResponse(BuilderImpl builder) {
        super(builder);
        this.jobId = builder.jobId;
        this.jobName = builder.jobName;
        this.jobStatus = builder.jobStatus;
        this.jobRoleArn = builder.jobRoleArn;
        this.files = builder.files;
        this.errorReportLocation = builder.errorReportLocation;
        this.jobConfiguration = builder.jobConfiguration;
        this.jobCreationDate = builder.jobCreationDate;
        this.jobLastUpdateDate = builder.jobLastUpdateDate;
        this.adaptiveIngestion = builder.adaptiveIngestion;
        this.deleteFilesAfterImport = builder.deleteFilesAfterImport;
    }

    public final String jobId() {
        return this.jobId;
    }

    public final String jobName() {
        return this.jobName;
    }

    public final JobStatus jobStatus() {
        return JobStatus.fromValue(this.jobStatus);
    }

    public final String jobStatusAsString() {
        return this.jobStatus;
    }

    public final String jobRoleArn() {
        return this.jobRoleArn;
    }

    public final boolean hasFiles() {
        return this.files != null && !(this.files instanceof SdkAutoConstructList);
    }

    public final List<File> files() {
        return this.files;
    }

    public final ErrorReportLocation errorReportLocation() {
        return this.errorReportLocation;
    }

    public final JobConfiguration jobConfiguration() {
        return this.jobConfiguration;
    }

    public final Instant jobCreationDate() {
        return this.jobCreationDate;
    }

    public final Instant jobLastUpdateDate() {
        return this.jobLastUpdateDate;
    }

    public final Boolean adaptiveIngestion() {
        return this.adaptiveIngestion;
    }

    public final Boolean deleteFilesAfterImport() {
        return this.deleteFilesAfterImport;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.jobId());
        hashCode = 31 * hashCode + Objects.hashCode(this.jobName());
        hashCode = 31 * hashCode + Objects.hashCode(this.jobStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.jobRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFiles() ? this.files() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.errorReportLocation());
        hashCode = 31 * hashCode + Objects.hashCode(this.jobConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.jobCreationDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.jobLastUpdateDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.adaptiveIngestion());
        hashCode = 31 * hashCode + Objects.hashCode(this.deleteFilesAfterImport());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeBulkImportJobResponse)) {
            return false;
        }
        DescribeBulkImportJobResponse other = (DescribeBulkImportJobResponse)((Object)obj);
        return Objects.equals(this.jobId(), other.jobId()) && Objects.equals(this.jobName(), other.jobName()) && Objects.equals(this.jobStatusAsString(), other.jobStatusAsString()) && Objects.equals(this.jobRoleArn(), other.jobRoleArn()) && this.hasFiles() == other.hasFiles() && Objects.equals(this.files(), other.files()) && Objects.equals(this.errorReportLocation(), other.errorReportLocation()) && Objects.equals(this.jobConfiguration(), other.jobConfiguration()) && Objects.equals(this.jobCreationDate(), other.jobCreationDate()) && Objects.equals(this.jobLastUpdateDate(), other.jobLastUpdateDate()) && Objects.equals(this.adaptiveIngestion(), other.adaptiveIngestion()) && Objects.equals(this.deleteFilesAfterImport(), other.deleteFilesAfterImport());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeBulkImportJobResponse").add("JobId", (Object)this.jobId()).add("JobName", (Object)this.jobName()).add("JobStatus", (Object)this.jobStatusAsString()).add("JobRoleArn", (Object)this.jobRoleArn()).add("Files", this.hasFiles() ? this.files() : null).add("ErrorReportLocation", (Object)this.errorReportLocation()).add("JobConfiguration", (Object)this.jobConfiguration()).add("JobCreationDate", (Object)this.jobCreationDate()).add("JobLastUpdateDate", (Object)this.jobLastUpdateDate()).add("AdaptiveIngestion", (Object)this.adaptiveIngestion()).add("DeleteFilesAfterImport", (Object)this.deleteFilesAfterImport()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "jobId": {
                return Optional.ofNullable(clazz.cast(this.jobId()));
            }
            case "jobName": {
                return Optional.ofNullable(clazz.cast(this.jobName()));
            }
            case "jobStatus": {
                return Optional.ofNullable(clazz.cast(this.jobStatusAsString()));
            }
            case "jobRoleArn": {
                return Optional.ofNullable(clazz.cast(this.jobRoleArn()));
            }
            case "files": {
                return Optional.ofNullable(clazz.cast(this.files()));
            }
            case "errorReportLocation": {
                return Optional.ofNullable(clazz.cast(this.errorReportLocation()));
            }
            case "jobConfiguration": {
                return Optional.ofNullable(clazz.cast(this.jobConfiguration()));
            }
            case "jobCreationDate": {
                return Optional.ofNullable(clazz.cast(this.jobCreationDate()));
            }
            case "jobLastUpdateDate": {
                return Optional.ofNullable(clazz.cast(this.jobLastUpdateDate()));
            }
            case "adaptiveIngestion": {
                return Optional.ofNullable(clazz.cast(this.adaptiveIngestion()));
            }
            case "deleteFilesAfterImport": {
                return Optional.ofNullable(clazz.cast(this.deleteFilesAfterImport()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("jobId", JOB_ID_FIELD);
        map.put("jobName", JOB_NAME_FIELD);
        map.put("jobStatus", JOB_STATUS_FIELD);
        map.put("jobRoleArn", JOB_ROLE_ARN_FIELD);
        map.put("files", FILES_FIELD);
        map.put("errorReportLocation", ERROR_REPORT_LOCATION_FIELD);
        map.put("jobConfiguration", JOB_CONFIGURATION_FIELD);
        map.put("jobCreationDate", JOB_CREATION_DATE_FIELD);
        map.put("jobLastUpdateDate", JOB_LAST_UPDATE_DATE_FIELD);
        map.put("adaptiveIngestion", ADAPTIVE_INGESTION_FIELD);
        map.put("deleteFilesAfterImport", DELETE_FILES_AFTER_IMPORT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeBulkImportJobResponse, T> g) {
        return obj -> g.apply((DescribeBulkImportJobResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IoTSiteWiseResponse.BuilderImpl
    implements Builder {
        private String jobId;
        private String jobName;
        private String jobStatus;
        private String jobRoleArn;
        private List<File> files = DefaultSdkAutoConstructList.getInstance();
        private ErrorReportLocation errorReportLocation;
        private JobConfiguration jobConfiguration;
        private Instant jobCreationDate;
        private Instant jobLastUpdateDate;
        private Boolean adaptiveIngestion;
        private Boolean deleteFilesAfterImport;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeBulkImportJobResponse model) {
            super(model);
            this.jobId(model.jobId);
            this.jobName(model.jobName);
            this.jobStatus(model.jobStatus);
            this.jobRoleArn(model.jobRoleArn);
            this.files(model.files);
            this.errorReportLocation(model.errorReportLocation);
            this.jobConfiguration(model.jobConfiguration);
            this.jobCreationDate(model.jobCreationDate);
            this.jobLastUpdateDate(model.jobLastUpdateDate);
            this.adaptiveIngestion(model.adaptiveIngestion);
            this.deleteFilesAfterImport(model.deleteFilesAfterImport);
        }

        public final String getJobId() {
            return this.jobId;
        }

        public final void setJobId(String jobId) {
            this.jobId = jobId;
        }

        @Override
        public final Builder jobId(String jobId) {
            this.jobId = jobId;
            return this;
        }

        public final String getJobName() {
            return this.jobName;
        }

        public final void setJobName(String jobName) {
            this.jobName = jobName;
        }

        @Override
        public final Builder jobName(String jobName) {
            this.jobName = jobName;
            return this;
        }

        public final String getJobStatus() {
            return this.jobStatus;
        }

        public final void setJobStatus(String jobStatus) {
            this.jobStatus = jobStatus;
        }

        @Override
        public final Builder jobStatus(String jobStatus) {
            this.jobStatus = jobStatus;
            return this;
        }

        @Override
        public final Builder jobStatus(JobStatus jobStatus) {
            this.jobStatus(jobStatus == null ? null : jobStatus.toString());
            return this;
        }

        public final String getJobRoleArn() {
            return this.jobRoleArn;
        }

        public final void setJobRoleArn(String jobRoleArn) {
            this.jobRoleArn = jobRoleArn;
        }

        @Override
        public final Builder jobRoleArn(String jobRoleArn) {
            this.jobRoleArn = jobRoleArn;
            return this;
        }

        public final List<File.Builder> getFiles() {
            List<File.Builder> result = FilesCopier.copyToBuilder(this.files);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFiles(Collection<File.BuilderImpl> files) {
            this.files = FilesCopier.copyFromBuilder(files);
        }

        @Override
        public final Builder files(Collection<File> files) {
            this.files = FilesCopier.copy(files);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder files(File ... files) {
            this.files(Arrays.asList(files));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder files(Consumer<File.Builder> ... files) {
            this.files(Stream.of(files).map(c -> (File)((File.Builder)File.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final ErrorReportLocation.Builder getErrorReportLocation() {
            return this.errorReportLocation != null ? this.errorReportLocation.toBuilder() : null;
        }

        public final void setErrorReportLocation(ErrorReportLocation.BuilderImpl errorReportLocation) {
            this.errorReportLocation = errorReportLocation != null ? errorReportLocation.build() : null;
        }

        @Override
        public final Builder errorReportLocation(ErrorReportLocation errorReportLocation) {
            this.errorReportLocation = errorReportLocation;
            return this;
        }

        public final JobConfiguration.Builder getJobConfiguration() {
            return this.jobConfiguration != null ? this.jobConfiguration.toBuilder() : null;
        }

        public final void setJobConfiguration(JobConfiguration.BuilderImpl jobConfiguration) {
            this.jobConfiguration = jobConfiguration != null ? jobConfiguration.build() : null;
        }

        @Override
        public final Builder jobConfiguration(JobConfiguration jobConfiguration) {
            this.jobConfiguration = jobConfiguration;
            return this;
        }

        public final Instant getJobCreationDate() {
            return this.jobCreationDate;
        }

        public final void setJobCreationDate(Instant jobCreationDate) {
            this.jobCreationDate = jobCreationDate;
        }

        @Override
        public final Builder jobCreationDate(Instant jobCreationDate) {
            this.jobCreationDate = jobCreationDate;
            return this;
        }

        public final Instant getJobLastUpdateDate() {
            return this.jobLastUpdateDate;
        }

        public final void setJobLastUpdateDate(Instant jobLastUpdateDate) {
            this.jobLastUpdateDate = jobLastUpdateDate;
        }

        @Override
        public final Builder jobLastUpdateDate(Instant jobLastUpdateDate) {
            this.jobLastUpdateDate = jobLastUpdateDate;
            return this;
        }

        public final Boolean getAdaptiveIngestion() {
            return this.adaptiveIngestion;
        }

        public final void setAdaptiveIngestion(Boolean adaptiveIngestion) {
            this.adaptiveIngestion = adaptiveIngestion;
        }

        @Override
        public final Builder adaptiveIngestion(Boolean adaptiveIngestion) {
            this.adaptiveIngestion = adaptiveIngestion;
            return this;
        }

        public final Boolean getDeleteFilesAfterImport() {
            return this.deleteFilesAfterImport;
        }

        public final void setDeleteFilesAfterImport(Boolean deleteFilesAfterImport) {
            this.deleteFilesAfterImport = deleteFilesAfterImport;
        }

        @Override
        public final Builder deleteFilesAfterImport(Boolean deleteFilesAfterImport) {
            this.deleteFilesAfterImport = deleteFilesAfterImport;
            return this;
        }

        @Override
        public DescribeBulkImportJobResponse build() {
            return new DescribeBulkImportJobResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends IoTSiteWiseResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeBulkImportJobResponse> {
        public Builder jobId(String var1);

        public Builder jobName(String var1);

        public Builder jobStatus(String var1);

        public Builder jobStatus(JobStatus var1);

        public Builder jobRoleArn(String var1);

        public Builder files(Collection<File> var1);

        public Builder files(File ... var1);

        public Builder files(Consumer<File.Builder> ... var1);

        public Builder errorReportLocation(ErrorReportLocation var1);

        default public Builder errorReportLocation(Consumer<ErrorReportLocation.Builder> errorReportLocation) {
            return this.errorReportLocation((ErrorReportLocation)((ErrorReportLocation.Builder)ErrorReportLocation.builder().applyMutation(errorReportLocation)).build());
        }

        public Builder jobConfiguration(JobConfiguration var1);

        default public Builder jobConfiguration(Consumer<JobConfiguration.Builder> jobConfiguration) {
            return this.jobConfiguration((JobConfiguration)((JobConfiguration.Builder)JobConfiguration.builder().applyMutation(jobConfiguration)).build());
        }

        public Builder jobCreationDate(Instant var1);

        public Builder jobLastUpdateDate(Instant var1);

        public Builder adaptiveIngestion(Boolean var1);

        public Builder deleteFilesAfterImport(Boolean var1);
    }
}

