/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotsitewise.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum RawValueType {
    D("D"),
    B("B"),
    S("S"),
    I("I"),
    U("U"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, RawValueType> VALUE_MAP;
    private final String value;

    private RawValueType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static RawValueType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<RawValueType> knownValues() {
        EnumSet<RawValueType> knownValues = EnumSet.allOf(RawValueType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(RawValueType.class, RawValueType::toString);
    }
}

