/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotsitewise.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.iotsitewise.model.AssetPropertyPathCopier;
import software.amazon.awssdk.services.iotsitewise.model.AssetPropertyPathSegment;
import software.amazon.awssdk.services.iotsitewise.model.PropertyNotification;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AssetPropertySummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AssetPropertySummary> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("id").getter(AssetPropertySummary.getter(AssetPropertySummary::id)).setter(AssetPropertySummary.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()}).build();
    private static final SdkField<String> ALIAS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("alias").getter(AssetPropertySummary.getter(AssetPropertySummary::alias)).setter(AssetPropertySummary.setter(Builder::alias)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("alias").build()}).build();
    private static final SdkField<String> UNIT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("unit").getter(AssetPropertySummary.getter(AssetPropertySummary::unit)).setter(AssetPropertySummary.setter(Builder::unit)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("unit").build()}).build();
    private static final SdkField<PropertyNotification> NOTIFICATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("notification").getter(AssetPropertySummary.getter(AssetPropertySummary::notification)).setter(AssetPropertySummary.setter(Builder::notification)).constructor(PropertyNotification::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("notification").build()}).build();
    private static final SdkField<String> ASSET_COMPOSITE_MODEL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("assetCompositeModelId").getter(AssetPropertySummary.getter(AssetPropertySummary::assetCompositeModelId)).setter(AssetPropertySummary.setter(Builder::assetCompositeModelId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assetCompositeModelId").build()}).build();
    private static final SdkField<List<AssetPropertyPathSegment>> PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("path").getter(AssetPropertySummary.getter(AssetPropertySummary::path)).setter(AssetPropertySummary.setter(Builder::path)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("path").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AssetPropertyPathSegment::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> EXTERNAL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("externalId").getter(AssetPropertySummary.getter(AssetPropertySummary::externalId)).setter(AssetPropertySummary.setter(Builder::externalId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("externalId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, ALIAS_FIELD, UNIT_FIELD, NOTIFICATION_FIELD, ASSET_COMPOSITE_MODEL_ID_FIELD, PATH_FIELD, EXTERNAL_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AssetPropertySummary.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String id;
    private final String alias;
    private final String unit;
    private final PropertyNotification notification;
    private final String assetCompositeModelId;
    private final List<AssetPropertyPathSegment> path;
    private final String externalId;

    private AssetPropertySummary(BuilderImpl builder) {
        this.id = builder.id;
        this.alias = builder.alias;
        this.unit = builder.unit;
        this.notification = builder.notification;
        this.assetCompositeModelId = builder.assetCompositeModelId;
        this.path = builder.path;
        this.externalId = builder.externalId;
    }

    public final String id() {
        return this.id;
    }

    public final String alias() {
        return this.alias;
    }

    public final String unit() {
        return this.unit;
    }

    public final PropertyNotification notification() {
        return this.notification;
    }

    public final String assetCompositeModelId() {
        return this.assetCompositeModelId;
    }

    public final boolean hasPath() {
        return this.path != null && !(this.path instanceof SdkAutoConstructList);
    }

    public final List<AssetPropertyPathSegment> path() {
        return this.path;
    }

    public final String externalId() {
        return this.externalId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.alias());
        hashCode = 31 * hashCode + Objects.hashCode(this.unit());
        hashCode = 31 * hashCode + Objects.hashCode(this.notification());
        hashCode = 31 * hashCode + Objects.hashCode(this.assetCompositeModelId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPath() ? this.path() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.externalId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssetPropertySummary)) {
            return false;
        }
        AssetPropertySummary other = (AssetPropertySummary)obj;
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.alias(), other.alias()) && Objects.equals(this.unit(), other.unit()) && Objects.equals(this.notification(), other.notification()) && Objects.equals(this.assetCompositeModelId(), other.assetCompositeModelId()) && this.hasPath() == other.hasPath() && Objects.equals(this.path(), other.path()) && Objects.equals(this.externalId(), other.externalId());
    }

    public final String toString() {
        return ToString.builder((String)"AssetPropertySummary").add("Id", (Object)this.id()).add("Alias", (Object)this.alias()).add("Unit", (Object)this.unit()).add("Notification", (Object)this.notification()).add("AssetCompositeModelId", (Object)this.assetCompositeModelId()).add("Path", this.hasPath() ? this.path() : null).add("ExternalId", (Object)this.externalId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "alias": {
                return Optional.ofNullable(clazz.cast(this.alias()));
            }
            case "unit": {
                return Optional.ofNullable(clazz.cast(this.unit()));
            }
            case "notification": {
                return Optional.ofNullable(clazz.cast(this.notification()));
            }
            case "assetCompositeModelId": {
                return Optional.ofNullable(clazz.cast(this.assetCompositeModelId()));
            }
            case "path": {
                return Optional.ofNullable(clazz.cast(this.path()));
            }
            case "externalId": {
                return Optional.ofNullable(clazz.cast(this.externalId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("id", ID_FIELD);
        map.put("alias", ALIAS_FIELD);
        map.put("unit", UNIT_FIELD);
        map.put("notification", NOTIFICATION_FIELD);
        map.put("assetCompositeModelId", ASSET_COMPOSITE_MODEL_ID_FIELD);
        map.put("path", PATH_FIELD);
        map.put("externalId", EXTERNAL_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AssetPropertySummary, T> g) {
        return obj -> g.apply((AssetPropertySummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String id;
        private String alias;
        private String unit;
        private PropertyNotification notification;
        private String assetCompositeModelId;
        private List<AssetPropertyPathSegment> path = DefaultSdkAutoConstructList.getInstance();
        private String externalId;

        private BuilderImpl() {
        }

        private BuilderImpl(AssetPropertySummary model) {
            this.id(model.id);
            this.alias(model.alias);
            this.unit(model.unit);
            this.notification(model.notification);
            this.assetCompositeModelId(model.assetCompositeModelId);
            this.path(model.path);
            this.externalId(model.externalId);
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getAlias() {
            return this.alias;
        }

        public final void setAlias(String alias) {
            this.alias = alias;
        }

        @Override
        public final Builder alias(String alias) {
            this.alias = alias;
            return this;
        }

        public final String getUnit() {
            return this.unit;
        }

        public final void setUnit(String unit) {
            this.unit = unit;
        }

        @Override
        public final Builder unit(String unit) {
            this.unit = unit;
            return this;
        }

        public final PropertyNotification.Builder getNotification() {
            return this.notification != null ? this.notification.toBuilder() : null;
        }

        public final void setNotification(PropertyNotification.BuilderImpl notification) {
            this.notification = notification != null ? notification.build() : null;
        }

        @Override
        public final Builder notification(PropertyNotification notification) {
            this.notification = notification;
            return this;
        }

        public final String getAssetCompositeModelId() {
            return this.assetCompositeModelId;
        }

        public final void setAssetCompositeModelId(String assetCompositeModelId) {
            this.assetCompositeModelId = assetCompositeModelId;
        }

        @Override
        public final Builder assetCompositeModelId(String assetCompositeModelId) {
            this.assetCompositeModelId = assetCompositeModelId;
            return this;
        }

        public final List<AssetPropertyPathSegment.Builder> getPath() {
            List<AssetPropertyPathSegment.Builder> result = AssetPropertyPathCopier.copyToBuilder(this.path);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPath(Collection<AssetPropertyPathSegment.BuilderImpl> path) {
            this.path = AssetPropertyPathCopier.copyFromBuilder(path);
        }

        @Override
        public final Builder path(Collection<AssetPropertyPathSegment> path) {
            this.path = AssetPropertyPathCopier.copy(path);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder path(AssetPropertyPathSegment ... path) {
            this.path(Arrays.asList(path));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder path(Consumer<AssetPropertyPathSegment.Builder> ... path) {
            this.path(Stream.of(path).map(c -> (AssetPropertyPathSegment)((AssetPropertyPathSegment.Builder)AssetPropertyPathSegment.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getExternalId() {
            return this.externalId;
        }

        public final void setExternalId(String externalId) {
            this.externalId = externalId;
        }

        @Override
        public final Builder externalId(String externalId) {
            this.externalId = externalId;
            return this;
        }

        public AssetPropertySummary build() {
            return new AssetPropertySummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AssetPropertySummary> {
        public Builder id(String var1);

        public Builder alias(String var1);

        public Builder unit(String var1);

        public Builder notification(PropertyNotification var1);

        default public Builder notification(Consumer<PropertyNotification.Builder> notification) {
            return this.notification((PropertyNotification)((PropertyNotification.Builder)PropertyNotification.builder().applyMutation(notification)).build());
        }

        public Builder assetCompositeModelId(String var1);

        public Builder path(Collection<AssetPropertyPathSegment> var1);

        public Builder path(AssetPropertyPathSegment ... var1);

        public Builder path(Consumer<AssetPropertyPathSegment.Builder> ... var1);

        public Builder externalId(String var1);
    }
}

