/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotsitewise.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iotsitewise.model.IoTSiteWiseRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class InvokeAssistantRequest
extends IoTSiteWiseRequest
implements ToCopyableBuilder<Builder, InvokeAssistantRequest> {
    private static final SdkField<String> CONVERSATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("conversationId").getter(InvokeAssistantRequest.getter(InvokeAssistantRequest::conversationId)).setter(InvokeAssistantRequest.setter(Builder::conversationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("conversationId").build()}).build();
    private static final SdkField<String> MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("message").getter(InvokeAssistantRequest.getter(InvokeAssistantRequest::message)).setter(InvokeAssistantRequest.setter(Builder::message)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("message").build()}).build();
    private static final SdkField<Boolean> ENABLE_TRACE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("enableTrace").getter(InvokeAssistantRequest.getter(InvokeAssistantRequest::enableTrace)).setter(InvokeAssistantRequest.setter(Builder::enableTrace)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enableTrace").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONVERSATION_ID_FIELD, MESSAGE_FIELD, ENABLE_TRACE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = InvokeAssistantRequest.memberNameToFieldInitializer();
    private final String conversationId;
    private final String message;
    private final Boolean enableTrace;

    private InvokeAssistantRequest(BuilderImpl builder) {
        super(builder);
        this.conversationId = builder.conversationId;
        this.message = builder.message;
        this.enableTrace = builder.enableTrace;
    }

    public final String conversationId() {
        return this.conversationId;
    }

    public final String message() {
        return this.message;
    }

    public final Boolean enableTrace() {
        return this.enableTrace;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.conversationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.message());
        hashCode = 31 * hashCode + Objects.hashCode(this.enableTrace());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InvokeAssistantRequest)) {
            return false;
        }
        InvokeAssistantRequest other = (InvokeAssistantRequest)((Object)obj);
        return Objects.equals(this.conversationId(), other.conversationId()) && Objects.equals(this.message(), other.message()) && Objects.equals(this.enableTrace(), other.enableTrace());
    }

    public final String toString() {
        return ToString.builder((String)"InvokeAssistantRequest").add("ConversationId", (Object)this.conversationId()).add("Message", (Object)(this.message() == null ? null : "*** Sensitive Data Redacted ***")).add("EnableTrace", (Object)this.enableTrace()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "conversationId": {
                return Optional.ofNullable(clazz.cast(this.conversationId()));
            }
            case "message": {
                return Optional.ofNullable(clazz.cast(this.message()));
            }
            case "enableTrace": {
                return Optional.ofNullable(clazz.cast(this.enableTrace()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("conversationId", CONVERSATION_ID_FIELD);
        map.put("message", MESSAGE_FIELD);
        map.put("enableTrace", ENABLE_TRACE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<InvokeAssistantRequest, T> g) {
        return obj -> g.apply((InvokeAssistantRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IoTSiteWiseRequest.BuilderImpl
    implements Builder {
        private String conversationId;
        private String message;
        private Boolean enableTrace;

        private BuilderImpl() {
        }

        private BuilderImpl(InvokeAssistantRequest model) {
            super(model);
            this.conversationId(model.conversationId);
            this.message(model.message);
            this.enableTrace(model.enableTrace);
        }

        public final String getConversationId() {
            return this.conversationId;
        }

        public final void setConversationId(String conversationId) {
            this.conversationId = conversationId;
        }

        @Override
        public final Builder conversationId(String conversationId) {
            this.conversationId = conversationId;
            return this;
        }

        public final String getMessage() {
            return this.message;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public final Boolean getEnableTrace() {
            return this.enableTrace;
        }

        public final void setEnableTrace(Boolean enableTrace) {
            this.enableTrace = enableTrace;
        }

        @Override
        public final Builder enableTrace(Boolean enableTrace) {
            this.enableTrace = enableTrace;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public InvokeAssistantRequest build() {
            return new InvokeAssistantRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends IoTSiteWiseRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, InvokeAssistantRequest> {
        public Builder conversationId(String var1);

        public Builder message(String var1);

        public Builder enableTrace(Boolean var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

