/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotsitewise.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.iotsitewise.model.BatchGetAssetPropertyValueErrorEntriesCopier;
import software.amazon.awssdk.services.iotsitewise.model.BatchGetAssetPropertyValueErrorEntry;
import software.amazon.awssdk.services.iotsitewise.model.BatchGetAssetPropertyValueSkippedEntriesCopier;
import software.amazon.awssdk.services.iotsitewise.model.BatchGetAssetPropertyValueSkippedEntry;
import software.amazon.awssdk.services.iotsitewise.model.BatchGetAssetPropertyValueSuccessEntriesCopier;
import software.amazon.awssdk.services.iotsitewise.model.BatchGetAssetPropertyValueSuccessEntry;
import software.amazon.awssdk.services.iotsitewise.model.IoTSiteWiseResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchGetAssetPropertyValueResponse
extends IoTSiteWiseResponse
implements ToCopyableBuilder<Builder, BatchGetAssetPropertyValueResponse> {
    private static final SdkField<List<BatchGetAssetPropertyValueErrorEntry>> ERROR_ENTRIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("errorEntries").getter(BatchGetAssetPropertyValueResponse.getter(BatchGetAssetPropertyValueResponse::errorEntries)).setter(BatchGetAssetPropertyValueResponse.setter(Builder::errorEntries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errorEntries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(BatchGetAssetPropertyValueErrorEntry::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<BatchGetAssetPropertyValueSuccessEntry>> SUCCESS_ENTRIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("successEntries").getter(BatchGetAssetPropertyValueResponse.getter(BatchGetAssetPropertyValueResponse::successEntries)).setter(BatchGetAssetPropertyValueResponse.setter(Builder::successEntries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("successEntries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(BatchGetAssetPropertyValueSuccessEntry::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<BatchGetAssetPropertyValueSkippedEntry>> SKIPPED_ENTRIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("skippedEntries").getter(BatchGetAssetPropertyValueResponse.getter(BatchGetAssetPropertyValueResponse::skippedEntries)).setter(BatchGetAssetPropertyValueResponse.setter(Builder::skippedEntries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("skippedEntries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(BatchGetAssetPropertyValueSkippedEntry::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(BatchGetAssetPropertyValueResponse.getter(BatchGetAssetPropertyValueResponse::nextToken)).setter(BatchGetAssetPropertyValueResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ERROR_ENTRIES_FIELD, SUCCESS_ENTRIES_FIELD, SKIPPED_ENTRIES_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("errorEntries", ERROR_ENTRIES_FIELD);
            this.put("successEntries", SUCCESS_ENTRIES_FIELD);
            this.put("skippedEntries", SKIPPED_ENTRIES_FIELD);
            this.put("nextToken", NEXT_TOKEN_FIELD);
        }
    });
    private final List<BatchGetAssetPropertyValueErrorEntry> errorEntries;
    private final List<BatchGetAssetPropertyValueSuccessEntry> successEntries;
    private final List<BatchGetAssetPropertyValueSkippedEntry> skippedEntries;
    private final String nextToken;

    private BatchGetAssetPropertyValueResponse(BuilderImpl builder) {
        super(builder);
        this.errorEntries = builder.errorEntries;
        this.successEntries = builder.successEntries;
        this.skippedEntries = builder.skippedEntries;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasErrorEntries() {
        return this.errorEntries != null && !(this.errorEntries instanceof SdkAutoConstructList);
    }

    public final List<BatchGetAssetPropertyValueErrorEntry> errorEntries() {
        return this.errorEntries;
    }

    public final boolean hasSuccessEntries() {
        return this.successEntries != null && !(this.successEntries instanceof SdkAutoConstructList);
    }

    public final List<BatchGetAssetPropertyValueSuccessEntry> successEntries() {
        return this.successEntries;
    }

    public final boolean hasSkippedEntries() {
        return this.skippedEntries != null && !(this.skippedEntries instanceof SdkAutoConstructList);
    }

    public final List<BatchGetAssetPropertyValueSkippedEntry> skippedEntries() {
        return this.skippedEntries;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasErrorEntries() ? this.errorEntries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSuccessEntries() ? this.successEntries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSkippedEntries() ? this.skippedEntries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetAssetPropertyValueResponse)) {
            return false;
        }
        BatchGetAssetPropertyValueResponse other = (BatchGetAssetPropertyValueResponse)((Object)obj);
        return this.hasErrorEntries() == other.hasErrorEntries() && Objects.equals(this.errorEntries(), other.errorEntries()) && this.hasSuccessEntries() == other.hasSuccessEntries() && Objects.equals(this.successEntries(), other.successEntries()) && this.hasSkippedEntries() == other.hasSkippedEntries() && Objects.equals(this.skippedEntries(), other.skippedEntries()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"BatchGetAssetPropertyValueResponse").add("ErrorEntries", this.hasErrorEntries() ? this.errorEntries() : null).add("SuccessEntries", this.hasSuccessEntries() ? this.successEntries() : null).add("SkippedEntries", this.hasSkippedEntries() ? this.skippedEntries() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "errorEntries": {
                return Optional.ofNullable(clazz.cast(this.errorEntries()));
            }
            case "successEntries": {
                return Optional.ofNullable(clazz.cast(this.successEntries()));
            }
            case "skippedEntries": {
                return Optional.ofNullable(clazz.cast(this.skippedEntries()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<BatchGetAssetPropertyValueResponse, T> g) {
        return obj -> g.apply((BatchGetAssetPropertyValueResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IoTSiteWiseResponse.BuilderImpl
    implements Builder {
        private List<BatchGetAssetPropertyValueErrorEntry> errorEntries = DefaultSdkAutoConstructList.getInstance();
        private List<BatchGetAssetPropertyValueSuccessEntry> successEntries = DefaultSdkAutoConstructList.getInstance();
        private List<BatchGetAssetPropertyValueSkippedEntry> skippedEntries = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchGetAssetPropertyValueResponse model) {
            super(model);
            this.errorEntries(model.errorEntries);
            this.successEntries(model.successEntries);
            this.skippedEntries(model.skippedEntries);
            this.nextToken(model.nextToken);
        }

        public final List<BatchGetAssetPropertyValueErrorEntry.Builder> getErrorEntries() {
            List<BatchGetAssetPropertyValueErrorEntry.Builder> result = BatchGetAssetPropertyValueErrorEntriesCopier.copyToBuilder(this.errorEntries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setErrorEntries(Collection<BatchGetAssetPropertyValueErrorEntry.BuilderImpl> errorEntries) {
            this.errorEntries = BatchGetAssetPropertyValueErrorEntriesCopier.copyFromBuilder(errorEntries);
        }

        @Override
        public final Builder errorEntries(Collection<BatchGetAssetPropertyValueErrorEntry> errorEntries) {
            this.errorEntries = BatchGetAssetPropertyValueErrorEntriesCopier.copy(errorEntries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errorEntries(BatchGetAssetPropertyValueErrorEntry ... errorEntries) {
            this.errorEntries(Arrays.asList(errorEntries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errorEntries(Consumer<BatchGetAssetPropertyValueErrorEntry.Builder> ... errorEntries) {
            this.errorEntries(Stream.of(errorEntries).map(c -> (BatchGetAssetPropertyValueErrorEntry)((BatchGetAssetPropertyValueErrorEntry.Builder)BatchGetAssetPropertyValueErrorEntry.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<BatchGetAssetPropertyValueSuccessEntry.Builder> getSuccessEntries() {
            List<BatchGetAssetPropertyValueSuccessEntry.Builder> result = BatchGetAssetPropertyValueSuccessEntriesCopier.copyToBuilder(this.successEntries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSuccessEntries(Collection<BatchGetAssetPropertyValueSuccessEntry.BuilderImpl> successEntries) {
            this.successEntries = BatchGetAssetPropertyValueSuccessEntriesCopier.copyFromBuilder(successEntries);
        }

        @Override
        public final Builder successEntries(Collection<BatchGetAssetPropertyValueSuccessEntry> successEntries) {
            this.successEntries = BatchGetAssetPropertyValueSuccessEntriesCopier.copy(successEntries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder successEntries(BatchGetAssetPropertyValueSuccessEntry ... successEntries) {
            this.successEntries(Arrays.asList(successEntries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder successEntries(Consumer<BatchGetAssetPropertyValueSuccessEntry.Builder> ... successEntries) {
            this.successEntries(Stream.of(successEntries).map(c -> (BatchGetAssetPropertyValueSuccessEntry)((BatchGetAssetPropertyValueSuccessEntry.Builder)BatchGetAssetPropertyValueSuccessEntry.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<BatchGetAssetPropertyValueSkippedEntry.Builder> getSkippedEntries() {
            List<BatchGetAssetPropertyValueSkippedEntry.Builder> result = BatchGetAssetPropertyValueSkippedEntriesCopier.copyToBuilder(this.skippedEntries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSkippedEntries(Collection<BatchGetAssetPropertyValueSkippedEntry.BuilderImpl> skippedEntries) {
            this.skippedEntries = BatchGetAssetPropertyValueSkippedEntriesCopier.copyFromBuilder(skippedEntries);
        }

        @Override
        public final Builder skippedEntries(Collection<BatchGetAssetPropertyValueSkippedEntry> skippedEntries) {
            this.skippedEntries = BatchGetAssetPropertyValueSkippedEntriesCopier.copy(skippedEntries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder skippedEntries(BatchGetAssetPropertyValueSkippedEntry ... skippedEntries) {
            this.skippedEntries(Arrays.asList(skippedEntries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder skippedEntries(Consumer<BatchGetAssetPropertyValueSkippedEntry.Builder> ... skippedEntries) {
            this.skippedEntries(Stream.of(skippedEntries).map(c -> (BatchGetAssetPropertyValueSkippedEntry)((BatchGetAssetPropertyValueSkippedEntry.Builder)BatchGetAssetPropertyValueSkippedEntry.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public BatchGetAssetPropertyValueResponse build() {
            return new BatchGetAssetPropertyValueResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends IoTSiteWiseResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, BatchGetAssetPropertyValueResponse> {
        public Builder errorEntries(Collection<BatchGetAssetPropertyValueErrorEntry> var1);

        public Builder errorEntries(BatchGetAssetPropertyValueErrorEntry ... var1);

        public Builder errorEntries(Consumer<BatchGetAssetPropertyValueErrorEntry.Builder> ... var1);

        public Builder successEntries(Collection<BatchGetAssetPropertyValueSuccessEntry> var1);

        public Builder successEntries(BatchGetAssetPropertyValueSuccessEntry ... var1);

        public Builder successEntries(Consumer<BatchGetAssetPropertyValueSuccessEntry.Builder> ... var1);

        public Builder skippedEntries(Collection<BatchGetAssetPropertyValueSkippedEntry> var1);

        public Builder skippedEntries(BatchGetAssetPropertyValueSkippedEntry ... var1);

        public Builder skippedEntries(Consumer<BatchGetAssetPropertyValueSkippedEntry.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

