/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotsitewise.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iotsitewise.model.AssetErrorCode;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AssetErrorDetails
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AssetErrorDetails> {
    private static final SdkField<String> ASSET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("assetId").getter(AssetErrorDetails.getter(AssetErrorDetails::assetId)).setter(AssetErrorDetails.setter(Builder::assetId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assetId").build()}).build();
    private static final SdkField<String> CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("code").getter(AssetErrorDetails.getter(AssetErrorDetails::codeAsString)).setter(AssetErrorDetails.setter(Builder::code)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("code").build()}).build();
    private static final SdkField<String> MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("message").getter(AssetErrorDetails.getter(AssetErrorDetails::message)).setter(AssetErrorDetails.setter(Builder::message)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("message").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSET_ID_FIELD, CODE_FIELD, MESSAGE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("assetId", ASSET_ID_FIELD);
            this.put("code", CODE_FIELD);
            this.put("message", MESSAGE_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String assetId;
    private final String code;
    private final String message;

    private AssetErrorDetails(BuilderImpl builder) {
        this.assetId = builder.assetId;
        this.code = builder.code;
        this.message = builder.message;
    }

    public final String assetId() {
        return this.assetId;
    }

    public final AssetErrorCode code() {
        return AssetErrorCode.fromValue(this.code);
    }

    public final String codeAsString() {
        return this.code;
    }

    public final String message() {
        return this.message;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.assetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.codeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.message());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssetErrorDetails)) {
            return false;
        }
        AssetErrorDetails other = (AssetErrorDetails)obj;
        return Objects.equals(this.assetId(), other.assetId()) && Objects.equals(this.codeAsString(), other.codeAsString()) && Objects.equals(this.message(), other.message());
    }

    public final String toString() {
        return ToString.builder((String)"AssetErrorDetails").add("AssetId", (Object)this.assetId()).add("Code", (Object)this.codeAsString()).add("Message", (Object)this.message()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "assetId": {
                return Optional.ofNullable(clazz.cast(this.assetId()));
            }
            case "code": {
                return Optional.ofNullable(clazz.cast(this.codeAsString()));
            }
            case "message": {
                return Optional.ofNullable(clazz.cast(this.message()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<AssetErrorDetails, T> g) {
        return obj -> g.apply((AssetErrorDetails)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String assetId;
        private String code;
        private String message;

        private BuilderImpl() {
        }

        private BuilderImpl(AssetErrorDetails model) {
            this.assetId(model.assetId);
            this.code(model.code);
            this.message(model.message);
        }

        public final String getAssetId() {
            return this.assetId;
        }

        public final void setAssetId(String assetId) {
            this.assetId = assetId;
        }

        @Override
        public final Builder assetId(String assetId) {
            this.assetId = assetId;
            return this;
        }

        public final String getCode() {
            return this.code;
        }

        public final void setCode(String code) {
            this.code = code;
        }

        @Override
        public final Builder code(String code) {
            this.code = code;
            return this;
        }

        @Override
        public final Builder code(AssetErrorCode code) {
            this.code(code == null ? null : code.toString());
            return this;
        }

        public final String getMessage() {
            return this.message;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public AssetErrorDetails build() {
            return new AssetErrorDetails(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AssetErrorDetails> {
        public Builder assetId(String var1);

        public Builder code(String var1);

        public Builder code(AssetErrorCode var1);

        public Builder message(String var1);
    }
}

