/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotsitewise.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iotsitewise.model.AssetModelVersionType;
import software.amazon.awssdk.services.iotsitewise.model.IoTSiteWiseRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeleteAssetModelRequest
extends IoTSiteWiseRequest
implements ToCopyableBuilder<Builder, DeleteAssetModelRequest> {
    private static final SdkField<String> ASSET_MODEL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("assetModelId").getter(DeleteAssetModelRequest.getter(DeleteAssetModelRequest::assetModelId)).setter(DeleteAssetModelRequest.setter(Builder::assetModelId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("assetModelId").build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientToken").getter(DeleteAssetModelRequest.getter(DeleteAssetModelRequest::clientToken)).setter(DeleteAssetModelRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("clientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<String> IF_MATCH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ifMatch").getter(DeleteAssetModelRequest.getter(DeleteAssetModelRequest::ifMatch)).setter(DeleteAssetModelRequest.setter(Builder::ifMatch)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("If-Match").build()}).build();
    private static final SdkField<String> IF_NONE_MATCH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ifNoneMatch").getter(DeleteAssetModelRequest.getter(DeleteAssetModelRequest::ifNoneMatch)).setter(DeleteAssetModelRequest.setter(Builder::ifNoneMatch)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("If-None-Match").build()}).build();
    private static final SdkField<String> MATCH_FOR_VERSION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("matchForVersionType").getter(DeleteAssetModelRequest.getter(DeleteAssetModelRequest::matchForVersionTypeAsString)).setter(DeleteAssetModelRequest.setter(Builder::matchForVersionType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("Match-For-Version-Type").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSET_MODEL_ID_FIELD, CLIENT_TOKEN_FIELD, IF_MATCH_FIELD, IF_NONE_MATCH_FIELD, MATCH_FOR_VERSION_TYPE_FIELD));
    private final String assetModelId;
    private final String clientToken;
    private final String ifMatch;
    private final String ifNoneMatch;
    private final String matchForVersionType;

    private DeleteAssetModelRequest(BuilderImpl builder) {
        super(builder);
        this.assetModelId = builder.assetModelId;
        this.clientToken = builder.clientToken;
        this.ifMatch = builder.ifMatch;
        this.ifNoneMatch = builder.ifNoneMatch;
        this.matchForVersionType = builder.matchForVersionType;
    }

    public final String assetModelId() {
        return this.assetModelId;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final String ifMatch() {
        return this.ifMatch;
    }

    public final String ifNoneMatch() {
        return this.ifNoneMatch;
    }

    public final AssetModelVersionType matchForVersionType() {
        return AssetModelVersionType.fromValue(this.matchForVersionType);
    }

    public final String matchForVersionTypeAsString() {
        return this.matchForVersionType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.assetModelId());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.ifMatch());
        hashCode = 31 * hashCode + Objects.hashCode(this.ifNoneMatch());
        hashCode = 31 * hashCode + Objects.hashCode(this.matchForVersionTypeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteAssetModelRequest)) {
            return false;
        }
        DeleteAssetModelRequest other = (DeleteAssetModelRequest)((Object)obj);
        return Objects.equals(this.assetModelId(), other.assetModelId()) && Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.ifMatch(), other.ifMatch()) && Objects.equals(this.ifNoneMatch(), other.ifNoneMatch()) && Objects.equals(this.matchForVersionTypeAsString(), other.matchForVersionTypeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"DeleteAssetModelRequest").add("AssetModelId", (Object)this.assetModelId()).add("ClientToken", (Object)this.clientToken()).add("IfMatch", (Object)this.ifMatch()).add("IfNoneMatch", (Object)this.ifNoneMatch()).add("MatchForVersionType", (Object)this.matchForVersionTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "assetModelId": {
                return Optional.ofNullable(clazz.cast(this.assetModelId()));
            }
            case "clientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "ifMatch": {
                return Optional.ofNullable(clazz.cast(this.ifMatch()));
            }
            case "ifNoneMatch": {
                return Optional.ofNullable(clazz.cast(this.ifNoneMatch()));
            }
            case "matchForVersionType": {
                return Optional.ofNullable(clazz.cast(this.matchForVersionTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteAssetModelRequest, T> g) {
        return obj -> g.apply((DeleteAssetModelRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IoTSiteWiseRequest.BuilderImpl
    implements Builder {
        private String assetModelId;
        private String clientToken;
        private String ifMatch;
        private String ifNoneMatch;
        private String matchForVersionType;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteAssetModelRequest model) {
            super(model);
            this.assetModelId(model.assetModelId);
            this.clientToken(model.clientToken);
            this.ifMatch(model.ifMatch);
            this.ifNoneMatch(model.ifNoneMatch);
            this.matchForVersionType(model.matchForVersionType);
        }

        public final String getAssetModelId() {
            return this.assetModelId;
        }

        public final void setAssetModelId(String assetModelId) {
            this.assetModelId = assetModelId;
        }

        @Override
        public final Builder assetModelId(String assetModelId) {
            this.assetModelId = assetModelId;
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getIfMatch() {
            return this.ifMatch;
        }

        public final void setIfMatch(String ifMatch) {
            this.ifMatch = ifMatch;
        }

        @Override
        public final Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public final String getIfNoneMatch() {
            return this.ifNoneMatch;
        }

        public final void setIfNoneMatch(String ifNoneMatch) {
            this.ifNoneMatch = ifNoneMatch;
        }

        @Override
        public final Builder ifNoneMatch(String ifNoneMatch) {
            this.ifNoneMatch = ifNoneMatch;
            return this;
        }

        public final String getMatchForVersionType() {
            return this.matchForVersionType;
        }

        public final void setMatchForVersionType(String matchForVersionType) {
            this.matchForVersionType = matchForVersionType;
        }

        @Override
        public final Builder matchForVersionType(String matchForVersionType) {
            this.matchForVersionType = matchForVersionType;
            return this;
        }

        @Override
        public final Builder matchForVersionType(AssetModelVersionType matchForVersionType) {
            this.matchForVersionType(matchForVersionType == null ? null : matchForVersionType.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteAssetModelRequest build() {
            return new DeleteAssetModelRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends IoTSiteWiseRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DeleteAssetModelRequest> {
        public Builder assetModelId(String var1);

        public Builder clientToken(String var1);

        public Builder ifMatch(String var1);

        public Builder ifNoneMatch(String var1);

        public Builder matchForVersionType(String var1);

        public Builder matchForVersionType(AssetModelVersionType var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

