/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotsitewise.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.iotsitewise.IoTSiteWiseAsyncClient;
import software.amazon.awssdk.services.iotsitewise.internal.UserAgentUtils;
import software.amazon.awssdk.services.iotsitewise.model.BatchGetAssetPropertyValueRequest;
import software.amazon.awssdk.services.iotsitewise.model.BatchGetAssetPropertyValueResponse;

public class BatchGetAssetPropertyValuePublisher
implements SdkPublisher<BatchGetAssetPropertyValueResponse> {
    private final IoTSiteWiseAsyncClient client;
    private final BatchGetAssetPropertyValueRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public BatchGetAssetPropertyValuePublisher(IoTSiteWiseAsyncClient client, BatchGetAssetPropertyValueRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private BatchGetAssetPropertyValuePublisher(IoTSiteWiseAsyncClient client, BatchGetAssetPropertyValueRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new BatchGetAssetPropertyValueResponseFetcher();
    }

    public void subscribe(Subscriber<? super BatchGetAssetPropertyValueResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class BatchGetAssetPropertyValueResponseFetcher
    implements AsyncPageFetcher<BatchGetAssetPropertyValueResponse> {
        private BatchGetAssetPropertyValueResponseFetcher() {
        }

        public boolean hasNextPage(BatchGetAssetPropertyValueResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<BatchGetAssetPropertyValueResponse> nextPage(BatchGetAssetPropertyValueResponse previousPage) {
            if (previousPage == null) {
                return BatchGetAssetPropertyValuePublisher.this.client.batchGetAssetPropertyValue(BatchGetAssetPropertyValuePublisher.this.firstRequest);
            }
            return BatchGetAssetPropertyValuePublisher.this.client.batchGetAssetPropertyValue((BatchGetAssetPropertyValueRequest)((Object)BatchGetAssetPropertyValuePublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

