/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotsitewise.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.iotsitewise.IoTSiteWiseClient;
import software.amazon.awssdk.services.iotsitewise.internal.UserAgentUtils;
import software.amazon.awssdk.services.iotsitewise.model.JobSummary;
import software.amazon.awssdk.services.iotsitewise.model.ListBulkImportJobsRequest;
import software.amazon.awssdk.services.iotsitewise.model.ListBulkImportJobsResponse;

public class ListBulkImportJobsIterable
implements SdkIterable<ListBulkImportJobsResponse> {
    private final IoTSiteWiseClient client;
    private final ListBulkImportJobsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListBulkImportJobsIterable(IoTSiteWiseClient client, ListBulkImportJobsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListBulkImportJobsResponseFetcher();
    }

    public Iterator<ListBulkImportJobsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<JobSummary> jobSummaries() {
        Function<ListBulkImportJobsResponse, Iterator> getIterator = response -> {
            if (response != null && response.jobSummaries() != null) {
                return response.jobSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListBulkImportJobsResponseFetcher
    implements SyncPageFetcher<ListBulkImportJobsResponse> {
        private ListBulkImportJobsResponseFetcher() {
        }

        public boolean hasNextPage(ListBulkImportJobsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListBulkImportJobsResponse nextPage(ListBulkImportJobsResponse previousPage) {
            if (previousPage == null) {
                return ListBulkImportJobsIterable.this.client.listBulkImportJobs(ListBulkImportJobsIterable.this.firstRequest);
            }
            return ListBulkImportJobsIterable.this.client.listBulkImportJobs((ListBulkImportJobsRequest)((Object)ListBulkImportJobsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

