/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotsitewise.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.iotsitewise.model.DatumListCopier;
import software.amazon.awssdk.services.iotsitewise.model.Row;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Datum
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Datum> {
    private static final SdkField<String> SCALAR_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("scalarValue").getter(Datum.getter(Datum::scalarValue)).setter(Datum.setter(Builder::scalarValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scalarValue").build()}).build();
    private static final SdkField<List<Datum>> ARRAY_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("arrayValue").getter(Datum.getter(Datum::arrayValue)).setter(Datum.setter(Builder::arrayValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arrayValue").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Datum::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Row> ROW_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("rowValue").getter(Datum.getter(Datum::rowValue)).setter(Datum.setter(Builder::rowValue)).constructor(Row::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rowValue").build()}).build();
    private static final SdkField<Boolean> NULL_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("nullValue").getter(Datum.getter(Datum::nullValue)).setter(Datum.setter(Builder::nullValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nullValue").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SCALAR_VALUE_FIELD, ARRAY_VALUE_FIELD, ROW_VALUE_FIELD, NULL_VALUE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String scalarValue;
    private final List<Datum> arrayValue;
    private final Row rowValue;
    private final Boolean nullValue;

    private Datum(BuilderImpl builder) {
        this.scalarValue = builder.scalarValue;
        this.arrayValue = builder.arrayValue;
        this.rowValue = builder.rowValue;
        this.nullValue = builder.nullValue;
    }

    public final String scalarValue() {
        return this.scalarValue;
    }

    public final boolean hasArrayValue() {
        return this.arrayValue != null && !(this.arrayValue instanceof SdkAutoConstructList);
    }

    public final List<Datum> arrayValue() {
        return this.arrayValue;
    }

    public final Row rowValue() {
        return this.rowValue;
    }

    public final Boolean nullValue() {
        return this.nullValue;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.scalarValue());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasArrayValue() ? this.arrayValue() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.rowValue());
        hashCode = 31 * hashCode + Objects.hashCode(this.nullValue());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Datum)) {
            return false;
        }
        Datum other = (Datum)obj;
        return Objects.equals(this.scalarValue(), other.scalarValue()) && this.hasArrayValue() == other.hasArrayValue() && Objects.equals(this.arrayValue(), other.arrayValue()) && Objects.equals(this.rowValue(), other.rowValue()) && Objects.equals(this.nullValue(), other.nullValue());
    }

    public final String toString() {
        return ToString.builder((String)"Datum").add("ScalarValue", (Object)this.scalarValue()).add("ArrayValue", this.hasArrayValue() ? this.arrayValue() : null).add("RowValue", (Object)this.rowValue()).add("NullValue", (Object)this.nullValue()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "scalarValue": {
                return Optional.ofNullable(clazz.cast(this.scalarValue()));
            }
            case "arrayValue": {
                return Optional.ofNullable(clazz.cast(this.arrayValue()));
            }
            case "rowValue": {
                return Optional.ofNullable(clazz.cast(this.rowValue()));
            }
            case "nullValue": {
                return Optional.ofNullable(clazz.cast(this.nullValue()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Datum, T> g) {
        return obj -> g.apply((Datum)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String scalarValue;
        private List<Datum> arrayValue = DefaultSdkAutoConstructList.getInstance();
        private Row rowValue;
        private Boolean nullValue;

        private BuilderImpl() {
        }

        private BuilderImpl(Datum model) {
            this.scalarValue(model.scalarValue);
            this.arrayValue(model.arrayValue);
            this.rowValue(model.rowValue);
            this.nullValue(model.nullValue);
        }

        public final String getScalarValue() {
            return this.scalarValue;
        }

        public final void setScalarValue(String scalarValue) {
            this.scalarValue = scalarValue;
        }

        @Override
        public final Builder scalarValue(String scalarValue) {
            this.scalarValue = scalarValue;
            return this;
        }

        public final List<Builder> getArrayValue() {
            List<Builder> result = DatumListCopier.copyToBuilder(this.arrayValue);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setArrayValue(Collection<BuilderImpl> arrayValue) {
            this.arrayValue = DatumListCopier.copyFromBuilder(arrayValue);
        }

        @Override
        public final Builder arrayValue(Collection<Datum> arrayValue) {
            this.arrayValue = DatumListCopier.copy(arrayValue);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder arrayValue(Datum ... arrayValue) {
            this.arrayValue(Arrays.asList(arrayValue));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder arrayValue(Consumer<Builder> ... arrayValue) {
            this.arrayValue(Stream.of(arrayValue).map(c -> (Datum)((Builder)Datum.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Row.Builder getRowValue() {
            return this.rowValue != null ? this.rowValue.toBuilder() : null;
        }

        public final void setRowValue(Row.BuilderImpl rowValue) {
            this.rowValue = rowValue != null ? rowValue.build() : null;
        }

        @Override
        public final Builder rowValue(Row rowValue) {
            this.rowValue = rowValue;
            return this;
        }

        public final Boolean getNullValue() {
            return this.nullValue;
        }

        public final void setNullValue(Boolean nullValue) {
            this.nullValue = nullValue;
        }

        @Override
        public final Builder nullValue(Boolean nullValue) {
            this.nullValue = nullValue;
            return this;
        }

        public Datum build() {
            return new Datum(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Datum> {
        public Builder scalarValue(String var1);

        public Builder arrayValue(Collection<Datum> var1);

        public Builder arrayValue(Datum ... var1);

        public Builder arrayValue(Consumer<Builder> ... var1);

        public Builder rowValue(Row var1);

        default public Builder rowValue(Consumer<Row.Builder> rowValue) {
            return this.rowValue((Row)((Row.Builder)Row.builder().applyMutation(rowValue)).build());
        }

        public Builder nullValue(Boolean var1);
    }
}

