/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotsitewise.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains details for a gateway that runs on IoT Greengrass. To create a gateway that runs on IoT Greengrass, you must
 * add the IoT SiteWise connector to a Greengrass group and deploy it. Your Greengrass group must also have permissions
 * to upload data to IoT SiteWise. For more information, see <a
 * href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/gateway-connector.html">Ingesting data using a
 * gateway</a> in the <i>IoT SiteWise User Guide</i>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Greengrass implements SdkPojo, Serializable, ToCopyableBuilder<Greengrass.Builder, Greengrass> {
    private static final SdkField<String> GROUP_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("groupArn").getter(getter(Greengrass::groupArn)).setter(setter(Builder::groupArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("groupArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GROUP_ARN_FIELD));

    private static final long serialVersionUID = 1L;

    private final String groupArn;

    private Greengrass(BuilderImpl builder) {
        this.groupArn = builder.groupArn;
    }

    /**
     * <p>
     * The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the
     * Greengrass group. For more information about how to find a group's ARN, see <a
     * href="https://docs.aws.amazon.com/greengrass/latest/apireference/listgroups-get.html">ListGroups</a> and <a
     * href="https://docs.aws.amazon.com/greengrass/latest/apireference/getgroup-get.html">GetGroup</a> in the <i>IoT
     * Greengrass API Reference</i>.
     * </p>
     * 
     * @return The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the
     *         Greengrass group. For more information about how to find a group's ARN, see <a
     *         href="https://docs.aws.amazon.com/greengrass/latest/apireference/listgroups-get.html">ListGroups</a> and
     *         <a href="https://docs.aws.amazon.com/greengrass/latest/apireference/getgroup-get.html">GetGroup</a> in
     *         the <i>IoT Greengrass API Reference</i>.
     */
    public final String groupArn() {
        return groupArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(groupArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Greengrass)) {
            return false;
        }
        Greengrass other = (Greengrass) obj;
        return Objects.equals(groupArn(), other.groupArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Greengrass").add("GroupArn", groupArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "groupArn":
            return Optional.ofNullable(clazz.cast(groupArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Greengrass, T> g) {
        return obj -> g.apply((Greengrass) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Greengrass> {
        /**
         * <p>
         * The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the
         * Greengrass group. For more information about how to find a group's ARN, see <a
         * href="https://docs.aws.amazon.com/greengrass/latest/apireference/listgroups-get.html">ListGroups</a> and <a
         * href="https://docs.aws.amazon.com/greengrass/latest/apireference/getgroup-get.html">GetGroup</a> in the
         * <i>IoT Greengrass API Reference</i>.
         * </p>
         * 
         * @param groupArn
         *        The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of
         *        the Greengrass group. For more information about how to find a group's ARN, see <a
         *        href="https://docs.aws.amazon.com/greengrass/latest/apireference/listgroups-get.html">ListGroups</a>
         *        and <a
         *        href="https://docs.aws.amazon.com/greengrass/latest/apireference/getgroup-get.html">GetGroup</a> in
         *        the <i>IoT Greengrass API Reference</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupArn(String groupArn);
    }

    static final class BuilderImpl implements Builder {
        private String groupArn;

        private BuilderImpl() {
        }

        private BuilderImpl(Greengrass model) {
            groupArn(model.groupArn);
        }

        public final String getGroupArn() {
            return groupArn;
        }

        public final void setGroupArn(String groupArn) {
            this.groupArn = groupArn;
        }

        @Override
        public final Builder groupArn(String groupArn) {
            this.groupArn = groupArn;
            return this;
        }

        @Override
        public Greengrass build() {
            return new Greengrass(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
