/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotsitewise.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.iotsitewise.IoTSiteWiseAsyncClient;
import software.amazon.awssdk.services.iotsitewise.internal.UserAgentUtils;
import software.amazon.awssdk.services.iotsitewise.model.BatchGetAssetPropertyAggregatesRequest;
import software.amazon.awssdk.services.iotsitewise.model.BatchGetAssetPropertyAggregatesResponse;

public class BatchGetAssetPropertyAggregatesPublisher
implements SdkPublisher<BatchGetAssetPropertyAggregatesResponse> {
    private final IoTSiteWiseAsyncClient client;
    private final BatchGetAssetPropertyAggregatesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public BatchGetAssetPropertyAggregatesPublisher(IoTSiteWiseAsyncClient client, BatchGetAssetPropertyAggregatesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private BatchGetAssetPropertyAggregatesPublisher(IoTSiteWiseAsyncClient client, BatchGetAssetPropertyAggregatesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new BatchGetAssetPropertyAggregatesResponseFetcher();
    }

    public void subscribe(Subscriber<? super BatchGetAssetPropertyAggregatesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class BatchGetAssetPropertyAggregatesResponseFetcher
    implements AsyncPageFetcher<BatchGetAssetPropertyAggregatesResponse> {
        private BatchGetAssetPropertyAggregatesResponseFetcher() {
        }

        public boolean hasNextPage(BatchGetAssetPropertyAggregatesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<BatchGetAssetPropertyAggregatesResponse> nextPage(BatchGetAssetPropertyAggregatesResponse previousPage) {
            if (previousPage == null) {
                return BatchGetAssetPropertyAggregatesPublisher.this.client.batchGetAssetPropertyAggregates(BatchGetAssetPropertyAggregatesPublisher.this.firstRequest);
            }
            return BatchGetAssetPropertyAggregatesPublisher.this.client.batchGetAssetPropertyAggregates((BatchGetAssetPropertyAggregatesRequest)((Object)BatchGetAssetPropertyAggregatesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

