/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotsitewise.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.iotsitewise.IoTSiteWiseAsyncClient;
import software.amazon.awssdk.services.iotsitewise.model.AssetPropertySummary;
import software.amazon.awssdk.services.iotsitewise.model.ListAssetPropertiesRequest;
import software.amazon.awssdk.services.iotsitewise.model.ListAssetPropertiesResponse;

public class ListAssetPropertiesPublisher
implements SdkPublisher<ListAssetPropertiesResponse> {
    private final IoTSiteWiseAsyncClient client;
    private final ListAssetPropertiesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListAssetPropertiesPublisher(IoTSiteWiseAsyncClient client, ListAssetPropertiesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListAssetPropertiesPublisher(IoTSiteWiseAsyncClient client, ListAssetPropertiesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListAssetPropertiesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListAssetPropertiesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<AssetPropertySummary> assetPropertySummaries() {
        Function<ListAssetPropertiesResponse, Iterator> getIterator = response -> {
            if (response != null && response.assetPropertySummaries() != null) {
                return response.assetPropertySummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListAssetPropertiesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListAssetPropertiesResponseFetcher
    implements AsyncPageFetcher<ListAssetPropertiesResponse> {
        private ListAssetPropertiesResponseFetcher() {
        }

        public boolean hasNextPage(ListAssetPropertiesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListAssetPropertiesResponse> nextPage(ListAssetPropertiesResponse previousPage) {
            if (previousPage == null) {
                return ListAssetPropertiesPublisher.this.client.listAssetProperties(ListAssetPropertiesPublisher.this.firstRequest);
            }
            return ListAssetPropertiesPublisher.this.client.listAssetProperties((ListAssetPropertiesRequest)((Object)ListAssetPropertiesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

