/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotsitewise.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iotsitewise.model.AssetModelStatus;
import software.amazon.awssdk.services.iotsitewise.model.IoTSiteWiseResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateAssetModelResponse
extends IoTSiteWiseResponse
implements ToCopyableBuilder<Builder, CreateAssetModelResponse> {
    private static final SdkField<String> ASSET_MODEL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("assetModelId").getter(CreateAssetModelResponse.getter(CreateAssetModelResponse::assetModelId)).setter(CreateAssetModelResponse.setter(Builder::assetModelId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assetModelId").build()}).build();
    private static final SdkField<String> ASSET_MODEL_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("assetModelArn").getter(CreateAssetModelResponse.getter(CreateAssetModelResponse::assetModelArn)).setter(CreateAssetModelResponse.setter(Builder::assetModelArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assetModelArn").build()}).build();
    private static final SdkField<AssetModelStatus> ASSET_MODEL_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("assetModelStatus").getter(CreateAssetModelResponse.getter(CreateAssetModelResponse::assetModelStatus)).setter(CreateAssetModelResponse.setter(Builder::assetModelStatus)).constructor(AssetModelStatus::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assetModelStatus").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSET_MODEL_ID_FIELD, ASSET_MODEL_ARN_FIELD, ASSET_MODEL_STATUS_FIELD));
    private final String assetModelId;
    private final String assetModelArn;
    private final AssetModelStatus assetModelStatus;

    private CreateAssetModelResponse(BuilderImpl builder) {
        super(builder);
        this.assetModelId = builder.assetModelId;
        this.assetModelArn = builder.assetModelArn;
        this.assetModelStatus = builder.assetModelStatus;
    }

    public final String assetModelId() {
        return this.assetModelId;
    }

    public final String assetModelArn() {
        return this.assetModelArn;
    }

    public final AssetModelStatus assetModelStatus() {
        return this.assetModelStatus;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.assetModelId());
        hashCode = 31 * hashCode + Objects.hashCode(this.assetModelArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.assetModelStatus());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateAssetModelResponse)) {
            return false;
        }
        CreateAssetModelResponse other = (CreateAssetModelResponse)((Object)obj);
        return Objects.equals(this.assetModelId(), other.assetModelId()) && Objects.equals(this.assetModelArn(), other.assetModelArn()) && Objects.equals(this.assetModelStatus(), other.assetModelStatus());
    }

    public final String toString() {
        return ToString.builder((String)"CreateAssetModelResponse").add("AssetModelId", (Object)this.assetModelId()).add("AssetModelArn", (Object)this.assetModelArn()).add("AssetModelStatus", (Object)this.assetModelStatus()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "assetModelId": {
                return Optional.ofNullable(clazz.cast(this.assetModelId()));
            }
            case "assetModelArn": {
                return Optional.ofNullable(clazz.cast(this.assetModelArn()));
            }
            case "assetModelStatus": {
                return Optional.ofNullable(clazz.cast(this.assetModelStatus()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateAssetModelResponse, T> g) {
        return obj -> g.apply((CreateAssetModelResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IoTSiteWiseResponse.BuilderImpl
    implements Builder {
        private String assetModelId;
        private String assetModelArn;
        private AssetModelStatus assetModelStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateAssetModelResponse model) {
            super(model);
            this.assetModelId(model.assetModelId);
            this.assetModelArn(model.assetModelArn);
            this.assetModelStatus(model.assetModelStatus);
        }

        public final String getAssetModelId() {
            return this.assetModelId;
        }

        @Override
        public final Builder assetModelId(String assetModelId) {
            this.assetModelId = assetModelId;
            return this;
        }

        public final void setAssetModelId(String assetModelId) {
            this.assetModelId = assetModelId;
        }

        public final String getAssetModelArn() {
            return this.assetModelArn;
        }

        @Override
        public final Builder assetModelArn(String assetModelArn) {
            this.assetModelArn = assetModelArn;
            return this;
        }

        public final void setAssetModelArn(String assetModelArn) {
            this.assetModelArn = assetModelArn;
        }

        public final AssetModelStatus.Builder getAssetModelStatus() {
            return this.assetModelStatus != null ? this.assetModelStatus.toBuilder() : null;
        }

        @Override
        public final Builder assetModelStatus(AssetModelStatus assetModelStatus) {
            this.assetModelStatus = assetModelStatus;
            return this;
        }

        public final void setAssetModelStatus(AssetModelStatus.BuilderImpl assetModelStatus) {
            this.assetModelStatus = assetModelStatus != null ? assetModelStatus.build() : null;
        }

        @Override
        public CreateAssetModelResponse build() {
            return new CreateAssetModelResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends IoTSiteWiseResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateAssetModelResponse> {
        public Builder assetModelId(String var1);

        public Builder assetModelArn(String var1);

        public Builder assetModelStatus(AssetModelStatus var1);

        default public Builder assetModelStatus(Consumer<AssetModelStatus.Builder> assetModelStatus) {
            return this.assetModelStatus((AssetModelStatus)((AssetModelStatus.Builder)AssetModelStatus.builder().applyMutation(assetModelStatus)).build());
        }
    }
}

