/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotsitewise.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iotsitewise.model.PropertyDataType;
import software.amazon.awssdk.services.iotsitewise.model.PropertyNotification;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AssetProperty
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AssetProperty> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("id").getter(AssetProperty.getter(AssetProperty::id)).setter(AssetProperty.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(AssetProperty.getter(AssetProperty::name)).setter(AssetProperty.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> ALIAS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("alias").getter(AssetProperty.getter(AssetProperty::alias)).setter(AssetProperty.setter(Builder::alias)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("alias").build()}).build();
    private static final SdkField<PropertyNotification> NOTIFICATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("notification").getter(AssetProperty.getter(AssetProperty::notification)).setter(AssetProperty.setter(Builder::notification)).constructor(PropertyNotification::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("notification").build()}).build();
    private static final SdkField<String> DATA_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("dataType").getter(AssetProperty.getter(AssetProperty::dataTypeAsString)).setter(AssetProperty.setter(Builder::dataType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataType").build()}).build();
    private static final SdkField<String> DATA_TYPE_SPEC_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("dataTypeSpec").getter(AssetProperty.getter(AssetProperty::dataTypeSpec)).setter(AssetProperty.setter(Builder::dataTypeSpec)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataTypeSpec").build()}).build();
    private static final SdkField<String> UNIT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("unit").getter(AssetProperty.getter(AssetProperty::unit)).setter(AssetProperty.setter(Builder::unit)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("unit").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, NAME_FIELD, ALIAS_FIELD, NOTIFICATION_FIELD, DATA_TYPE_FIELD, DATA_TYPE_SPEC_FIELD, UNIT_FIELD));
    private static final long serialVersionUID = 1L;
    private final String id;
    private final String name;
    private final String alias;
    private final PropertyNotification notification;
    private final String dataType;
    private final String dataTypeSpec;
    private final String unit;

    private AssetProperty(BuilderImpl builder) {
        this.id = builder.id;
        this.name = builder.name;
        this.alias = builder.alias;
        this.notification = builder.notification;
        this.dataType = builder.dataType;
        this.dataTypeSpec = builder.dataTypeSpec;
        this.unit = builder.unit;
    }

    public final String id() {
        return this.id;
    }

    public final String name() {
        return this.name;
    }

    public final String alias() {
        return this.alias;
    }

    public final PropertyNotification notification() {
        return this.notification;
    }

    public final PropertyDataType dataType() {
        return PropertyDataType.fromValue(this.dataType);
    }

    public final String dataTypeAsString() {
        return this.dataType;
    }

    public final String dataTypeSpec() {
        return this.dataTypeSpec;
    }

    public final String unit() {
        return this.unit;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.alias());
        hashCode = 31 * hashCode + Objects.hashCode(this.notification());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataTypeSpec());
        hashCode = 31 * hashCode + Objects.hashCode(this.unit());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssetProperty)) {
            return false;
        }
        AssetProperty other = (AssetProperty)obj;
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.alias(), other.alias()) && Objects.equals(this.notification(), other.notification()) && Objects.equals(this.dataTypeAsString(), other.dataTypeAsString()) && Objects.equals(this.dataTypeSpec(), other.dataTypeSpec()) && Objects.equals(this.unit(), other.unit());
    }

    public final String toString() {
        return ToString.builder((String)"AssetProperty").add("Id", (Object)this.id()).add("Name", (Object)this.name()).add("Alias", (Object)this.alias()).add("Notification", (Object)this.notification()).add("DataType", (Object)this.dataTypeAsString()).add("DataTypeSpec", (Object)this.dataTypeSpec()).add("Unit", (Object)this.unit()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "alias": {
                return Optional.ofNullable(clazz.cast(this.alias()));
            }
            case "notification": {
                return Optional.ofNullable(clazz.cast(this.notification()));
            }
            case "dataType": {
                return Optional.ofNullable(clazz.cast(this.dataTypeAsString()));
            }
            case "dataTypeSpec": {
                return Optional.ofNullable(clazz.cast(this.dataTypeSpec()));
            }
            case "unit": {
                return Optional.ofNullable(clazz.cast(this.unit()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AssetProperty, T> g) {
        return obj -> g.apply((AssetProperty)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String id;
        private String name;
        private String alias;
        private PropertyNotification notification;
        private String dataType;
        private String dataTypeSpec;
        private String unit;

        private BuilderImpl() {
        }

        private BuilderImpl(AssetProperty model) {
            this.id(model.id);
            this.name(model.name);
            this.alias(model.alias);
            this.notification(model.notification);
            this.dataType(model.dataType);
            this.dataTypeSpec(model.dataTypeSpec);
            this.unit(model.unit);
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        @Transient
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        @Transient
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getAlias() {
            return this.alias;
        }

        public final void setAlias(String alias) {
            this.alias = alias;
        }

        @Override
        @Transient
        public final Builder alias(String alias) {
            this.alias = alias;
            return this;
        }

        public final PropertyNotification.Builder getNotification() {
            return this.notification != null ? this.notification.toBuilder() : null;
        }

        public final void setNotification(PropertyNotification.BuilderImpl notification) {
            this.notification = notification != null ? notification.build() : null;
        }

        @Override
        @Transient
        public final Builder notification(PropertyNotification notification) {
            this.notification = notification;
            return this;
        }

        public final String getDataType() {
            return this.dataType;
        }

        public final void setDataType(String dataType) {
            this.dataType = dataType;
        }

        @Override
        @Transient
        public final Builder dataType(String dataType) {
            this.dataType = dataType;
            return this;
        }

        @Override
        @Transient
        public final Builder dataType(PropertyDataType dataType) {
            this.dataType(dataType == null ? null : dataType.toString());
            return this;
        }

        public final String getDataTypeSpec() {
            return this.dataTypeSpec;
        }

        public final void setDataTypeSpec(String dataTypeSpec) {
            this.dataTypeSpec = dataTypeSpec;
        }

        @Override
        @Transient
        public final Builder dataTypeSpec(String dataTypeSpec) {
            this.dataTypeSpec = dataTypeSpec;
            return this;
        }

        public final String getUnit() {
            return this.unit;
        }

        public final void setUnit(String unit) {
            this.unit = unit;
        }

        @Override
        @Transient
        public final Builder unit(String unit) {
            this.unit = unit;
            return this;
        }

        public AssetProperty build() {
            return new AssetProperty(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AssetProperty> {
        public Builder id(String var1);

        public Builder name(String var1);

        public Builder alias(String var1);

        public Builder notification(PropertyNotification var1);

        default public Builder notification(Consumer<PropertyNotification.Builder> notification) {
            return this.notification((PropertyNotification)((PropertyNotification.Builder)PropertyNotification.builder().applyMutation(notification)).build());
        }

        public Builder dataType(String var1);

        public Builder dataType(PropertyDataType var1);

        public Builder dataTypeSpec(String var1);

        public Builder unit(String var1);
    }
}

