/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotsitewise.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AssetHierarchyInfo
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AssetHierarchyInfo> {
    private static final SdkField<String> PARENT_ASSET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("parentAssetId").getter(AssetHierarchyInfo.getter(AssetHierarchyInfo::parentAssetId)).setter(AssetHierarchyInfo.setter(Builder::parentAssetId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parentAssetId").build()}).build();
    private static final SdkField<String> CHILD_ASSET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("childAssetId").getter(AssetHierarchyInfo.getter(AssetHierarchyInfo::childAssetId)).setter(AssetHierarchyInfo.setter(Builder::childAssetId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("childAssetId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PARENT_ASSET_ID_FIELD, CHILD_ASSET_ID_FIELD));
    private static final long serialVersionUID = 1L;
    private final String parentAssetId;
    private final String childAssetId;

    private AssetHierarchyInfo(BuilderImpl builder) {
        this.parentAssetId = builder.parentAssetId;
        this.childAssetId = builder.childAssetId;
    }

    public final String parentAssetId() {
        return this.parentAssetId;
    }

    public final String childAssetId() {
        return this.childAssetId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.parentAssetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.childAssetId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssetHierarchyInfo)) {
            return false;
        }
        AssetHierarchyInfo other = (AssetHierarchyInfo)obj;
        return Objects.equals(this.parentAssetId(), other.parentAssetId()) && Objects.equals(this.childAssetId(), other.childAssetId());
    }

    public final String toString() {
        return ToString.builder((String)"AssetHierarchyInfo").add("ParentAssetId", (Object)this.parentAssetId()).add("ChildAssetId", (Object)this.childAssetId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "parentAssetId": {
                return Optional.ofNullable(clazz.cast(this.parentAssetId()));
            }
            case "childAssetId": {
                return Optional.ofNullable(clazz.cast(this.childAssetId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AssetHierarchyInfo, T> g) {
        return obj -> g.apply((AssetHierarchyInfo)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String parentAssetId;
        private String childAssetId;

        private BuilderImpl() {
        }

        private BuilderImpl(AssetHierarchyInfo model) {
            this.parentAssetId(model.parentAssetId);
            this.childAssetId(model.childAssetId);
        }

        public final String getParentAssetId() {
            return this.parentAssetId;
        }

        public final void setParentAssetId(String parentAssetId) {
            this.parentAssetId = parentAssetId;
        }

        @Override
        public final Builder parentAssetId(String parentAssetId) {
            this.parentAssetId = parentAssetId;
            return this;
        }

        public final String getChildAssetId() {
            return this.childAssetId;
        }

        public final void setChildAssetId(String childAssetId) {
            this.childAssetId = childAssetId;
        }

        @Override
        public final Builder childAssetId(String childAssetId) {
            this.childAssetId = childAssetId;
            return this;
        }

        public AssetHierarchyInfo build() {
            return new AssetHierarchyInfo(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AssetHierarchyInfo> {
        public Builder parentAssetId(String var1);

        public Builder childAssetId(String var1);
    }
}

