/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotsitewise.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iotsitewise.model.IoTSiteWiseRequest;
import software.amazon.awssdk.services.iotsitewise.model.ListTimeSeriesType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListTimeSeriesRequest
extends IoTSiteWiseRequest
implements ToCopyableBuilder<Builder, ListTimeSeriesRequest> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListTimeSeriesRequest.getter(ListTimeSeriesRequest::nextToken)).setter(ListTimeSeriesRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("nextToken").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("maxResults").getter(ListTimeSeriesRequest.getter(ListTimeSeriesRequest::maxResults)).setter(ListTimeSeriesRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("maxResults").build()}).build();
    private static final SdkField<String> ASSET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("assetId").getter(ListTimeSeriesRequest.getter(ListTimeSeriesRequest::assetId)).setter(ListTimeSeriesRequest.setter(Builder::assetId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("assetId").build()}).build();
    private static final SdkField<String> ALIAS_PREFIX_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("aliasPrefix").getter(ListTimeSeriesRequest.getter(ListTimeSeriesRequest::aliasPrefix)).setter(ListTimeSeriesRequest.setter(Builder::aliasPrefix)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("aliasPrefix").build()}).build();
    private static final SdkField<String> TIME_SERIES_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("timeSeriesType").getter(ListTimeSeriesRequest.getter(ListTimeSeriesRequest::timeSeriesTypeAsString)).setter(ListTimeSeriesRequest.setter(Builder::timeSeriesType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("timeSeriesType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD, ASSET_ID_FIELD, ALIAS_PREFIX_FIELD, TIME_SERIES_TYPE_FIELD));
    private final String nextToken;
    private final Integer maxResults;
    private final String assetId;
    private final String aliasPrefix;
    private final String timeSeriesType;

    private ListTimeSeriesRequest(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
        this.assetId = builder.assetId;
        this.aliasPrefix = builder.aliasPrefix;
        this.timeSeriesType = builder.timeSeriesType;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final String assetId() {
        return this.assetId;
    }

    public final String aliasPrefix() {
        return this.aliasPrefix;
    }

    public final ListTimeSeriesType timeSeriesType() {
        return ListTimeSeriesType.fromValue(this.timeSeriesType);
    }

    public final String timeSeriesTypeAsString() {
        return this.timeSeriesType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.assetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.aliasPrefix());
        hashCode = 31 * hashCode + Objects.hashCode(this.timeSeriesTypeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTimeSeriesRequest)) {
            return false;
        }
        ListTimeSeriesRequest other = (ListTimeSeriesRequest)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.assetId(), other.assetId()) && Objects.equals(this.aliasPrefix(), other.aliasPrefix()) && Objects.equals(this.timeSeriesTypeAsString(), other.timeSeriesTypeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"ListTimeSeriesRequest").add("NextToken", (Object)this.nextToken()).add("MaxResults", (Object)this.maxResults()).add("AssetId", (Object)this.assetId()).add("AliasPrefix", (Object)this.aliasPrefix()).add("TimeSeriesType", (Object)this.timeSeriesTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "maxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "assetId": {
                return Optional.ofNullable(clazz.cast(this.assetId()));
            }
            case "aliasPrefix": {
                return Optional.ofNullable(clazz.cast(this.aliasPrefix()));
            }
            case "timeSeriesType": {
                return Optional.ofNullable(clazz.cast(this.timeSeriesTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListTimeSeriesRequest, T> g) {
        return obj -> g.apply((ListTimeSeriesRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IoTSiteWiseRequest.BuilderImpl
    implements Builder {
        private String nextToken;
        private Integer maxResults;
        private String assetId;
        private String aliasPrefix;
        private String timeSeriesType;

        private BuilderImpl() {
        }

        private BuilderImpl(ListTimeSeriesRequest model) {
            super(model);
            this.nextToken(model.nextToken);
            this.maxResults(model.maxResults);
            this.assetId(model.assetId);
            this.aliasPrefix(model.aliasPrefix);
            this.timeSeriesType(model.timeSeriesType);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getAssetId() {
            return this.assetId;
        }

        public final void setAssetId(String assetId) {
            this.assetId = assetId;
        }

        @Override
        public final Builder assetId(String assetId) {
            this.assetId = assetId;
            return this;
        }

        public final String getAliasPrefix() {
            return this.aliasPrefix;
        }

        public final void setAliasPrefix(String aliasPrefix) {
            this.aliasPrefix = aliasPrefix;
        }

        @Override
        public final Builder aliasPrefix(String aliasPrefix) {
            this.aliasPrefix = aliasPrefix;
            return this;
        }

        public final String getTimeSeriesType() {
            return this.timeSeriesType;
        }

        public final void setTimeSeriesType(String timeSeriesType) {
            this.timeSeriesType = timeSeriesType;
        }

        @Override
        public final Builder timeSeriesType(String timeSeriesType) {
            this.timeSeriesType = timeSeriesType;
            return this;
        }

        @Override
        public final Builder timeSeriesType(ListTimeSeriesType timeSeriesType) {
            this.timeSeriesType(timeSeriesType == null ? null : timeSeriesType.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListTimeSeriesRequest build() {
            return new ListTimeSeriesRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends IoTSiteWiseRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListTimeSeriesRequest> {
        public Builder nextToken(String var1);

        public Builder maxResults(Integer var1);

        public Builder assetId(String var1);

        public Builder aliasPrefix(String var1);

        public Builder timeSeriesType(String var1);

        public Builder timeSeriesType(ListTimeSeriesType var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

