/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotsitewise.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.iotsitewise.IoTSiteWiseClient;
import software.amazon.awssdk.services.iotsitewise.model.BatchGetAssetPropertyAggregatesRequest;
import software.amazon.awssdk.services.iotsitewise.model.BatchGetAssetPropertyAggregatesResponse;

public class BatchGetAssetPropertyAggregatesIterable
implements SdkIterable<BatchGetAssetPropertyAggregatesResponse> {
    private final IoTSiteWiseClient client;
    private final BatchGetAssetPropertyAggregatesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public BatchGetAssetPropertyAggregatesIterable(IoTSiteWiseClient client, BatchGetAssetPropertyAggregatesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new BatchGetAssetPropertyAggregatesResponseFetcher();
    }

    public Iterator<BatchGetAssetPropertyAggregatesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class BatchGetAssetPropertyAggregatesResponseFetcher
    implements SyncPageFetcher<BatchGetAssetPropertyAggregatesResponse> {
        private BatchGetAssetPropertyAggregatesResponseFetcher() {
        }

        public boolean hasNextPage(BatchGetAssetPropertyAggregatesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public BatchGetAssetPropertyAggregatesResponse nextPage(BatchGetAssetPropertyAggregatesResponse previousPage) {
            if (previousPage == null) {
                return BatchGetAssetPropertyAggregatesIterable.this.client.batchGetAssetPropertyAggregates(BatchGetAssetPropertyAggregatesIterable.this.firstRequest);
            }
            return BatchGetAssetPropertyAggregatesIterable.this.client.batchGetAssetPropertyAggregates((BatchGetAssetPropertyAggregatesRequest)((Object)BatchGetAssetPropertyAggregatesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

