/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotsitewise.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.iotsitewise.model.IoTSiteWiseResponse;
import software.amazon.awssdk.services.iotsitewise.model.TimeSeriesSummariesCopier;
import software.amazon.awssdk.services.iotsitewise.model.TimeSeriesSummary;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListTimeSeriesResponse
extends IoTSiteWiseResponse
implements ToCopyableBuilder<Builder, ListTimeSeriesResponse> {
    private static final SdkField<List<TimeSeriesSummary>> TIME_SERIES_SUMMARIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TimeSeriesSummaries").getter(ListTimeSeriesResponse.getter(ListTimeSeriesResponse::timeSeriesSummaries)).setter(ListTimeSeriesResponse.setter(Builder::timeSeriesSummaries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimeSeriesSummaries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TimeSeriesSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListTimeSeriesResponse.getter(ListTimeSeriesResponse::nextToken)).setter(ListTimeSeriesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TIME_SERIES_SUMMARIES_FIELD, NEXT_TOKEN_FIELD));
    private final List<TimeSeriesSummary> timeSeriesSummaries;
    private final String nextToken;

    private ListTimeSeriesResponse(BuilderImpl builder) {
        super(builder);
        this.timeSeriesSummaries = builder.timeSeriesSummaries;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasTimeSeriesSummaries() {
        return this.timeSeriesSummaries != null && !(this.timeSeriesSummaries instanceof SdkAutoConstructList);
    }

    public final List<TimeSeriesSummary> timeSeriesSummaries() {
        return this.timeSeriesSummaries;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTimeSeriesSummaries() ? this.timeSeriesSummaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTimeSeriesResponse)) {
            return false;
        }
        ListTimeSeriesResponse other = (ListTimeSeriesResponse)((Object)obj);
        return this.hasTimeSeriesSummaries() == other.hasTimeSeriesSummaries() && Objects.equals(this.timeSeriesSummaries(), other.timeSeriesSummaries()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListTimeSeriesResponse").add("TimeSeriesSummaries", this.hasTimeSeriesSummaries() ? this.timeSeriesSummaries() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TimeSeriesSummaries": {
                return Optional.ofNullable(clazz.cast(this.timeSeriesSummaries()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListTimeSeriesResponse, T> g) {
        return obj -> g.apply((ListTimeSeriesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IoTSiteWiseResponse.BuilderImpl
    implements Builder {
        private List<TimeSeriesSummary> timeSeriesSummaries = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListTimeSeriesResponse model) {
            super(model);
            this.timeSeriesSummaries(model.timeSeriesSummaries);
            this.nextToken(model.nextToken);
        }

        public final List<TimeSeriesSummary.Builder> getTimeSeriesSummaries() {
            List<TimeSeriesSummary.Builder> result = TimeSeriesSummariesCopier.copyToBuilder(this.timeSeriesSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTimeSeriesSummaries(Collection<TimeSeriesSummary.BuilderImpl> timeSeriesSummaries) {
            this.timeSeriesSummaries = TimeSeriesSummariesCopier.copyFromBuilder(timeSeriesSummaries);
        }

        @Override
        @Transient
        public final Builder timeSeriesSummaries(Collection<TimeSeriesSummary> timeSeriesSummaries) {
            this.timeSeriesSummaries = TimeSeriesSummariesCopier.copy(timeSeriesSummaries);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder timeSeriesSummaries(TimeSeriesSummary ... timeSeriesSummaries) {
            this.timeSeriesSummaries(Arrays.asList(timeSeriesSummaries));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder timeSeriesSummaries(Consumer<TimeSeriesSummary.Builder> ... timeSeriesSummaries) {
            this.timeSeriesSummaries(Stream.of(timeSeriesSummaries).map(c -> (TimeSeriesSummary)((TimeSeriesSummary.Builder)TimeSeriesSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListTimeSeriesResponse build() {
            return new ListTimeSeriesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends IoTSiteWiseResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListTimeSeriesResponse> {
        public Builder timeSeriesSummaries(Collection<TimeSeriesSummary> var1);

        public Builder timeSeriesSummaries(TimeSeriesSummary ... var1);

        public Builder timeSeriesSummaries(Consumer<TimeSeriesSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

