/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotsitewise.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateDashboardRequest extends IoTSiteWiseRequest implements
        ToCopyableBuilder<UpdateDashboardRequest.Builder, UpdateDashboardRequest> {
    private static final SdkField<String> DASHBOARD_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("dashboardId").getter(getter(UpdateDashboardRequest::dashboardId)).setter(setter(Builder::dashboardId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("dashboardId").build()).build();

    private static final SdkField<String> DASHBOARD_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("dashboardName").getter(getter(UpdateDashboardRequest::dashboardName))
            .setter(setter(Builder::dashboardName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dashboardName").build()).build();

    private static final SdkField<String> DASHBOARD_DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("dashboardDescription").getter(getter(UpdateDashboardRequest::dashboardDescription))
            .setter(setter(Builder::dashboardDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dashboardDescription").build())
            .build();

    private static final SdkField<String> DASHBOARD_DEFINITION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("dashboardDefinition").getter(getter(UpdateDashboardRequest::dashboardDefinition))
            .setter(setter(Builder::dashboardDefinition))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dashboardDefinition").build())
            .build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("clientToken")
            .getter(getter(UpdateDashboardRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DASHBOARD_ID_FIELD,
            DASHBOARD_NAME_FIELD, DASHBOARD_DESCRIPTION_FIELD, DASHBOARD_DEFINITION_FIELD, CLIENT_TOKEN_FIELD));

    private final String dashboardId;

    private final String dashboardName;

    private final String dashboardDescription;

    private final String dashboardDefinition;

    private final String clientToken;

    private UpdateDashboardRequest(BuilderImpl builder) {
        super(builder);
        this.dashboardId = builder.dashboardId;
        this.dashboardName = builder.dashboardName;
        this.dashboardDescription = builder.dashboardDescription;
        this.dashboardDefinition = builder.dashboardDefinition;
        this.clientToken = builder.clientToken;
    }

    /**
     * <p>
     * The ID of the dashboard to update.
     * </p>
     * 
     * @return The ID of the dashboard to update.
     */
    public final String dashboardId() {
        return dashboardId;
    }

    /**
     * <p>
     * A new friendly name for the dashboard.
     * </p>
     * 
     * @return A new friendly name for the dashboard.
     */
    public final String dashboardName() {
        return dashboardName;
    }

    /**
     * <p>
     * A new description for the dashboard.
     * </p>
     * 
     * @return A new description for the dashboard.
     */
    public final String dashboardDescription() {
        return dashboardDescription;
    }

    /**
     * <p>
     * The new dashboard definition, as specified in a JSON literal. For detailed information, see <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/create-dashboards-using-aws-cli.html">Creating
     * dashboards (CLI)</a> in the <i>AWS IoT SiteWise User Guide</i>.
     * </p>
     * 
     * @return The new dashboard definition, as specified in a JSON literal. For detailed information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/create-dashboards-using-aws-cli.html"
     *         >Creating dashboards (CLI)</a> in the <i>AWS IoT SiteWise User Guide</i>.
     */
    public final String dashboardDefinition() {
        return dashboardDefinition;
    }

    /**
     * <p>
     * A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don't reuse
     * this client token if a new idempotent request is required.
     * </p>
     * 
     * @return A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don't
     *         reuse this client token if a new idempotent request is required.
     */
    public final String clientToken() {
        return clientToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(dashboardId());
        hashCode = 31 * hashCode + Objects.hashCode(dashboardName());
        hashCode = 31 * hashCode + Objects.hashCode(dashboardDescription());
        hashCode = 31 * hashCode + Objects.hashCode(dashboardDefinition());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateDashboardRequest)) {
            return false;
        }
        UpdateDashboardRequest other = (UpdateDashboardRequest) obj;
        return Objects.equals(dashboardId(), other.dashboardId()) && Objects.equals(dashboardName(), other.dashboardName())
                && Objects.equals(dashboardDescription(), other.dashboardDescription())
                && Objects.equals(dashboardDefinition(), other.dashboardDefinition())
                && Objects.equals(clientToken(), other.clientToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateDashboardRequest").add("DashboardId", dashboardId()).add("DashboardName", dashboardName())
                .add("DashboardDescription", dashboardDescription()).add("DashboardDefinition", dashboardDefinition())
                .add("ClientToken", clientToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "dashboardId":
            return Optional.ofNullable(clazz.cast(dashboardId()));
        case "dashboardName":
            return Optional.ofNullable(clazz.cast(dashboardName()));
        case "dashboardDescription":
            return Optional.ofNullable(clazz.cast(dashboardDescription()));
        case "dashboardDefinition":
            return Optional.ofNullable(clazz.cast(dashboardDefinition()));
        case "clientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateDashboardRequest, T> g) {
        return obj -> g.apply((UpdateDashboardRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IoTSiteWiseRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateDashboardRequest> {
        /**
         * <p>
         * The ID of the dashboard to update.
         * </p>
         * 
         * @param dashboardId
         *        The ID of the dashboard to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dashboardId(String dashboardId);

        /**
         * <p>
         * A new friendly name for the dashboard.
         * </p>
         * 
         * @param dashboardName
         *        A new friendly name for the dashboard.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dashboardName(String dashboardName);

        /**
         * <p>
         * A new description for the dashboard.
         * </p>
         * 
         * @param dashboardDescription
         *        A new description for the dashboard.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dashboardDescription(String dashboardDescription);

        /**
         * <p>
         * The new dashboard definition, as specified in a JSON literal. For detailed information, see <a
         * href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/create-dashboards-using-aws-cli.html"
         * >Creating dashboards (CLI)</a> in the <i>AWS IoT SiteWise User Guide</i>.
         * </p>
         * 
         * @param dashboardDefinition
         *        The new dashboard definition, as specified in a JSON literal. For detailed information, see <a href=
         *        "https://docs.aws.amazon.com/iot-sitewise/latest/userguide/create-dashboards-using-aws-cli.html"
         *        >Creating dashboards (CLI)</a> in the <i>AWS IoT SiteWise User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dashboardDefinition(String dashboardDefinition);

        /**
         * <p>
         * A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don't reuse
         * this client token if a new idempotent request is required.
         * </p>
         * 
         * @param clientToken
         *        A unique case-sensitive identifier that you can provide to ensure the idempotency of the request.
         *        Don't reuse this client token if a new idempotent request is required.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends IoTSiteWiseRequest.BuilderImpl implements Builder {
        private String dashboardId;

        private String dashboardName;

        private String dashboardDescription;

        private String dashboardDefinition;

        private String clientToken;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateDashboardRequest model) {
            super(model);
            dashboardId(model.dashboardId);
            dashboardName(model.dashboardName);
            dashboardDescription(model.dashboardDescription);
            dashboardDefinition(model.dashboardDefinition);
            clientToken(model.clientToken);
        }

        public final String getDashboardId() {
            return dashboardId;
        }

        @Override
        public final Builder dashboardId(String dashboardId) {
            this.dashboardId = dashboardId;
            return this;
        }

        public final void setDashboardId(String dashboardId) {
            this.dashboardId = dashboardId;
        }

        public final String getDashboardName() {
            return dashboardName;
        }

        @Override
        public final Builder dashboardName(String dashboardName) {
            this.dashboardName = dashboardName;
            return this;
        }

        public final void setDashboardName(String dashboardName) {
            this.dashboardName = dashboardName;
        }

        public final String getDashboardDescription() {
            return dashboardDescription;
        }

        @Override
        public final Builder dashboardDescription(String dashboardDescription) {
            this.dashboardDescription = dashboardDescription;
            return this;
        }

        public final void setDashboardDescription(String dashboardDescription) {
            this.dashboardDescription = dashboardDescription;
        }

        public final String getDashboardDefinition() {
            return dashboardDefinition;
        }

        @Override
        public final Builder dashboardDefinition(String dashboardDefinition) {
            this.dashboardDefinition = dashboardDefinition;
            return this;
        }

        public final void setDashboardDefinition(String dashboardDefinition) {
            this.dashboardDefinition = dashboardDefinition;
        }

        public final String getClientToken() {
            return clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateDashboardRequest build() {
            return new UpdateDashboardRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
