/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotsitewise.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListPortalsResponse extends IoTSiteWiseResponse implements
        ToCopyableBuilder<ListPortalsResponse.Builder, ListPortalsResponse> {
    private static final SdkField<List<PortalSummary>> PORTAL_SUMMARIES_FIELD = SdkField
            .<List<PortalSummary>> builder(MarshallingType.LIST)
            .memberName("portalSummaries")
            .getter(getter(ListPortalsResponse::portalSummaries))
            .setter(setter(Builder::portalSummaries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("portalSummaries").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<PortalSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(PortalSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListPortalsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PORTAL_SUMMARIES_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<PortalSummary> portalSummaries;

    private final String nextToken;

    private ListPortalsResponse(BuilderImpl builder) {
        super(builder);
        this.portalSummaries = builder.portalSummaries;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the PortalSummaries property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasPortalSummaries() {
        return portalSummaries != null && !(portalSummaries instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list that summarizes each portal.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasPortalSummaries()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list that summarizes each portal.
     */
    public final List<PortalSummary> portalSummaries() {
        return portalSummaries;
    }

    /**
     * <p>
     * The token for the next set of results, or null if there are no additional results.
     * </p>
     * 
     * @return The token for the next set of results, or null if there are no additional results.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasPortalSummaries() ? portalSummaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListPortalsResponse)) {
            return false;
        }
        ListPortalsResponse other = (ListPortalsResponse) obj;
        return hasPortalSummaries() == other.hasPortalSummaries() && Objects.equals(portalSummaries(), other.portalSummaries())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListPortalsResponse").add("PortalSummaries", hasPortalSummaries() ? portalSummaries() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "portalSummaries":
            return Optional.ofNullable(clazz.cast(portalSummaries()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListPortalsResponse, T> g) {
        return obj -> g.apply((ListPortalsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IoTSiteWiseResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListPortalsResponse> {
        /**
         * <p>
         * A list that summarizes each portal.
         * </p>
         * 
         * @param portalSummaries
         *        A list that summarizes each portal.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder portalSummaries(Collection<PortalSummary> portalSummaries);

        /**
         * <p>
         * A list that summarizes each portal.
         * </p>
         * 
         * @param portalSummaries
         *        A list that summarizes each portal.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder portalSummaries(PortalSummary... portalSummaries);

        /**
         * <p>
         * A list that summarizes each portal.
         * </p>
         * This is a convenience that creates an instance of the {@link List<PortalSummary>.Builder} avoiding the need
         * to create one manually via {@link List<PortalSummary>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<PortalSummary>.Builder#build()} is called immediately and
         * its result is passed to {@link #portalSummaries(List<PortalSummary>)}.
         * 
         * @param portalSummaries
         *        a consumer that will call methods on {@link List<PortalSummary>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #portalSummaries(List<PortalSummary>)
         */
        Builder portalSummaries(Consumer<PortalSummary.Builder>... portalSummaries);

        /**
         * <p>
         * The token for the next set of results, or null if there are no additional results.
         * </p>
         * 
         * @param nextToken
         *        The token for the next set of results, or null if there are no additional results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends IoTSiteWiseResponse.BuilderImpl implements Builder {
        private List<PortalSummary> portalSummaries = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListPortalsResponse model) {
            super(model);
            portalSummaries(model.portalSummaries);
            nextToken(model.nextToken);
        }

        public final Collection<PortalSummary.Builder> getPortalSummaries() {
            if (portalSummaries instanceof SdkAutoConstructList) {
                return null;
            }
            return portalSummaries != null ? portalSummaries.stream().map(PortalSummary::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder portalSummaries(Collection<PortalSummary> portalSummaries) {
            this.portalSummaries = PortalSummariesCopier.copy(portalSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder portalSummaries(PortalSummary... portalSummaries) {
            portalSummaries(Arrays.asList(portalSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder portalSummaries(Consumer<PortalSummary.Builder>... portalSummaries) {
            portalSummaries(Stream.of(portalSummaries).map(c -> PortalSummary.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setPortalSummaries(Collection<PortalSummary.BuilderImpl> portalSummaries) {
            this.portalSummaries = PortalSummariesCopier.copyFromBuilder(portalSummaries);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListPortalsResponse build() {
            return new ListPortalsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
